import {BrowserWindow} from 'electron';

export interface Options {
	/**
	 * Default: [Only in development](https://github.com/sindresorhus/electron-is-dev)
	 */
	readonly enabled?: boolean;

	/**
	 * Show DevTools on each created `BrowserWindow`.
	 *
	 * @default true
	 */
	readonly showDevTools?: boolean;

	/**
	 * The dock state to open DevTools in.
	 *
	 * @default 'undocked'
	 */
	readonly devToolsMode?: 'undocked' | 'right' | 'bottom' | 'previous' | 'detach';
}

/**
 * Install keyboard shortcuts and optionally activate DevTools on each created `BrowserWindow`.
 *
 * @example
 *
 * import {app, BrowserWindow} from 'electron';
 * import electronDebug from 'electron-debug';
 *
 * electronDebug();
 *
 * let win;
 * (async () => {
 * 	await app.whenReady();
 * 	win = new BrowserWindow();
 * });
 */
export default function electronDebug(options?: Options): void;

/**
 * Reload the specified `BrowserWindow` instance or the focused one.
 *
 * @param window - Default: `BrowserWindow.getFocusedWindow()`
 */
export function refresh(window?: BrowserWindow): void;

/**
 * Toggle DevTools for the specified `BrowserWindow` instance or the focused one.
 *
 * @param window - Default: `BrowserWindow.getFocusedWindow()`
 */
export function devTools(window?: BrowserWindow): void;

/**
 * Open DevTools for the specified `BrowserWindow` instance or the focused one.
 *
 * @param window - Default: `BrowserWindow.getFocusedWindow()`
 */
export function openDevTools(window?: BrowserWindow): void;
