(function() {
  var cloneObject, ipcHelpers;

  ipcHelpers = require('./ipc-helpers');

  cloneObject = function(object) {
    var clone, key, value;
    clone = {};
    for (key in object) {
      value = object[key];
      clone[key] = value;
    }
    return clone;
  };

  module.exports = function(arg) {
    var ApplicationDelegate, AtomEnvironment, Clipboard, CompileCache, FindParentDir, TextEditor, blobStore, buildAtomEnvironment, buildDefaultApplicationDelegate, clipboard, env, error, exitWithStatusCode, exportsPath, getWindowLoadSettings, handleKeydown, headless, ipcRenderer, legacyTestRunner, legacyTestRunnerPath, logFile, packageMetadata, packageRoot, path, promise, ref, ref1, remote, startCrashReporter, testPaths, testRunner, testRunnerPath, updateProcessEnv;
    blobStore = arg.blobStore;
    startCrashReporter = require('./crash-reporter-start');
    remote = require('electron').remote;
    startCrashReporter();
    exitWithStatusCode = function(status) {
      remote.app.emit('will-quit');
      return remote.process.exit(status);
    };
    try {
      path = require('path');
      ipcRenderer = require('electron').ipcRenderer;
      getWindowLoadSettings = require('./get-window-load-settings');
      CompileCache = require('./compile-cache');
      AtomEnvironment = require('../src/atom-environment');
      ApplicationDelegate = require('../src/application-delegate');
      Clipboard = require('../src/clipboard');
      TextEditor = require('../src/text-editor');
      updateProcessEnv = require('./update-process-env').updateProcessEnv;
      require('./electron-shims');
      ipcRenderer.on('environment', function(event, env) {
        return updateProcessEnv(env);
      });
      ref = getWindowLoadSettings(), testRunnerPath = ref.testRunnerPath, legacyTestRunnerPath = ref.legacyTestRunnerPath, headless = ref.headless, logFile = ref.logFile, testPaths = ref.testPaths, env = ref.env;
      if (!headless) {
        remote.getCurrentWindow().show();
      }
      handleKeydown = function(event) {
        if ((event.metaKey || event.ctrlKey) && event.keyCode === 82) {
          ipcHelpers.call('window-method', 'reload');
        }
        if (event.keyCode === 73 && ((process.platform === 'darwin' && event.metaKey && event.altKey) || (process.platform !== 'darwin' && event.ctrlKey && event.shiftKey))) {
          ipcHelpers.call('window-method', 'toggleDevTools');
        }
        if ((event.metaKey || event.ctrlKey) && event.keyCode === 87) {
          ipcHelpers.call('window-method', 'close');
        }
        if ((event.metaKey || event.ctrlKey) && event.keyCode === 67) {
          return ipcHelpers.call('window-method', 'copy');
        }
      };
      window.addEventListener('keydown', handleKeydown, true);
      exportsPath = path.join(getWindowLoadSettings().resourcePath, 'exports');
      require('module').globalPaths.push(exportsPath);
      process.env.NODE_PATH = exportsPath;
      updateProcessEnv(env);
      FindParentDir = require('find-parent-dir');
      if (packageRoot = FindParentDir.sync(testPaths[0], 'package.json')) {
        packageMetadata = require(path.join(packageRoot, 'package.json'));
        if (packageMetadata.atomTranspilers) {
          CompileCache.addTranspilerConfigForPath(packageRoot, packageMetadata.name, packageMetadata, packageMetadata.atomTranspilers);
        }
      }
      document.title = "Spec Suite";
      clipboard = new Clipboard;
      TextEditor.setClipboard(clipboard);
      TextEditor.viewForItem = function(item) {
        return atom.views.getView(item);
      };
      testRunner = require(testRunnerPath);
      legacyTestRunner = require(legacyTestRunnerPath);
      buildDefaultApplicationDelegate = function() {
        return new ApplicationDelegate();
      };
      buildAtomEnvironment = function(params) {
        var atomEnvironment;
        params = cloneObject(params);
        if (!params.hasOwnProperty("clipboard")) {
          params.clipboard = clipboard;
        }
        if (!params.hasOwnProperty("blobStore")) {
          params.blobStore = blobStore;
        }
        if (!params.hasOwnProperty("onlyLoadBaseStyleSheets")) {
          params.onlyLoadBaseStyleSheets = true;
        }
        atomEnvironment = new AtomEnvironment(params);
        atomEnvironment.initialize(params);
        TextEditor.setScheduler(atomEnvironment.views);
        return atomEnvironment;
      };
      promise = testRunner({
        logFile: logFile,
        headless: headless,
        testPaths: testPaths,
        buildAtomEnvironment: buildAtomEnvironment,
        buildDefaultApplicationDelegate: buildDefaultApplicationDelegate,
        legacyTestRunner: legacyTestRunner
      });
      return promise.then(function(statusCode) {
        if (getWindowLoadSettings().headless) {
          return exitWithStatusCode(statusCode);
        }
      });
    } catch (error1) {
      error = error1;
      if (getWindowLoadSettings().headless) {
        console.error((ref1 = error.stack) != null ? ref1 : error);
        return exitWithStatusCode(1);
      } else {
        throw error;
      }
    }
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
