(function() {
  var Grim, buildReporter, buildTerminalReporter, disableFocusMethods, fs, ipcRenderer, path, requireSpecs, setSpecDirectory, setSpecField, setSpecType, temp;

  Grim = require('grim');

  fs = require('fs-plus');

  temp = require('temp');

  path = require('path');

  ipcRenderer = require('electron').ipcRenderer;

  temp.track();

  module.exports = function(arg) {
    var ApplicationDelegate, TimeReporter, applicationDelegate, atomHome, buildAtomEnvironment, documentTitle, headless, i, j, jasmineContent, jasmineEnv, key, len, len1, loadablePack, logFile, packName, promise, ref, resolveWithExitCode, testPackages, testPath, testPaths, userHome, userPack, value;
    logFile = arg.logFile, headless = arg.headless, testPaths = arg.testPaths, buildAtomEnvironment = arg.buildAtomEnvironment;
    ref = require('../vendor/jasmine');
    for (key in ref) {
      value = ref[key];
      window[key] = value;
    }
    require('jasmine-tagged');
    if (process.env.TEST_JUNIT_XML_PATH) {
      require('jasmine-reporters');
      jasmine.getEnv().addReporter(new jasmine.JUnitXmlReporter(process.env.TEST_JUNIT_XML_PATH, true, true));
    }
    documentTitle = null;
    Object.defineProperty(document, 'title', {
      get: function() {
        return documentTitle;
      },
      set: function(title) {
        return documentTitle = title;
      }
    });
    userHome = process.env.ATOM_HOME || path.join(fs.getHomeDirectory(), '.atom');
    atomHome = temp.mkdirSync({
      prefix: 'atom-test-home-'
    });
    if (process.env.APM_TEST_PACKAGES) {
      testPackages = process.env.APM_TEST_PACKAGES.split(/\s+/);
      fs.makeTreeSync(path.join(atomHome, 'packages'));
      for (i = 0, len = testPackages.length; i < len; i++) {
        packName = testPackages[i];
        userPack = path.join(userHome, 'packages', packName);
        loadablePack = path.join(atomHome, 'packages', packName);
        try {
          fs.symlinkSync(userPack, loadablePack, 'dir');
        } catch (error1) {
          fs.copySync(userPack, loadablePack);
        }
      }
    }
    ApplicationDelegate = require('../src/application-delegate');
    applicationDelegate = new ApplicationDelegate();
    applicationDelegate.setRepresentedFilename = function() {};
    applicationDelegate.setWindowDocumentEdited = function() {};
    window.atom = buildAtomEnvironment({
      applicationDelegate: applicationDelegate,
      window: window,
      document: document,
      configDirPath: atomHome,
      enablePersistence: false
    });
    require('./spec-helper');
    if (process.env.JANKY_SHA1 || process.env.CI) {
      disableFocusMethods();
    }
    for (j = 0, len1 = testPaths.length; j < len1; j++) {
      testPath = testPaths[j];
      requireSpecs(testPath);
    }
    setSpecType('user');
    resolveWithExitCode = null;
    promise = new Promise(function(resolve, reject) {
      return resolveWithExitCode = resolve;
    });
    jasmineEnv = jasmine.getEnv();
    jasmineEnv.addReporter(buildReporter({
      logFile: logFile,
      headless: headless,
      resolveWithExitCode: resolveWithExitCode
    }));
    TimeReporter = require('./time-reporter');
    jasmineEnv.addReporter(new TimeReporter());
    jasmineEnv.setIncludedTags([process.platform]);
    jasmineContent = document.createElement('div');
    jasmineContent.setAttribute('id', 'jasmine-content');
    document.body.appendChild(jasmineContent);
    jasmineEnv.execute();
    return promise;
  };

  disableFocusMethods = function() {
    return ['fdescribe', 'ffdescribe', 'fffdescribe', 'fit', 'ffit', 'fffit'].forEach(function(methodName) {
      var focusMethod;
      focusMethod = window[methodName];
      return window[methodName] = function(description) {
        var error;
        error = new Error('Focused spec is running on CI');
        return focusMethod(description, function() {
          throw error;
        });
      };
    });
  };

  requireSpecs = function(testPath, specType) {
    var i, len, ref, results, testFilePath;
    if (fs.isDirectorySync(testPath)) {
      ref = fs.listTreeSync(testPath);
      results = [];
      for (i = 0, len = ref.length; i < len; i++) {
        testFilePath = ref[i];
        if (!(/-spec\.(coffee|js)$/.test(testFilePath))) {
          continue;
        }
        require(testFilePath);
        results.push(setSpecDirectory(testPath));
      }
      return results;
    } else {
      require(testPath);
      return setSpecDirectory(path.dirname(testPath));
    }
  };

  setSpecField = function(name, value) {
    var i, index, ref, results, specs;
    specs = jasmine.getEnv().currentRunner().specs();
    if (specs.length === 0) {
      return;
    }
    results = [];
    for (index = i = ref = specs.length - 1; ref <= 0 ? i <= 0 : i >= 0; index = ref <= 0 ? ++i : --i) {
      if (specs[index][name] != null) {
        break;
      }
      results.push(specs[index][name] = value);
    }
    return results;
  };

  setSpecType = function(specType) {
    return setSpecField('specType', specType);
  };

  setSpecDirectory = function(specDirectory) {
    return setSpecField('specDirectory', specDirectory);
  };

  buildReporter = function(arg) {
    var AtomReporter, headless, logFile, reporter, resolveWithExitCode;
    logFile = arg.logFile, headless = arg.headless, resolveWithExitCode = arg.resolveWithExitCode;
    if (headless) {
      return buildTerminalReporter(logFile, resolveWithExitCode);
    } else {
      AtomReporter = require('./atom-reporter');
      return reporter = new AtomReporter();
    }
  };

  buildTerminalReporter = function(logFile, resolveWithExitCode) {
    var JasmineListReporter, TerminalReporter, log, logStream, options;
    if (logFile != null) {
      logStream = fs.openSync(logFile, 'w');
    }
    log = function(str) {
      if (logStream != null) {
        return fs.writeSync(logStream, str);
      } else {
        return ipcRenderer.send('write-to-stderr', str);
      }
    };
    options = {
      print: function(str) {
        return log(str);
      },
      onComplete: function(runner) {
        if (logStream != null) {
          fs.closeSync(logStream);
        }
        if (Grim.getDeprecationsLength() > 0) {
          Grim.logDeprecations();
          resolveWithExitCode(1);
          return;
        }
        if (runner.results().failedCount > 0) {
          return resolveWithExitCode(1);
        } else {
          return resolveWithExitCode(0);
        }
      }
    };
    if (process.env.ATOM_JASMINE_REPORTER === 'list') {
      JasmineListReporter = require('./jasmine-list-reporter').JasmineListReporter;
      return new JasmineListReporter(options);
    } else {
      TerminalReporter = require('jasmine-tagged').TerminalReporter;
      return new TerminalReporter(options);
    }
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
