/**
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 * 
 * @format
 */
'use strict';

var invariant = require("fbjs/lib/invariant");

var isRelayEnvironment = require("./isRelayEnvironment");

var isRelayVariables = require("./isRelayVariables");

/**
 * Asserts that the input is a matches the `RelayContext` type defined in
 * `RelayEnvironmentTypes` and returns it as that type.
 */
function assertRelayContext(relay) {
  !isRelayContext(relay) ? process.env.NODE_ENV !== "production" ? invariant(false, 'RelayContext: Expected `context.relay` to be an object conforming to ' + 'the `RelayContext` interface, got `%s`.', relay) : invariant(false) : void 0;
  return relay;
}
/**
 * Determine if the input is a plain object that matches the `RelayContext`
 * type defined in `RelayEnvironmentTypes`.
 */


function isRelayContext(context) {
  return typeof context === 'object' && context !== null && !Array.isArray(context) && isRelayEnvironment(context.environment) && isRelayVariables(context.variables);
}

module.exports = {
  assertRelayContext: assertRelayContext,
  isRelayContext: isRelayContext
};