"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.BareCommitsView = void 0;

var _react = _interopRequireDefault(require("react"));

var _reactRelay = require("react-relay");

var _propTypes = _interopRequireDefault(require("prop-types"));

var _octicon = _interopRequireDefault(require("../../atom/octicon"));

var _commitView = _interopRequireDefault(require("./commit-view"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class BareCommitsView extends _react.default.Component {
  render() {
    return _react.default.createElement("div", {
      className: "timeline-item commits"
    }, this.renderSummary(), this.renderCommits());
  }

  renderSummary() {
    if (this.props.nodes.length > 1) {
      const namesString = this.calculateNames(this.props.nodes);
      return _react.default.createElement("div", {
        className: "info-row"
      }, _react.default.createElement(_octicon.default, {
        className: "pre-timeline-item-icon",
        icon: "repo-push"
      }), _react.default.createElement("span", {
        className: "comment-message-header"
      }, namesString, " added some commits..."));
    } else {
      return null;
    }
  }

  renderCommits() {
    return this.props.nodes.map(node => {
      return _react.default.createElement(_commitView.default, {
        key: node.id,
        commit: node,
        onBranch: this.props.onBranch,
        openCommit: this.props.openCommit
      });
    });
  }

  calculateNames(commits) {
    let names = new Set();
    commits.forEach(commit => {
      let name = null;

      if (commit.author.user) {
        name = commit.author.user.login;
      } else if (commit.author.name) {
        name = commit.author.name;
      }

      if (name && !names.has(name)) {
        names.add(name);
      }
    });
    names = Array.from(names);

    if (names.length === 1) {
      return names[0];
    } else if (names.length === 2) {
      return `${names[0]} and ${names[1]}`;
    } else if (names.length > 2) {
      return `${names[0]}, ${names[1]}, and others`;
    } else {
      return 'Someone';
    }
  }

}

exports.BareCommitsView = BareCommitsView;

_defineProperty(BareCommitsView, "propTypes", {
  nodes: _propTypes.default.arrayOf(_propTypes.default.shape({
    author: _propTypes.default.shape({
      name: _propTypes.default.string,
      user: _propTypes.default.shape({
        login: _propTypes.default.string.isRequired
      })
    }).isRequired
  }).isRequired).isRequired,
  onBranch: _propTypes.default.bool.isRequired,
  openCommit: _propTypes.default.func.isRequired
});

var _default = (0, _reactRelay.createFragmentContainer)(BareCommitsView, {
  nodes: function () {
    const node = require("./__generated__/commitsView_nodes.graphql");

    if (node.hash && node.hash !== "e01f34cd74aa6d007049d5b421abe1ec") {
      console.error("The definition of 'commitsView_nodes' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/commitsView_nodes.graphql");
  }
});

exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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