"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.BareCommitCommentView = void 0;

var _react = _interopRequireDefault(require("react"));

var _reactRelay = require("react-relay");

var _propTypes = _interopRequireDefault(require("prop-types"));

var _octicon = _interopRequireDefault(require("../../atom/octicon"));

var _timeago = _interopRequireDefault(require("../timeago"));

var _githubDotcomMarkdown = _interopRequireDefault(require("../github-dotcom-markdown"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class BareCommitCommentView extends _react.default.Component {
  render() {
    const comment = this.props.item;
    return _react.default.createElement("div", {
      className: "issue"
    }, _react.default.createElement("div", {
      className: "info-row"
    }, this.props.isReply ? null : _react.default.createElement(_octicon.default, {
      className: "pre-timeline-item-icon",
      icon: "comment"
    }), _react.default.createElement("img", {
      className: "author-avatar",
      src: comment.author.avatarUrl,
      alt: comment.author.login,
      title: comment.author.login
    }), this.renderHeader(comment)), _react.default.createElement(_githubDotcomMarkdown.default, {
      html: comment.bodyHTML,
      switchToIssueish: this.props.switchToIssueish
    }));
  }

  renderHeader(comment) {
    if (this.props.isReply) {
      return _react.default.createElement("span", {
        className: "comment-message-header"
      }, comment.author.login, " replied ", _react.default.createElement(_timeago.default, {
        time: comment.createdAt
      }));
    } else {
      return _react.default.createElement("span", {
        className: "comment-message-header"
      }, comment.author.login, " commented ", this.renderPath(), " in", ' ', comment.commit.oid.substr(0, 7), " ", _react.default.createElement(_timeago.default, {
        time: comment.createdAt
      }));
    }
  }

  renderPath() {
    if (this.props.item.path) {
      return _react.default.createElement("span", null, "on ", _react.default.createElement("code", null, this.props.item.path));
    } else {
      return null;
    }
  }

}

exports.BareCommitCommentView = BareCommitCommentView;

_defineProperty(BareCommitCommentView, "propTypes", {
  item: _propTypes.default.object.isRequired,
  isReply: _propTypes.default.bool.isRequired,
  switchToIssueish: _propTypes.default.func.isRequired
});

var _default = (0, _reactRelay.createFragmentContainer)(BareCommitCommentView, {
  item: function () {
    const node = require("./__generated__/commitCommentView_item.graphql");

    if (node.hash && node.hash !== "f3e868b343fe8d6fee958d5339b554dc") {
      console.error("The definition of 'commitCommentView_item' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/commitCommentView_item.graphql");
  }
});

exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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