"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _githubLoginView = _interopRequireDefault(require("./github-login-view"));

var _errorView = _interopRequireDefault(require("./error-view"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class QueryErrorView extends _react.default.Component {
  render() {
    const e = this.props.error;

    if (e.response) {
      switch (e.response.status) {
        case 401:
          return this.render401();

        case 200:
          // Do the default
          break;

        default:
          return this.renderUnknown(e.response, e.responseText);
      }
    }

    if (e.errors) {
      return this.renderGraphQLErrors(e.errors);
    }

    return _react.default.createElement(_errorView.default, _extends({
      title: e.message,
      descriptions: [e.stack],
      preformatted: true
    }, this.errorViewProps()));
  }

  renderGraphQLErrors(errors) {
    return _react.default.createElement(_errorView.default, _extends({
      title: "Query errors reported",
      descriptions: errors.map(e => e.message)
    }, this.errorViewProps()));
  }

  render401() {
    return _react.default.createElement("div", {
      className: "github-GithubLoginView-Container"
    }, _react.default.createElement(_githubLoginView.default, {
      onLogin: this.props.login
    }, _react.default.createElement("p", null, "The API endpoint returned a unauthorized error. Please try to re-authenticate with the endpoint.")));
  }

  renderUnknown(response, text) {
    return _react.default.createElement(_errorView.default, _extends({
      title: `Received an error response: ${response.status}`,
      descriptions: [text],
      preformatted: true
    }, this.errorViewProps()));
  }

  errorViewProps() {
    return {
      retry: this.props.retry,
      logout: this.props.logout
    };
  }

}

exports.default = QueryErrorView;

_defineProperty(QueryErrorView, "propTypes", {
  error: _propTypes.default.shape({
    name: _propTypes.default.string.isRequired,
    message: _propTypes.default.string.isRequired,
    stack: _propTypes.default.string.isRequired,
    response: _propTypes.default.shape({
      status: _propTypes.default.number.isRequired
    }),
    responseText: _propTypes.default.string,
    errors: _propTypes.default.arrayOf(_propTypes.default.shape({
      message: _propTypes.default.string.isRequired
    }))
  }).isRequired,
  login: _propTypes.default.func.isRequired,
  retry: _propTypes.default.func,
  logout: _propTypes.default.func
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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