"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _octicon = _interopRequireDefault(require("../atom/octicon"));

var _reporterProxy = require("../reporter-proxy");

var _helpers = require("../helpers");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class ChangedFilesCountView extends _react.default.Component {
  constructor(props) {
    super(props);
    (0, _helpers.autobind)(this, 'handleClick');
  }

  handleClick() {
    (0, _reporterProxy.addEvent)('click', {
      package: 'github',
      component: 'ChangedFileCountView'
    });
    this.props.didClick();
  }

  render() {
    return _react.default.createElement("button", {
      ref: "changedFiles",
      className: "github-ChangedFilesCount inline-block",
      onClick: this.handleClick
    }, _react.default.createElement(_octicon.default, {
      icon: "git-commit"
    }), `Git (${this.props.changedFilesCount})`, this.props.mergeConflictsPresent && _react.default.createElement(_octicon.default, {
      icon: "alert"
    }));
  }

}

exports.default = ChangedFilesCountView;

_defineProperty(ChangedFilesCountView, "propTypes", {
  changedFilesCount: _propTypes.default.number.isRequired,
  didClick: _propTypes.default.func.isRequired,
  mergeConflictsPresent: _propTypes.default.bool
});

_defineProperty(ChangedFilesCountView, "defaultProps", {
  changedFilesCount: 0,
  mergeConflictsPresent: false,
  didClick: () => {}
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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