"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ItemTypePropType = exports.UserStorePropType = exports.MergeConflictItemPropType = exports.MultiFilePatchPropType = exports.FilePatchItemPropType = exports.IssueishPropType = exports.OperationStateObserverPropType = exports.EnableableOperationPropType = exports.RangePropType = exports.PointPropType = exports.RefHolderPropType = exports.RelayConnectionPropType = exports.AuthorPropType = exports.CommitPropType = exports.BranchSetPropType = exports.RemoteSetPropType = exports.SearchPropType = exports.BranchPropType = exports.EndpointPropType = exports.RemotePropType = exports.GithubLoginModelPropType = exports.WorkdirContextPoolPropType = exports.DOMNodePropType = void 0;

var _propTypes = _interopRequireDefault(require("prop-types"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const DOMNodePropType = (props, propName, componentName) => {
  if (props[propName] instanceof HTMLElement) {
    return null;
  } else {
    return new Error(`Invalid prop '${propName}' supplied to '${componentName}'. Value is not DOM element.`);
  }
};

exports.DOMNodePropType = DOMNodePropType;

const WorkdirContextPoolPropType = _propTypes.default.shape({
  getContext: _propTypes.default.func.isRequired
});

exports.WorkdirContextPoolPropType = WorkdirContextPoolPropType;

const GithubLoginModelPropType = _propTypes.default.shape({
  getToken: _propTypes.default.func.isRequired,
  setToken: _propTypes.default.func.isRequired,
  removeToken: _propTypes.default.func.isRequired,
  getScopes: _propTypes.default.func.isRequired,
  onDidUpdate: _propTypes.default.func.isRequired
});

exports.GithubLoginModelPropType = GithubLoginModelPropType;

const RemotePropType = _propTypes.default.shape({
  getName: _propTypes.default.func.isRequired,
  getUrl: _propTypes.default.func.isRequired,
  isGithubRepo: _propTypes.default.func.isRequired,
  getOwner: _propTypes.default.func.isRequired,
  getRepo: _propTypes.default.func.isRequired,
  getEndpoint: _propTypes.default.func.isRequired
});

exports.RemotePropType = RemotePropType;

const EndpointPropType = _propTypes.default.shape({
  getGraphQLRoot: _propTypes.default.func.isRequired,
  getRestRoot: _propTypes.default.func.isRequired,
  getRestURI: _propTypes.default.func.isRequired
});

exports.EndpointPropType = EndpointPropType;

const BranchPropType = _propTypes.default.shape({
  getName: _propTypes.default.func.isRequired,
  isDetached: _propTypes.default.func.isRequired,
  isPresent: _propTypes.default.func.isRequired
});

exports.BranchPropType = BranchPropType;

const SearchPropType = _propTypes.default.shape({
  getName: _propTypes.default.func.isRequired,
  createQuery: _propTypes.default.func.isRequired
});

exports.SearchPropType = SearchPropType;

const RemoteSetPropType = _propTypes.default.shape({
  withName: _propTypes.default.func.isRequired,
  isEmpty: _propTypes.default.func.isRequired,
  size: _propTypes.default.func.isRequired,
  [Symbol.iterator]: _propTypes.default.func.isRequired
});

exports.RemoteSetPropType = RemoteSetPropType;

const BranchSetPropType = _propTypes.default.shape({
  getNames: _propTypes.default.func.isRequired,
  getPullTargets: _propTypes.default.func.isRequired,
  getPushSources: _propTypes.default.func.isRequired
});

exports.BranchSetPropType = BranchSetPropType;

const CommitPropType = _propTypes.default.shape({
  getSha: _propTypes.default.func.isRequired,
  getMessageSubject: _propTypes.default.func.isRequired,
  isUnbornRef: _propTypes.default.func.isRequired,
  isPresent: _propTypes.default.func.isRequired
});

exports.CommitPropType = CommitPropType;

const AuthorPropType = _propTypes.default.shape({
  getEmail: _propTypes.default.func.isRequired,
  getFullName: _propTypes.default.func.isRequired
});

exports.AuthorPropType = AuthorPropType;

const RelayConnectionPropType = nodePropType => _propTypes.default.shape({
  edges: _propTypes.default.arrayOf(_propTypes.default.shape({
    cursor: _propTypes.default.string,
    node: nodePropType
  })),
  pageInfo: _propTypes.default.shape({
    endCursor: _propTypes.default.string,
    hasNextPage: _propTypes.default.bool,
    hasPreviousPage: _propTypes.default.bool,
    startCursor: _propTypes.default.string
  }),
  totalCount: _propTypes.default.number
});

exports.RelayConnectionPropType = RelayConnectionPropType;

const RefHolderPropType = _propTypes.default.shape({
  isEmpty: _propTypes.default.func.isRequired,
  get: _propTypes.default.func.isRequired,
  setter: _propTypes.default.func.isRequired,
  observe: _propTypes.default.func.isRequired
});

exports.RefHolderPropType = RefHolderPropType;

const PointPropType = _propTypes.default.shape({
  row: _propTypes.default.number.isRequired,
  column: _propTypes.default.number.isRequired,
  isEqual: _propTypes.default.func.isRequired
});

exports.PointPropType = PointPropType;

const RangePropType = _propTypes.default.shape({
  start: PointPropType.isRequired,
  end: PointPropType.isRequired,
  isEqual: _propTypes.default.func.isRequired
});

exports.RangePropType = RangePropType;

const EnableableOperationPropType = _propTypes.default.shape({
  isEnabled: _propTypes.default.func.isRequired,
  run: _propTypes.default.func.isRequired,
  getMessage: _propTypes.default.func.isRequired,
  why: _propTypes.default.func.isRequired
});

exports.EnableableOperationPropType = EnableableOperationPropType;

const OperationStateObserverPropType = _propTypes.default.shape({
  onDidComplete: _propTypes.default.func.isRequired,
  dispose: _propTypes.default.func.isRequired
});

exports.OperationStateObserverPropType = OperationStateObserverPropType;

const IssueishPropType = _propTypes.default.shape({
  getNumber: _propTypes.default.func.isRequired,
  getTitle: _propTypes.default.func.isRequired,
  getGitHubURL: _propTypes.default.func.isRequired,
  getAuthorLogin: _propTypes.default.func.isRequired,
  getAuthorAvatarURL: _propTypes.default.func.isRequired,
  getCreatedAt: _propTypes.default.func.isRequired,
  getHeadRefName: _propTypes.default.func.isRequired,
  getHeadRepositoryID: _propTypes.default.func.isRequired,
  getStatusCounts: _propTypes.default.func.isRequired
});

exports.IssueishPropType = IssueishPropType;

const FilePatchItemPropType = _propTypes.default.shape({
  filePath: _propTypes.default.string.isRequired,
  status: _propTypes.default.string.isRequired
});

exports.FilePatchItemPropType = FilePatchItemPropType;

const MultiFilePatchPropType = _propTypes.default.shape({
  getFilePatches: _propTypes.default.func.isRequired
});

exports.MultiFilePatchPropType = MultiFilePatchPropType;
const statusNames = ['added', 'deleted', 'modified', 'typechange', 'equivalent'];

const MergeConflictItemPropType = _propTypes.default.shape({
  filePath: _propTypes.default.string.isRequired,
  status: _propTypes.default.shape({
    file: _propTypes.default.oneOf(statusNames).isRequired,
    ours: _propTypes.default.oneOf(statusNames).isRequired,
    theirs: _propTypes.default.oneOf(statusNames).isRequired
  }).isRequired
});

exports.MergeConflictItemPropType = MergeConflictItemPropType;

const UserStorePropType = _propTypes.default.shape({
  getUsers: _propTypes.default.func.isRequired,
  onDidUpdate: _propTypes.default.func.isRequired
}); // Require item classes lazily to prevent circular imports


exports.UserStorePropType = UserStorePropType;
let lazyItemConstructors = null;

function createItemTypePropType(required) {
  return function (props, propName, componentName) {
    if (lazyItemConstructors === null) {
      lazyItemConstructors = new Set();

      for (const itemPath of ['./items/changed-file-item', './items/commit-preview-item', './items/commit-detail-item', './items/issueish-detail-item']) {
        lazyItemConstructors.add(require(itemPath).default);
      }
    }

    if (props[propName] === undefined || props[propName] === null) {
      /* istanbul ignore else */
      if (required) {
        return new Error(`Missing required prop ${propName} on component ${componentName}.`);
      } else {
        return undefined;
      }
    }
    /* istanbul ignore if */


    if (!lazyItemConstructors.has(props[propName])) {
      const choices = Array.from(lazyItemConstructors, each => each.name).join(', ');
      return new Error(`Invalid prop "${propName}" supplied to ${componentName}. Must be one of ${choices}.`);
    }

    return undefined;
  };
}

const ItemTypePropType = createItemTypePropType(false);
exports.ItemTypePropType = ItemTypePropType;
ItemTypePropType.isRequired = createItemTypePropType(true);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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