"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.nullOperationStates = exports.default = void 0;

class OperationStates {
  constructor(options = {}) {
    this.didUpdate = options.didUpdate || (() => {});

    this.pushInProgress = false;
    this.pullInProgress = false;
    this.fetchInProgress = false;
    this.commitInProgress = false;
    this.checkoutInProgress = false;
  }

  isPushInProgress() {
    return this.pushInProgress;
  }

  isPullInProgress() {
    return this.pullInProgress;
  }

  isFetchInProgress() {
    return this.fetchInProgress;
  }

  isCommitInProgress() {
    return this.commitInProgress;
  }

  isCheckoutInProgress() {
    return this.checkoutInProgress;
  }

  setPushInProgress(value) {
    const oldValue = this.pushInProgress;
    this.pushInProgress = value;

    if (oldValue !== value) {
      this.didUpdate();
    }
  }

  setPullInProgress(value) {
    const oldValue = this.pullInProgress;
    this.pullInProgress = value;

    if (oldValue !== value) {
      this.didUpdate();
    }
  }

  setFetchInProgress(value) {
    const oldValue = this.fetchInProgress;
    this.fetchInProgress = value;

    if (oldValue !== value) {
      this.didUpdate();
    }
  }

  setCommitInProgress(value) {
    const oldValue = this.commitInProgress;
    this.commitInProgress = value;

    if (oldValue !== value) {
      this.didUpdate();
    }
  }

  setCheckoutInProgress(value) {
    const oldValue = this.checkoutInProgress;
    this.checkoutInProgress = value;

    if (oldValue !== value) {
      this.didUpdate();
    }
  }

}

exports.default = OperationStates;

class NullOperationStates extends OperationStates {
  setPushInProgress() {// do nothing
  }

  setPullInProgress() {// do nothing
  }

  setFetchInProgress() {// do nothing
  }

  setCommitInProgress() {// do nothing
  }

  setCheckoutInProgress() {// do nothing
  }

}

const nullOperationStates = new NullOperationStates();
exports.nullOperationStates = nullOperationStates;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIm9wZXJhdGlvbi1zdGF0ZXMuanMiXSwibmFtZXMiOlsiT3BlcmF0aW9uU3RhdGVzIiwiY29uc3RydWN0b3IiLCJvcHRpb25zIiwiZGlkVXBkYXRlIiwicHVzaEluUHJvZ3Jlc3MiLCJwdWxsSW5Qcm9ncmVzcyIsImZldGNoSW5Qcm9ncmVzcyIsImNvbW1pdEluUHJvZ3Jlc3MiLCJjaGVja291dEluUHJvZ3Jlc3MiLCJpc1B1c2hJblByb2dyZXNzIiwiaXNQdWxsSW5Qcm9ncmVzcyIsImlzRmV0Y2hJblByb2dyZXNzIiwiaXNDb21taXRJblByb2dyZXNzIiwiaXNDaGVja291dEluUHJvZ3Jlc3MiLCJzZXRQdXNoSW5Qcm9ncmVzcyIsInZhbHVlIiwib2xkVmFsdWUiLCJzZXRQdWxsSW5Qcm9ncmVzcyIsInNldEZldGNoSW5Qcm9ncmVzcyIsInNldENvbW1pdEluUHJvZ3Jlc3MiLCJzZXRDaGVja291dEluUHJvZ3Jlc3MiLCJOdWxsT3BlcmF0aW9uU3RhdGVzIiwibnVsbE9wZXJhdGlvblN0YXRlcyJdLCJtYXBwaW5ncyI6Ijs7Ozs7OztBQUFlLE1BQU1BLGVBQU4sQ0FBc0I7QUFDbkNDLEVBQUFBLFdBQVcsQ0FBQ0MsT0FBTyxHQUFHLEVBQVgsRUFBZTtBQUN4QixTQUFLQyxTQUFMLEdBQWlCRCxPQUFPLENBQUNDLFNBQVIsS0FBc0IsTUFBTSxDQUFFLENBQTlCLENBQWpCOztBQUNBLFNBQUtDLGNBQUwsR0FBc0IsS0FBdEI7QUFDQSxTQUFLQyxjQUFMLEdBQXNCLEtBQXRCO0FBQ0EsU0FBS0MsZUFBTCxHQUF1QixLQUF2QjtBQUNBLFNBQUtDLGdCQUFMLEdBQXdCLEtBQXhCO0FBQ0EsU0FBS0Msa0JBQUwsR0FBMEIsS0FBMUI7QUFDRDs7QUFFREMsRUFBQUEsZ0JBQWdCLEdBQUc7QUFDakIsV0FBTyxLQUFLTCxjQUFaO0FBQ0Q7O0FBRURNLEVBQUFBLGdCQUFnQixHQUFHO0FBQ2pCLFdBQU8sS0FBS0wsY0FBWjtBQUNEOztBQUVETSxFQUFBQSxpQkFBaUIsR0FBRztBQUNsQixXQUFPLEtBQUtMLGVBQVo7QUFDRDs7QUFFRE0sRUFBQUEsa0JBQWtCLEdBQUc7QUFDbkIsV0FBTyxLQUFLTCxnQkFBWjtBQUNEOztBQUVETSxFQUFBQSxvQkFBb0IsR0FBRztBQUNyQixXQUFPLEtBQUtMLGtCQUFaO0FBQ0Q7O0FBRURNLEVBQUFBLGlCQUFpQixDQUFDQyxLQUFELEVBQVE7QUFDdkIsVUFBTUMsUUFBUSxHQUFHLEtBQUtaLGNBQXRCO0FBQ0EsU0FBS0EsY0FBTCxHQUFzQlcsS0FBdEI7O0FBQ0EsUUFBSUMsUUFBUSxLQUFLRCxLQUFqQixFQUF3QjtBQUN0QixXQUFLWixTQUFMO0FBQ0Q7QUFDRjs7QUFFRGMsRUFBQUEsaUJBQWlCLENBQUNGLEtBQUQsRUFBUTtBQUN2QixVQUFNQyxRQUFRLEdBQUcsS0FBS1gsY0FBdEI7QUFDQSxTQUFLQSxjQUFMLEdBQXNCVSxLQUF0Qjs7QUFDQSxRQUFJQyxRQUFRLEtBQUtELEtBQWpCLEVBQXdCO0FBQ3RCLFdBQUtaLFNBQUw7QUFDRDtBQUNGOztBQUVEZSxFQUFBQSxrQkFBa0IsQ0FBQ0gsS0FBRCxFQUFRO0FBQ3hCLFVBQU1DLFFBQVEsR0FBRyxLQUFLVixlQUF0QjtBQUNBLFNBQUtBLGVBQUwsR0FBdUJTLEtBQXZCOztBQUNBLFFBQUlDLFFBQVEsS0FBS0QsS0FBakIsRUFBd0I7QUFDdEIsV0FBS1osU0FBTDtBQUNEO0FBQ0Y7O0FBRURnQixFQUFBQSxtQkFBbUIsQ0FBQ0osS0FBRCxFQUFRO0FBQ3pCLFVBQU1DLFFBQVEsR0FBRyxLQUFLVCxnQkFBdEI7QUFDQSxTQUFLQSxnQkFBTCxHQUF3QlEsS0FBeEI7O0FBQ0EsUUFBSUMsUUFBUSxLQUFLRCxLQUFqQixFQUF3QjtBQUN0QixXQUFLWixTQUFMO0FBQ0Q7QUFDRjs7QUFFRGlCLEVBQUFBLHFCQUFxQixDQUFDTCxLQUFELEVBQVE7QUFDM0IsVUFBTUMsUUFBUSxHQUFHLEtBQUtSLGtCQUF0QjtBQUNBLFNBQUtBLGtCQUFMLEdBQTBCTyxLQUExQjs7QUFDQSxRQUFJQyxRQUFRLEtBQUtELEtBQWpCLEVBQXdCO0FBQ3RCLFdBQUtaLFNBQUw7QUFDRDtBQUNGOztBQXBFa0M7Ozs7QUF1RXJDLE1BQU1rQixtQkFBTixTQUFrQ3JCLGVBQWxDLENBQWtEO0FBQ2hEYyxFQUFBQSxpQkFBaUIsR0FBRyxDQUNsQjtBQUNEOztBQUVERyxFQUFBQSxpQkFBaUIsR0FBRyxDQUNsQjtBQUNEOztBQUVEQyxFQUFBQSxrQkFBa0IsR0FBRyxDQUNuQjtBQUNEOztBQUVEQyxFQUFBQSxtQkFBbUIsR0FBRyxDQUNwQjtBQUNEOztBQUVEQyxFQUFBQSxxQkFBcUIsR0FBRyxDQUN0QjtBQUNEOztBQW5CK0M7O0FBc0IzQyxNQUFNRSxtQkFBbUIsR0FBRyxJQUFJRCxtQkFBSixFQUE1QiIsInNvdXJjZVJvb3QiOiIvYnVpbGQvYXRvbS9zcmMvYXRvbS0xLjM2LjAvb3V0L2FwcC9ub2RlX21vZHVsZXMvZ2l0aHViIiwic291cmNlc0NvbnRlbnQiOlsiZXhwb3J0IGRlZmF1bHQgY2xhc3MgT3BlcmF0aW9uU3RhdGVzIHtcbiAgY29uc3RydWN0b3Iob3B0aW9ucyA9IHt9KSB7XG4gICAgdGhpcy5kaWRVcGRhdGUgPSBvcHRpb25zLmRpZFVwZGF0ZSB8fCAoKCkgPT4ge30pO1xuICAgIHRoaXMucHVzaEluUHJvZ3Jlc3MgPSBmYWxzZTtcbiAgICB0aGlzLnB1bGxJblByb2dyZXNzID0gZmFsc2U7XG4gICAgdGhpcy5mZXRjaEluUHJvZ3Jlc3MgPSBmYWxzZTtcbiAgICB0aGlzLmNvbW1pdEluUHJvZ3Jlc3MgPSBmYWxzZTtcbiAgICB0aGlzLmNoZWNrb3V0SW5Qcm9ncmVzcyA9IGZhbHNlO1xuICB9XG5cbiAgaXNQdXNoSW5Qcm9ncmVzcygpIHtcbiAgICByZXR1cm4gdGhpcy5wdXNoSW5Qcm9ncmVzcztcbiAgfVxuXG4gIGlzUHVsbEluUHJvZ3Jlc3MoKSB7XG4gICAgcmV0dXJuIHRoaXMucHVsbEluUHJvZ3Jlc3M7XG4gIH1cblxuICBpc0ZldGNoSW5Qcm9ncmVzcygpIHtcbiAgICByZXR1cm4gdGhpcy5mZXRjaEluUHJvZ3Jlc3M7XG4gIH1cblxuICBpc0NvbW1pdEluUHJvZ3Jlc3MoKSB7XG4gICAgcmV0dXJuIHRoaXMuY29tbWl0SW5Qcm9ncmVzcztcbiAgfVxuXG4gIGlzQ2hlY2tvdXRJblByb2dyZXNzKCkge1xuICAgIHJldHVybiB0aGlzLmNoZWNrb3V0SW5Qcm9ncmVzcztcbiAgfVxuXG4gIHNldFB1c2hJblByb2dyZXNzKHZhbHVlKSB7XG4gICAgY29uc3Qgb2xkVmFsdWUgPSB0aGlzLnB1c2hJblByb2dyZXNzO1xuICAgIHRoaXMucHVzaEluUHJvZ3Jlc3MgPSB2YWx1ZTtcbiAgICBpZiAob2xkVmFsdWUgIT09IHZhbHVlKSB7XG4gICAgICB0aGlzLmRpZFVwZGF0ZSgpO1xuICAgIH1cbiAgfVxuXG4gIHNldFB1bGxJblByb2dyZXNzKHZhbHVlKSB7XG4gICAgY29uc3Qgb2xkVmFsdWUgPSB0aGlzLnB1bGxJblByb2dyZXNzO1xuICAgIHRoaXMucHVsbEluUHJvZ3Jlc3MgPSB2YWx1ZTtcbiAgICBpZiAob2xkVmFsdWUgIT09IHZhbHVlKSB7XG4gICAgICB0aGlzLmRpZFVwZGF0ZSgpO1xuICAgIH1cbiAgfVxuXG4gIHNldEZldGNoSW5Qcm9ncmVzcyh2YWx1ZSkge1xuICAgIGNvbnN0IG9sZFZhbHVlID0gdGhpcy5mZXRjaEluUHJvZ3Jlc3M7XG4gICAgdGhpcy5mZXRjaEluUHJvZ3Jlc3MgPSB2YWx1ZTtcbiAgICBpZiAob2xkVmFsdWUgIT09IHZhbHVlKSB7XG4gICAgICB0aGlzLmRpZFVwZGF0ZSgpO1xuICAgIH1cbiAgfVxuXG4gIHNldENvbW1pdEluUHJvZ3Jlc3ModmFsdWUpIHtcbiAgICBjb25zdCBvbGRWYWx1ZSA9IHRoaXMuY29tbWl0SW5Qcm9ncmVzcztcbiAgICB0aGlzLmNvbW1pdEluUHJvZ3Jlc3MgPSB2YWx1ZTtcbiAgICBpZiAob2xkVmFsdWUgIT09IHZhbHVlKSB7XG4gICAgICB0aGlzLmRpZFVwZGF0ZSgpO1xuICAgIH1cbiAgfVxuXG4gIHNldENoZWNrb3V0SW5Qcm9ncmVzcyh2YWx1ZSkge1xuICAgIGNvbnN0IG9sZFZhbHVlID0gdGhpcy5jaGVja291dEluUHJvZ3Jlc3M7XG4gICAgdGhpcy5jaGVja291dEluUHJvZ3Jlc3MgPSB2YWx1ZTtcbiAgICBpZiAob2xkVmFsdWUgIT09IHZhbHVlKSB7XG4gICAgICB0aGlzLmRpZFVwZGF0ZSgpO1xuICAgIH1cbiAgfVxufVxuXG5jbGFzcyBOdWxsT3BlcmF0aW9uU3RhdGVzIGV4dGVuZHMgT3BlcmF0aW9uU3RhdGVzIHtcbiAgc2V0UHVzaEluUHJvZ3Jlc3MoKSB7XG4gICAgLy8gZG8gbm90aGluZ1xuICB9XG5cbiAgc2V0UHVsbEluUHJvZ3Jlc3MoKSB7XG4gICAgLy8gZG8gbm90aGluZ1xuICB9XG5cbiAgc2V0RmV0Y2hJblByb2dyZXNzKCkge1xuICAgIC8vIGRvIG5vdGhpbmdcbiAgfVxuXG4gIHNldENvbW1pdEluUHJvZ3Jlc3MoKSB7XG4gICAgLy8gZG8gbm90aGluZ1xuICB9XG5cbiAgc2V0Q2hlY2tvdXRJblByb2dyZXNzKCkge1xuICAgIC8vIGRvIG5vdGhpbmdcbiAgfVxufVxuXG5leHBvcnQgY29uc3QgbnVsbE9wZXJhdGlvblN0YXRlcyA9IG5ldyBOdWxsT3BlcmF0aW9uU3RhdGVzKCk7XG4iXX0=