"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _reactRelay = require("react-relay");

var _propTypes = _interopRequireDefault(require("prop-types"));

var _octicon = _interopRequireDefault(require("../atom/octicon"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class UserMentionTooltip extends _react.default.Component {
  render() {
    const owner = this.props.repositoryOwner;
    const {
      login,
      company,
      repositories,
      members
    } = owner;
    return _react.default.createElement("div", {
      className: "github-UserMentionTooltip"
    }, _react.default.createElement("div", {
      className: "github-UserMentionTooltip-avatar"
    }, _react.default.createElement("img", {
      alt: "repository owner's avatar",
      src: owner.avatarUrl
    })), _react.default.createElement("div", {
      className: "github-UserMentionTooltip-info"
    }, _react.default.createElement("div", {
      className: "github-UserMentionTooltip-info-username"
    }, _react.default.createElement(_octicon.default, {
      icon: "mention"
    }), _react.default.createElement("strong", null, login)), company && _react.default.createElement("div", null, _react.default.createElement(_octicon.default, {
      icon: "briefcase"
    }), _react.default.createElement("span", null, company)), members && _react.default.createElement("div", null, _react.default.createElement(_octicon.default, {
      icon: "organization"
    }), _react.default.createElement("span", null, members.totalCount, " members")), _react.default.createElement("div", null, _react.default.createElement(_octicon.default, {
      icon: "repo"
    }), _react.default.createElement("span", null, repositories.totalCount, " repositories"))), _react.default.createElement("div", {
      style: {
        clear: 'both'
      }
    }));
  }

}

_defineProperty(UserMentionTooltip, "propTypes", {
  repositoryOwner: _propTypes.default.shape({
    login: _propTypes.default.string.isRequired,
    avatarUrl: _propTypes.default.string.isRequired,
    repositories: _propTypes.default.shape({
      totalCount: _propTypes.default.number.isRequired
    }).isRequired,
    // Users
    company: _propTypes.default.string,
    // Organizations
    members: _propTypes.default.shape({
      totalCount: _propTypes.default.number.isRequired
    })
  }).isRequired
});

var _default = (0, _reactRelay.createFragmentContainer)(UserMentionTooltip, {
  repositoryOwner: function () {
    const node = require("./__generated__/userMentionTooltipContainer_repositoryOwner.graphql");

    if (node.hash && node.hash !== "e59070cd60b11e3732403a074496e66c") {
      console.error("The definition of 'userMentionTooltipContainer_repositoryOwner' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/userMentionTooltipContainer_repositoryOwner.graphql");
  }
});

exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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