"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _reactDom = _interopRequireDefault(require("react-dom"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _eventKit = require("event-kit");

var _helpers = require("../helpers");

var _propTypes2 = require("../prop-types");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/**
 * `Panel` renders a React component into an Atom panel. Specify the location via the `location` prop, and any
 * additional options to the `addXPanel` method in the `options` prop.
 *
 * You can get the underlying Atom panel via `getPanel()`, but you should consider controlling the panel via React and
 * the Panel component instead.
 */
class Panel extends _react.default.Component {
  constructor(props) {
    super(props);
    this.subscriptions = new _eventKit.CompositeDisposable();
    this.panel = null;
    this.didCloseItem = false;
    this.domNode = document.createElement('div');
    this.domNode.className = 'react-atom-panel';
  }

  componentDidMount() {
    this.setupPanel();
  }

  shouldComponentUpdate(newProps) {
    return this.props.visible !== newProps.visible;
  }

  componentDidUpdate() {
    if (this.didCloseItem) {
      // eslint-disable-next-line no-console
      console.error('Unexpected update in `Panel`: the contained panel has been destroyed');
    }

    if (this.panel) {
      this.panel[this.props.visible ? 'show' : 'hide']();
    }
  }

  render() {
    return _reactDom.default.createPortal(this.props.children, this.domNode);
  }

  setupPanel() {
    if (this.panel) {
      return;
    } // "left" => "Left"


    const location = this.props.location.substr(0, 1).toUpperCase() + this.props.location.substr(1);
    const methodName = `add${location}Panel`;
    const item = (0, _helpers.createItem)(this.domNode, this.props.itemHolder);

    const options = _objectSpread({}, this.props.options, {
      visible: this.props.visible,
      item
    });

    this.panel = this.props.workspace[methodName](options);
    this.subscriptions.add(this.panel.onDidDestroy(() => {
      this.didCloseItem = true;
      this.props.onDidClosePanel(this.panel);
    }));
  }

  componentWillUnmount() {
    this.subscriptions.dispose();

    if (this.panel) {
      this.panel.destroy();
    }
  }

  getPanel() {
    return this.panel;
  }

}

exports.default = Panel;

_defineProperty(Panel, "propTypes", {
  workspace: _propTypes.default.object.isRequired,
  location: _propTypes.default.oneOf(['top', 'bottom', 'left', 'right', 'header', 'footer', 'modal']).isRequired,
  children: _propTypes.default.element.isRequired,
  options: _propTypes.default.object,
  onDidClosePanel: _propTypes.default.func,
  visible: _propTypes.default.bool,
  itemHolder: _propTypes2.RefHolderPropType
});

_defineProperty(Panel, "defaultProps", {
  options: {},
  onDidClosePanel: panel => {},
  visible: true
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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