/*
 * Copyright (c) 2012, 2018, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_ug extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Africa_Central = new String[] {
               "\u0626\u0648\u062a\u062a\u06c7\u0631\u0627 \u0626\u0627\u0641\u0631\u0649\u0642\u0627 \u06cb\u0627\u0642\u062a\u0649",
               "CAT",
               "Central African Summer Time",
               "CAST",
               "Central Africa Time",
               "CAT",
            };
        final String[] Moscow = new String[] {
               "\u0645\u0648\u0633\u0643\u06cb\u0627 \u0626\u06c6\u0644\u0686\u06d5\u0645\u0644\u0649\u0643 \u06cb\u0627\u0642\u062a\u0649",
               "MSK",
               "\u0645\u0648\u0633\u0643\u06cb\u0627 \u064a\u0627\u0632\u0644\u0649\u0642 \u06cb\u0627\u0642\u062a\u0649",
               "MSD",
               "\u0645\u0648\u0633\u0643\u06cb\u0627 \u06cb\u0627\u0642\u062a\u0649",
               "MT",
            };
        final String[] Japan = new String[] {
               "\u064a\u0627\u067e\u0648\u0646\u0649\u064a\u06d5 \u0626\u06c6\u0644\u0686\u06d5\u0645\u0644\u0649\u0643 \u06cb\u0627\u0642\u062a\u0649",
               "JST",
               "\u064a\u0627\u067e\u0648\u0646\u0649\u064a\u06d5 \u064a\u0627\u0632\u0644\u0649\u0642 \u06cb\u0627\u0642\u062a\u0649",
               "JDT",
               "\u064a\u0627\u067e\u0648\u0646\u0649\u064a\u06d5 \u06cb\u0627\u0642\u062a\u0649",
               "JT",
            };
        final String[] Pakistan = new String[] {
               "\u067e\u0627\u0643\u0649\u0633\u062a\u0627\u0646 \u0626\u06c6\u0644\u0686\u06d5\u0645\u0644\u0649\u0643 \u06cb\u0627\u0642\u062a\u0649",
               "PKT",
               "\u067e\u0627\u0643\u0649\u0633\u062a\u0627\u0646 \u064a\u0627\u0632\u0644\u0649\u0642 \u06cb\u0627\u0642\u062a\u0649",
               "PKST",
               "\u067e\u0627\u0643\u0649\u0633\u062a\u0627\u0646 \u06cb\u0627\u0642\u062a\u0649",
               "PKT",
            };
        final String[] Taipei = new String[] {
               "\u062a\u06d5\u064a\u0628\u06d0\u064a \u0626\u06c6\u0644\u0686\u06d5\u0645\u0644\u0649\u0643 \u06cb\u0627\u0642\u062a\u0649",
               "CST",
               "\u062a\u06d5\u064a\u0628\u06d0\u064a \u064a\u0627\u0632\u0644\u0649\u0642 \u06cb\u0627\u0642\u062a\u0649",
               "CDT",
               "\u062a\u06d5\u064a\u0628\u06d0\u064a \u06cb\u0627\u0642\u062a\u0649",
               "CT",
            };
        final String[] Hovd = new String[] {
               "\u062e\u0648\u06cb\u062f \u0626\u06c6\u0644\u0686\u06d5\u0645\u0644\u0649\u0643 \u06cb\u0627\u0642\u062a\u0649",
               "HOVT",
               "\u062e\u0648\u06cb\u062f \u064a\u0627\u0632\u0644\u0649\u0642 \u06cb\u0627\u0642\u062a\u0649",
               "HOVST",
               "\u062e\u0648\u06cb\u062f \u06cb\u0627\u0642\u062a\u0649",
               "HOVT",
            };
        final String[] Magadan = new String[] {
               "\u0645\u0627\u06af\u0627\u062f\u0627\u0646 \u0626\u06c6\u0644\u0686\u06d5\u0645\u0644\u0649\u0643 \u06cb\u0627\u0642\u062a\u0649",
               "MAGT",
               "\u0645\u0627\u06af\u0627\u062f\u0627\u0646 \u064a\u0627\u0632\u0644\u0649\u0642 \u06cb\u0627\u0642\u062a\u0649",
               "MAGST",
               "\u0645\u0627\u06af\u0627\u062f\u0627\u0646 \u06cb\u0627\u0642\u062a\u0649",
               "MAGT",
            };
        final String[] Australia_CentralWestern = new String[] {
               "\u0626\u0627\u06cb\u0633\u062a\u0649\u0631\u0627\u0644\u0649\u064a\u06d5 \u0626\u0648\u062a\u062a\u06c7\u0631\u0627 \u063a\u06d5\u0631\u0628\u0649\u064a \u0642\u0649\u0633\u0649\u0645 \u0626\u06c6\u0644\u0686\u06d5\u0645\u0644\u0649\u0643 \u06cb\u0627\u0642\u062a\u0649",
               "ACWST",
               "\u0626\u0627\u06cb\u0633\u062a\u0631\u0627\u0644\u0649\u064a\u06d5 \u0626\u0648\u062a\u062a\u06c7\u0631\u0627 \u063a\u06d5\u0631\u0628\u0649\u064a \u0642\u0649\u0633\u0649\u0645 \u064a\u0627\u0632\u0644\u0649\u0642 \u06cb\u0627\u0642\u062a\u0649",
               "ACWDT",
               "\u0626\u0627\u06cb\u0633\u062a\u0631\u0627\u0644\u0649\u064a\u06d5 \u0626\u0648\u062a\u062a\u06c7\u0631\u0627 \u063a\u06d5\u0631\u0628\u0649\u064a \u0642\u0649\u0633\u0649\u0645 \u06cb\u0627\u0642\u062a\u0649",
               "ACWT",
            };
        final String[] Europe_Central = new String[] {
               "\u0626\u0648\u062a\u062a\u06c7\u0631\u0627 \u064a\u0627\u06cb\u0631\u0648\u067e\u0627 \u0626\u06c6\u0644\u0686\u06d5\u0645\u0644\u0649\u0643 \u06cb\u0627\u0642\u062a\u0649",
               "CET",
               "\u0626\u0648\u062a\u062a\u06c7\u0631\u0627 \u064a\u0627\u06cb\u0631\u0648\u067e\u0627 \u064a\u0627\u0632\u0644\u0649\u0642 \u06cb\u0627\u0642\u062a\u0649",
               "CEST",
               "\u0626\u0648\u062a\u062a\u06c7\u0631\u0627 \u064a\u0627\u06cb\u0631\u0648\u067e\u0627 \u06cb\u0627\u0642\u062a\u0649",
               "CET",
            };
        final String[] Sakhalin = new String[] {
               "\u0633\u0627\u062e\u0627\u0631\u0649\u0646 \u0626\u06c6\u0644\u0686\u06d5\u0645\u0644\u0649\u0643 \u06cb\u0627\u0642\u062a\u0649",
               "SAKT",
               "\u0633\u0627\u062e\u0627\u0631\u0649\u0646 \u064a\u0627\u0632\u0644\u0649\u0642 \u06cb\u0627\u0642\u062a\u0649",
               "SAKST",
               "\u0633\u0627\u062e\u0627\u0631\u0649\u0646 \u06cb\u0627\u0642\u062a\u0649",
               "SAKT",
            };
        final String[] Paraguay = new String[] {
               "\u067e\u0627\u0631\u0627\u06af\u06cb\u0627\u064a \u0626\u06c6\u0644\u0686\u06d5\u0645\u0644\u0649\u0643 \u06cb\u0627\u0642\u062a\u0649",
               "PYT",
               "\u067e\u0627\u0631\u0627\u06af\u06cb\u0627\u064a \u064a\u0627\u0632\u0644\u0649\u0642 \u06cb\u0627\u0642\u062a\u0649",
               "PYST",
               "\u067e\u0627\u0631\u0627\u06af\u06cb\u0627\u064a \u06cb\u0627\u0642\u062a\u0649",
               "PYT",
            };
        final String[] Acre = new String[] {
               "\u0626\u0627\u0643\u0631\u06d0 \u0626\u06c6\u0644\u0686\u06d5\u0645\u0644\u0649\u0643 \u06cb\u0627\u0642\u062a\u0649",
               "ACT",
               "\u0626\u0627\u0643\u0631\u0649 \u064a\u0627\u0632\u0644\u0649\u0642 \u06cb\u0627\u0642\u062a\u0649",
               "ACST",
               "\u0626\u0627\u0643\u0631\u06d0 \u06cb\u0627\u0642\u062a\u0649",
               "ACT",
            };
        final String[] Malaysia = new String[] {
               "\u0645\u0627\u0644\u0627\u064a\u0634\u0649\u064a\u0627 \u06cb\u0627\u0642\u062a\u0649",
               "MYT",
               "Malaysia Summer Time",
               "MYST",
               "Malaysia Time",
               "MYT",
            };
        final String[] America_Eastern = new String[] {
               "\u0634\u06d5\u0631\u0642\u0649\u064a \u0642\u0649\u0633\u0649\u0645 \u0626\u06c6\u0644\u0686\u06d5\u0645\u0644\u0649\u0643 \u06cb\u0627\u0642\u062a\u0649",
               "EST",
               "\u0634\u06d5\u0631\u0642\u0649\u064a \u0642\u0649\u0633\u0649\u0645 \u064a\u0627\u0632\u0644\u0649\u0642 \u06cb\u0627\u0642\u062a\u0649",
               "EDT",
               "\u0634\u06d5\u0631\u0642\u0649\u064a \u0642\u0649\u0633\u0649\u0645 \u06cb\u0627\u0642\u062a\u0649",
               "ET",
            };
        final String[] Lord_Howe = new String[] {
               "\u0644\u0648\u0631\u062f-\u062e\u0627\u064a \u0626\u06c6\u0644\u0686\u06d5\u0645\u0644\u0649\u0643 \u06cb\u0627\u0642\u062a\u0649",
               "LHST",
               "\u0644\u0648\u0631\u062f-\u062e\u0627\u064a \u064a\u0627\u0632\u0644\u0649\u0642 \u06cb\u0627\u0642\u062a\u0649",
               "LHDT",
               "\u0644\u0648\u0631\u062f-\u062e\u0627\u064a \u06cb\u0627\u0642\u062a\u0649",
               "LHT",
            };
        final String[] New_Zealand = new String[] {
               "\u064a\u06d0\u06ad\u0649 \u0632\u06d0\u0644\u0627\u0646\u062f\u0649\u064a\u06d5 \u0626\u06c6\u0644\u0686\u06d5\u0645\u0644\u0649\u0643 \u06cb\u0627\u0642\u062a\u0649",
               "NZST",
               "\u064a\u06d0\u06ad\u0649 \u0632\u06d0\u0644\u0627\u0646\u062f\u0649\u064a\u06d5 \u064a\u0627\u0632\u0644\u0649\u0642 \u06cb\u0627\u0642\u062a\u0649",
               "NZDT",
               "\u064a\u06d0\u06ad\u0649 \u0632\u06d0\u0644\u0627\u0646\u062f\u0649\u064a\u06d5 \u06cb\u0627\u0642\u062a\u0649",
               "NZT",
            };
        final String[] Indian_Ocean = new String[] {
               "\u06be\u0649\u0646\u062f\u0649 \u0626\u0648\u0643\u064a\u0627\u0646 \u06cb\u0627\u0642\u062a\u0649",
               "IOT",
               "Indian Ocean Territory Summer Time",
               "IOST",
               "Indian Ocean Territory Time",
               "IOT",
            };
        final String[] Yakutsk = new String[] {
               "\u064a\u0627\u0643\u06c7\u062a\u0633\u0643 \u0626\u06c6\u0644\u0686\u06d5\u0645\u0644\u0649\u0643 \u06cb\u0627\u0642\u062a\u0649",
               "YAKT",
               "\u064a\u0627\u0643\u06c7\u062a\u0633\u0643 \u064a\u0627\u0632\u0644\u0649\u0642 \u06cb\u0627\u0642\u062a\u0649",
               "YAKST",
               "\u064a\u0627\u0643\u06c7\u062a\u0633\u0643 \u06cb\u0627\u0642\u062a\u0649",
               "YAKT",
            };
        final String[] Mauritius = new String[] {
               "\u0645\u0627\u06cb\u0631\u0649\u062a\u0649\u0626\u06c7\u0633 \u0626\u06c6\u0644\u0686\u06d5\u0645\u0644\u0649\u0643 \u06cb\u0627\u0642\u062a\u0649",
               "MUT",
               "\u0645\u0627\u06cb\u0631\u0649\u062a\u0649\u0626\u06c7\u0633 \u064a\u0627\u0632\u0644\u0649\u0642 \u06cb\u0627\u0642\u062a\u0649",
               "MUST",
               "\u0645\u0627\u06cb\u0631\u0649\u062a\u0649\u0626\u06c7\u0633 \u06cb\u0627\u0642\u062a\u0649",
               "MUT",
            };
        final String[] Africa_Eastern = new String[] {
               "\u0634\u06d5\u0631\u0642\u0649\u064a \u0626\u0627\u0641\u0631\u0649\u0642\u0627 \u06cb\u0627\u0642\u062a\u0649",
               "EAT",
               "Eastern African Summer Time",
               "EAST",
               "Eastern Africa Time",
               "EAT",
            };
        final String[] East_Timor = new String[] {
               "\u0634\u06d5\u0631\u0642\u0649\u064a \u062a\u0649\u0645\u0648\u0631 \u06cb\u0627\u0642\u062a\u0649",
               "TLT",
               "Timor-Leste Summer Time",
               "TLST",
               "Timor-Leste Time",
               "TLT",
            };
        final String[] Solomon = new String[] {
               "\u0633\u0648\u0644\u0648\u0645\u0648\u0646 \u0626\u0627\u0631\u0627\u0644\u0644\u0649\u0631\u0649 \u06cb\u0627\u0642\u062a\u0649",
               "SBT",
               "Solomon Is. Summer Time",
               "SBST",
               "Solomon Is. Time",
               "SBT",
            };
        final String[] Kosrae = new String[] {
               "\u0643\u0648\u0633\u0631\u0627\u0626\u06d0 \u06cb\u0627\u0642\u062a\u0649",
               "KOST",
               "Kosrae Summer Time",
               "KOSST",
               "Kosrae Time",
               "KOST",
            };
        final String[] Marshall_Islands = new String[] {
               "\u0645\u0627\u0631\u0634\u0627\u0644 \u0626\u0627\u0631\u0627\u0644\u0644\u0649\u0631\u0649 \u06cb\u0627\u0642\u062a\u0649",
               "MHT",
               "Marshall Islands Summer Time",
               "MHST",
               "Marshall Islands Time",
               "MHT",
            };
        final String[] Europe_Eastern = new String[] {
               "\u0634\u06d5\u0631\u0642\u0649\u064a \u064a\u0627\u06cb\u0631\u0648\u067e\u0627 \u0626\u06c6\u0644\u0686\u06d5\u0645\u0644\u0649\u0643 \u06cb\u0627\u0642\u062a\u0649",
               "EET",
               "\u0634\u06d5\u0631\u0642\u0649\u064a \u064a\u0627\u06cb\u0631\u0648\u067e\u0627 \u064a\u0627\u0632\u0644\u0649\u0642 \u06cb\u0627\u0642\u062a\u0649",
               "EEST",
               "\u0634\u06d5\u0631\u0642\u0649\u064a \u064a\u0627\u06cb\u0631\u0648\u067e\u0627 \u06cb\u0627\u0642\u062a\u0649",
               "EET",
            };
        final String[] Newfoundland = new String[] {
               "\u0646\u0649\u06cb\u0641\u0648\u0626\u06c7\u0646\u0644\u0627\u0646\u062f \u0626\u06c6\u0644\u0686\u06d5\u0645\u0644\u0649\u0643 \u06cb\u0627\u0642\u062a\u0649",
               "NST",
               "\u0646\u0649\u06cb\u0641\u0648\u0626\u06c7\u0646\u0644\u0627\u0646\u062f \u064a\u0627\u0632\u0644\u0649\u0642 \u06cb\u0627\u0642\u062a\u0649",
               "NDT",
               "\u0646\u0649\u06cb\u0641\u0648\u0626\u06c7\u0646\u0644\u0627\u0646\u062f \u06cb\u0627\u0642\u062a\u0649",
               "NT",
            };
        final String[] Afghanistan = new String[] {
               "\u0626\u0627\u0641\u063a\u0627\u0646\u0649\u0633\u062a\u0627\u0646 \u06cb\u0627\u0642\u062a\u0649",
               "AFT",
               "Afghanistan Summer Time",
               "AFST",
               "Afghanistan Time",
               "AFT",
            };
        final String[] Hong_Kong = new String[] {
               "\u0634\u064a\u0627\u06ad\u06af\u0627\u06ad \u0626\u06c6\u0644\u0686\u06d5\u0645\u0644\u0649\u0643 \u06cb\u0627\u0642\u062a\u0649",
               "HKT",
               "\u0634\u064a\u0627\u06ad\u06af\u0627\u06ad \u064a\u0627\u0632\u0644\u0649\u0642 \u06cb\u0627\u0642\u062a\u0649",
               "HKST",
               "\u0634\u064a\u0627\u06ad\u06af\u0627\u06ad \u06cb\u0627\u0642\u062a\u0649",
               "HKT",
            };
        final String[] Argentina_Western = new String[] {
               "\u063a\u06d5\u0631\u0628\u0649\u064a \u0626\u0627\u0631\u06af\u06d0\u0646\u062a\u0649\u0646\u0627 \u0626\u06c6\u0644\u0686\u06d5\u0645\u0644\u0649\u0643 \u06cb\u0627\u0642\u062a\u0649",
               "ART",
               "\u063a\u06d5\u0631\u0628\u0649\u064a \u0626\u0627\u0631\u06af\u06d0\u0646\u062a\u0649\u0646\u0627 \u064a\u0627\u0632\u0644\u0649\u0642 \u06cb\u0627\u0642\u062a\u0649",
               "ARST",
               "\u063a\u06d5\u0631\u0628\u0649\u064a \u0626\u0627\u0631\u06af\u06d0\u0646\u062a\u0649\u0646\u0627 \u06cb\u0627\u0642\u062a\u0649",
               "ART",
            };
        final String[] Atlantic = new String[] {
               "\u0626\u0627\u062a\u0644\u0627\u0646\u062a\u0649\u0643 \u0626\u0648\u0643\u064a\u0627\u0646 \u0626\u06c6\u0644\u0686\u06d5\u0645\u0644\u0649\u0643 \u06cb\u0627\u0642\u062a\u0649",
               "AST",
               "\u0626\u0627\u062a\u0644\u0627\u0646\u062a\u0649\u0643 \u0626\u0648\u0643\u064a\u0627\u0646 \u064a\u0627\u0632\u0644\u0649\u0642 \u06cb\u0627\u0642\u062a\u0649",
               "ADT",
               "\u0626\u0627\u062a\u0644\u0627\u0646\u062a\u0649\u0643 \u0626\u0648\u0643\u064a\u0627\u0646 \u06cb\u0627\u0642\u062a\u0649",
               "AT",
            };
        final String[] Ponape = new String[] {
               "\u067e\u0648\u0646\u067e\u06d0\u064a \u06cb\u0627\u0642\u062a\u0649",
               "PONT",
               "Pohnpei Summer Time",
               "PONST",
               "Ponape Time",
               "PONT",
            };
        final String[] Bolivia = new String[] {
               "\u0628\u0648\u0644\u0649\u06cb\u0649\u064a\u06d5 \u06cb\u0627\u0642\u062a\u0649",
               "BOT",
               "Bolivia Summer Time",
               "BOST",
               "Bolivia Time",
               "BOT",
            };
        final String[] Pierre_Miquelon = new String[] {
               "\u0633\u0627\u064a\u0646\u0649\u062a \u067e\u0649\u0626\u06d0\u0631 \u06cb\u06d5 \u0645\u0649\u0643\u06d0\u0644\u0648\u0646 \u0626\u06c6\u0644\u0686\u06d5\u0645\u0644\u0649\u0643 \u06cb\u0627\u0642\u062a\u0649",
               "PMST",
               "\u0633\u0627\u064a\u0646\u0649\u062a \u067e\u0649\u0626\u06d0\u0631 \u06cb\u06d5 \u0645\u0649\u0643\u06d0\u0644\u0648\u0646 \u064a\u0627\u0632\u0644\u0649\u0642 \u06cb\u0627\u0642\u062a\u0649",
               "PMDT",
               "\u0633\u0627\u064a\u0646\u0649\u062a \u067e\u0649\u0626\u06d0\u0631 \u06cb\u06d5 \u0645\u0649\u0643\u06d0\u0644\u0648\u0646 \u06cb\u0627\u0642\u062a\u0649",
               "PMT",
            };
        final String[] Indochina = new String[] {
               "\u06be\u0649\u0646\u062f\u0649 \u0686\u0649\u0646\u0649 \u06cb\u0627\u0642\u062a\u0649",
               "ICT",
               "Indochina Summer Time",
               "ICST",
               "Indochina Time",
               "ICT",
            };
        final String[] Yekaterinburg = new String[] {
               "\u064a\u06d0\u0643\u0627\u062a\u06d0\u0631\u0649\u0646\u0628\u06c7\u0631\u06af \u0626\u06c6\u0644\u0686\u06d5\u0645\u0644\u0649\u0643 \u06cb\u0627\u0642\u062a\u0649",
               "YEKT",
               "\u064a\u06d0\u0643\u0627\u062a\u06d0\u0631\u0649\u0646\u0628\u06c7\u0631\u06af \u064a\u0627\u0632\u0644\u0649\u0642 \u06cb\u0627\u0642\u062a\u0649",
               "YEKST",
               "\u064a\u06d0\u0643\u0627\u062a\u06d0\u0631\u0649\u0646\u0628\u06c7\u0631\u06af \u06cb\u0627\u0642\u062a\u0649",
               "YEKT",
            };
        final String[] Maldives = new String[] {
               "\u0645\u0627\u0644\u062f\u0649\u06cb\u06d0 \u06cb\u0627\u0642\u062a\u0649",
               "MVT",
               "Maldives Summer Time",
               "MVST",
               "Maldives Time",
               "MVT",
            };
        final String[] Tahiti = new String[] {
               "\u062a\u0627\u064a\u062a\u0649 \u06cb\u0627\u0642\u062a\u0649",
               "TAHT",
               "Tahiti Summer Time",
               "TAHST",
               "Tahiti Time",
               "TAHT",
            };
        final String[] Israel = new String[] {
               "\u0626\u0649\u0633\u0631\u0627\u0626\u0649\u0644\u0649\u064a\u06d5 \u0626\u06c6\u0644\u0686\u06d5\u0645\u0644\u0649\u0643 \u06cb\u0627\u0642\u062a\u0649",
               "IST",
               "\u0626\u0649\u0633\u0631\u0627\u0626\u0649\u0644\u0649\u064a\u06d5 \u064a\u0627\u0632\u0644\u0649\u0642 \u06cb\u0627\u0642\u062a\u0649",
               "IDT",
               "\u0626\u0649\u0633\u0631\u0627\u0626\u0649\u0644\u0649\u064a\u06d5 \u06cb\u0627\u0642\u062a\u0649",
               "IT",
            };
        final String[] Indonesia_Central = new String[] {
               "\u0626\u0648\u062a\u062a\u06c7\u0631\u0627 \u06be\u0649\u0646\u062f\u0648\u0646\u06d0\u0632\u0649\u064a\u06d5 \u06cb\u0627\u0642\u062a\u0649",
               "WITA",
               "Central Indonesia Summer Time",
               "CIST",
               "Central Indonesia Time",
               "WITA",
            };
        final String[] Wallis = new String[] {
               "\u06cb\u0627\u0644\u0644\u0649\u0633 \u06cb\u06d5 \u0641\u06c7\u062a\u06c7\u0646\u0627 \u06cb\u0627\u0642\u062a\u0649",
               "WFT",
               "Wallis & Futuna Summer Time",
               "WFST",
               "Wallis & Futuna Time",
               "WFT",
            };
        final String[] Africa_Southern = new String[] {
               "\u062c\u06d5\u0646\u06c7\u0628\u0649\u064a \u0626\u0627\u0641\u0631\u0649\u0642\u0627 \u0626\u06c6\u0644\u0686\u06d5\u0645\u0644\u0649\u0643 \u06cb\u0627\u0642\u062a\u0649",
               "SAST",
               "South Africa Summer Time",
               "SAST",
               "South Africa Time",
               "SAT",
            };
        final String[] Syowa = new String[] {
               "\u0634\u0648\u06cb\u0627 \u06cb\u0627\u0642\u062a\u0649",
               "SYOT",
               "Syowa Summer Time",
               "SYOST",
               "Syowa Time",
               "SYOT",
            };
        final String[] Line_Islands = new String[] {
               "\u0644\u0627\u064a\u0646 \u0626\u0627\u0631\u0627\u0644\u0644\u0649\u0631\u0649 \u06cb\u0627\u0642\u062a\u0649",
               "LINT",
               "Line Is. Summer Time",
               "LINST",
               "Line Is. Time",
               "LINT",
            };
        final String[] Uzbekistan = new String[] {
               "\u0626\u06c6\u0632\u0628\u06d0\u0643\u0649\u0633\u062a\u0627\u0646 \u0626\u06c6\u0644\u0686\u06d5\u0645\u0644\u0649\u0643 \u06cb\u0627\u0642\u062a\u0649",
               "UZT",
               "\u0626\u06c6\u0632\u0628\u06d0\u0643\u0649\u0633\u062a\u0627\u0646 \u064a\u0627\u0632\u0644\u0649\u0642 \u06cb\u0627\u0642\u062a\u0649",
               "UZST",
               "\u0626\u06c6\u0632\u0628\u06d0\u0643\u0649\u0633\u062a\u0627\u0646 \u06cb\u0627\u0642\u062a\u0649",
               "UZT",
            };
        final String[] Omsk = new String[] {
               "\u0626\u0648\u0645\u0633\u0643 \u0626\u06c6\u0644\u0686\u06d5\u0645\u0644\u0649\u0643 \u06cb\u0627\u0642\u062a\u0649",
               "OMST",
               "\u0626\u0648\u0645\u0633\u0643 \u064a\u0627\u0632\u0644\u0649\u0642 \u06cb\u0627\u0642\u062a\u0649",
               "OMSST",
               "\u0626\u0648\u0645\u0633\u0643 \u06cb\u0627\u0642\u062a\u0649",
               "OMST",
            };
        final String[] Seychelles = new String[] {
               "\u0633\u06d0\u064a\u0634\u06d0\u0644 \u06cb\u0627\u0642\u062a\u0649",
               "SCT",
               "Seychelles Summer Time",
               "SCST",
               "Seychelles Time",
               "SCT",
            };
        final String[] Uruguay = new String[] {
               "\u0626\u06c7\u0631\u06c7\u06af\u06cb\u0627\u064a \u0626\u06c6\u0644\u0686\u06d5\u0645\u0644\u0649\u0643 \u06cb\u0627\u0642\u062a\u0649",
               "UYT",
               "\u0626\u06c7\u0631\u06c7\u06af\u06cb\u0627\u064a \u064a\u0627\u0632\u0644\u0649\u0642 \u06cb\u0627\u0642\u062a\u0649",
               "UYST",
               "\u0626\u06c7\u0631\u06c7\u06af\u06cb\u0627\u064a \u06cb\u0627\u0642\u062a\u0649",
               "UYT",
            };
        final String[] Nepal = new String[] {
               "\u0646\u06d0\u067e\u0627\u0644 \u06cb\u0627\u0642\u062a\u0649",
               "NPT",
               "Nepal Summer Time",
               "NPST",
               "Nepal Time",
               "NPT",
            };
        final String[] Mongolia = new String[] {
               "\u0626\u06c7\u0644\u0627\u0646\u0628\u0627\u062a\u0648\u0631 \u0626\u06c6\u0644\u0686\u06d5\u0645\u0644\u0649\u0643 \u06cb\u0627\u0642\u062a\u0649",
               "ULAT",
               "\u0626\u06c7\u0644\u0627\u0646\u0628\u0627\u062a\u0648\u0631 \u064a\u0627\u0632\u0644\u0649\u0642 \u06cb\u0627\u0642\u062a\u0649",
               "ULAST",
               "\u0626\u06c7\u0644\u0627\u0646\u0628\u0627\u062a\u0648\u0631 \u06cb\u0627\u0642\u062a\u0649",
               "ULAT",
            };
        final String[] America_Central = new String[] {
               "\u0626\u0648\u062a\u062a\u06c7\u0631\u0627 \u0642\u0649\u0633\u0649\u0645 \u0626\u06c6\u0644\u0686\u06d5\u0645\u0644\u0649\u0643 \u06cb\u0627\u0642\u062a\u0649",
               "CST",
               "\u0626\u0648\u062a\u062a\u06c7\u0631\u0627 \u0642\u0649\u0633\u0649\u0645 \u064a\u0627\u0632\u0644\u0649\u0642 \u06cb\u0627\u0642\u062a\u0649",
               "CDT",
               "\u0626\u0648\u062a\u062a\u06c7\u0631\u0627 \u0642\u0649\u0633\u0649\u0645 \u06cb\u0627\u0642\u062a\u0649",
               "CT",
            };
        final String[] Truk = new String[] {
               "\u0686\u06c7\u0643 \u06cb\u0627\u0642\u062a\u0649",
               "CHUT",
               "Chuuk Summer Time",
               "CHUST",
               "Chuuk Time",
               "CHUT",
            };
        final String[] Niue = new String[] {
               "\u0646\u0649\u064a\u06c7\u0626\u06d0 \u06cb\u0627\u0642\u062a\u0649",
               "NUT",
               "Niue Summer Time",
               "NUST",
               "Niue Time",
               "NUT",
            };
        final String[] Wake = new String[] {
               "\u06cb\u06d0\u064a\u0643 \u0626\u0627\u0631\u0649\u0644\u0649 \u06cb\u0627\u0642\u062a\u0649",
               "WAKT",
               "Wake Summer Time",
               "WAKST",
               "Wake Time",
               "WAKT",
            };
        final String[] Falkland = new String[] {
               "\u0641\u0627\u0644\u0643\u0644\u0627\u0646\u062f \u0626\u0627\u0631\u0627\u0644\u0644\u0649\u0631\u0649 \u0626\u06c6\u0644\u0686\u06d5\u0645\u0644\u0649\u0643 \u06cb\u0627\u0642\u062a\u0649",
               "FKT",
               "\u0641\u0627\u0644\u0643\u0644\u0627\u0646\u062f \u0626\u0627\u0631\u0627\u0644\u0644\u0649\u0631\u0649 \u064a\u0627\u0632\u0644\u0649\u0642 \u06cb\u0627\u0642\u062a\u0649",
               "FKST",
               "\u0641\u0627\u0644\u0643\u0644\u0627\u0646\u062f \u0626\u0627\u0631\u0627\u0644\u0644\u0649\u0631\u0649 \u06cb\u0627\u0642\u062a\u0649",
               "FKT",
            };
        final String[] Vanuatu = new String[] {
               "\u06cb\u0627\u0646\u06c7\u0626\u0627\u062a\u06c7 \u0626\u06c6\u0644\u0686\u06d5\u0645\u0644\u0649\u0643 \u06cb\u0627\u0642\u062a\u0649",
               "VUT",
               "\u06cb\u0627\u0646\u06c7\u0626\u0627\u062a\u06c7 \u064a\u0627\u0632\u0644\u0649\u0642 \u06cb\u0627\u0642\u062a\u0649",
               "VUST",
               "\u06cb\u0627\u0646\u06c7\u0626\u0627\u062a\u06c7 \u06cb\u0627\u0642\u062a\u0649",
               "VUT",
            };
        final String[] Novosibirsk = new String[] {
               "\u0646\u0648\u06cb\u0648\u0633\u0649\u0628\u0649\u0631\u0633\u0643 \u0626\u06c6\u0644\u0686\u06d5\u0645\u0644\u0649\u0643 \u06cb\u0627\u0642\u062a\u0649",
               "NOVT",
               "\u0646\u0648\u06cb\u0648\u0633\u0649\u0628\u0649\u0631\u0633\u0643 \u064a\u0627\u0632\u0644\u0649\u0642 \u06cb\u0627\u0642\u062a\u0649",
               "NOVST",
               "\u0646\u0648\u06cb\u0648\u0633\u0649\u0628\u0649\u0631\u0633\u0643 \u06cb\u0627\u0642\u062a\u0649",
               "NOVT",
            };
        final String[] Singapore = new String[] {
               "\u0633\u0649\u0646\u06af\u0627\u067e\u0648\u0631 \u06cb\u0627\u0642\u062a\u0649",
               "SRET",
               "Srednekolymsk Daylight Time",
               "SREDT",
               "Srednekolymsk Time",
               "SRET",
            };
        final String[] Azores = new String[] {
               "\u0626\u0627\u0632\u0648\u0631 \u0626\u06c6\u0644\u0686\u06d5\u0645\u0644\u0649\u0643 \u06cb\u0627\u0642\u062a\u0649",
               "AZOT",
               "\u0626\u0627\u0632\u0648\u0631 \u064a\u0627\u0632\u0644\u0649\u0642 \u06cb\u0627\u0642\u062a\u0649",
               "AZOST",
               "\u0626\u0627\u0632\u0648\u0631 \u06cb\u0627\u0642\u062a\u0649",
               "AZOT",
            };
        final String[] Bhutan = new String[] {
               "\u0628\u06c7\u062a\u0627\u0646 \u06cb\u0627\u0642\u062a\u0649",
               "BTT",
               "Bhutan Summer Time",
               "BTST",
               "Bhutan Time",
               "BTT",
            };
        final String[] Suriname = new String[] {
               "\u0633\u06c7\u0631\u0649\u0646\u0627\u0645 \u06cb\u0627\u0642\u062a\u0649",
               "SRT",
               "Suriname Summer Time",
               "SRST",
               "Suriname Time",
               "SRT",
            };
        final String[] Nauru = new String[] {
               "\u0646\u0627\u06cb\u0631\u06c7 \u06cb\u0627\u0642\u062a\u0649",
               "NRT",
               "Nauru Summer Time",
               "NRST",
               "Nauru Time",
               "NRT",
            };
        final String[] Krasnoyarsk = new String[] {
               "\u0643\u0649\u0631\u0627\u0633\u0646\u0648\u064a\u0627\u0631\u0633\u0643 \u0626\u06c6\u0644\u0686\u06d5\u0645\u0644\u0649\u0643 \u06cb\u0627\u0642\u062a\u0649",
               "KRAT",
               "\u0643\u0649\u0631\u0627\u0633\u0646\u0648\u064a\u0627\u0631\u0633\u0643 \u064a\u0627\u0632\u0644\u0649\u0642 \u06cb\u0627\u0642\u062a\u0649",
               "KRAST",
               "\u0643\u0649\u0631\u0627\u0633\u0646\u0648\u064a\u0627\u0631\u0633\u0643 \u06cb\u0627\u0642\u062a\u0649",
               "KRAT",
            };
        final String[] Kazakhstan_Western = new String[] {
               "\u063a\u06d5\u0631\u0628\u0649\u064a \u0642\u0627\u0632\u0627\u0642\u0649\u0633\u062a\u0627\u0646 \u06cb\u0627\u0642\u062a\u0649",
               "AQTT",
               "Aqtau Summer Time",
               "AQTST",
               "Aqtau Time",
               "AQTT",
            };
        final String[] Myanmar = new String[] {
               "\u0628\u0649\u0631\u0645\u0627 \u06cb\u0627\u0642\u062a\u0649",
               "MMT",
               "Myanmar Summer Time",
               "MMST",
               "Myanmar Time",
               "MMT",
            };
        final String[] Christmas = new String[] {
               "\u0631\u0648\u0698\u062f\u06d0\u0633\u062a\u06cb\u0648 \u0626\u0627\u0631\u0649\u0644\u0649 \u06cb\u0627\u0642\u062a\u0649",
               "CXT",
               "Christmas Island Summer Time",
               "CXST",
               "Christmas Island Time",
               "CIT",
            };
        final String[] Amazon = new String[] {
               "\u0626\u0627\u0645\u0627\u0632\u0648\u0646 \u0626\u06c6\u0644\u0686\u06d5\u0645\u0644\u0649\u0643 \u06cb\u0627\u0642\u062a\u0649",
               "AMT",
               "\u0626\u0627\u0645\u0627\u0632\u0648\u0646 \u064a\u0627\u0632\u0644\u0649\u0642 \u06cb\u0627\u0642\u062a\u0649",
               "AMST",
               "\u0626\u0627\u0645\u0627\u0632\u0648\u0646 \u06cb\u0627\u0642\u062a\u0649",
               "AMT",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "\u0634\u06d5\u0631\u0642\u0649\u064a \u0642\u0627\u0632\u0627\u0642\u0649\u0633\u062a\u0627\u0646 \u06cb\u0627\u0642\u062a\u0649",
               "ALMT",
               "Alma-Ata Summer Time",
               "ALMST",
               "Alma-Ata Time",
               "ALMT",
            };
        final String[] Fiji = new String[] {
               "\u0641\u0649\u062c\u0649 \u0626\u06c6\u0644\u0686\u06d5\u0645\u0644\u0649\u0643 \u06cb\u0627\u0642\u062a\u0649",
               "FJT",
               "\u0641\u0649\u062c\u0649 \u064a\u0627\u0632\u0644\u0649\u0642 \u06cb\u0627\u0642\u062a\u0649",
               "FJST",
               "\u0641\u0649\u062c\u0649 \u06cb\u0627\u0642\u062a\u0649",
               "FJT",
            };
        final String[] Reunion = new String[] {
               "\u0631\u06d0\u0626\u0648\u0646\u0649\u064a\u0648\u0646 \u06cb\u0627\u0642\u062a\u0649",
               "RET",
               "Reunion Summer Time",
               "REST",
               "Reunion Time",
               "RET",
            };
        final String[] Cocos = new String[] {
               "\u0643\u0648\u0643\u06c7\u0633 \u0626\u0627\u0631\u0649\u0644\u0649 \u06cb\u0627\u0642\u062a\u0649",
               "CCT",
               "Cocos Islands Summer Time",
               "CCST",
               "Cocos Islands Time",
               "CCT",
            };
        final String[] Chatham = new String[] {
               "\u0686\u0627\u062a\u0627\u0645 \u0626\u06c6\u0644\u0686\u06d5\u0645\u0644\u0649\u0643 \u06cb\u0627\u0642\u062a\u0649",
               "CHAST",
               "\u0686\u0627\u062a\u0627\u0645 \u064a\u0627\u0632\u0644\u0649\u0642 \u06cb\u0627\u0642\u062a\u0649",
               "CHADT",
               "\u0686\u0627\u062a\u0627\u0645 \u06cb\u0627\u0642\u062a\u0649",
               "CHAT",
            };
        final String[] Vostok = new String[] {
               "\u06cb\u0648\u0633\u062a\u0648\u0643 \u06cb\u0627\u0642\u062a\u0649",
               "VOST",
               "Vostok Summer Time",
               "VOSST",
               "Vostok Time",
               "VOST",
            };
        final String[] Argentina = new String[] {
               "\u0626\u0627\u0631\u06af\u06d0\u0646\u062a\u0649\u0646\u0627 \u0626\u06c6\u0644\u0686\u06d5\u0645\u0644\u0649\u0643 \u06cb\u0627\u0642\u062a\u0649",
               "ART",
               "\u0626\u0627\u0631\u06af\u06d0\u0646\u062a\u0649\u0646\u0627 \u064a\u0627\u0632\u0644\u0649\u0642 \u06cb\u0627\u0642\u062a\u0649",
               "ARST",
               "\u0626\u0627\u0631\u06af\u06d0\u0646\u062a\u0649\u0646\u0627 \u06cb\u0627\u0642\u062a\u0649",
               "ART",
            };
        final String[] Gambier = new String[] {
               "\u06af\u0627\u0645\u0628\u0649\u064a\u06d0\u0631 \u06cb\u0627\u0642\u062a\u0649",
               "GAMT",
               "Gambier Summer Time",
               "GAMST",
               "Gambier Time",
               "GAMT",
            };
        final String[] Kamchatka = new String[] {
               "\u067e\u06d0\u062a\u0631\u0648\u067e\u0627\u06cb\u0644\u0648\u06cb\u0633\u0643-\u0643\u0627\u0645\u0686\u0627\u062a\u0643\u0633\u0643\u0649 \u0626\u06c6\u0644\u0686\u06d5\u0645\u0644\u0649\u0643 \u06cb\u0627\u0642\u062a\u0649",
               "PETT",
               "\u067e\u06d0\u062a\u0631\u0648\u067e\u0627\u06cb\u0644\u0648\u06cb\u0633\u0643-\u0643\u0627\u0645\u0686\u0627\u062a\u0643\u0633\u0643\u0649 \u064a\u0627\u0632\u0644\u0649\u0642 \u06cb\u0627\u0642\u062a\u0649",
               "PETST",
               "\u067e\u06d0\u062a\u0631\u0648\u067e\u0627\u06cb\u0644\u0648\u06cb\u0633\u0643-\u0643\u0627\u0645\u0686\u0627\u062a\u0643\u0633\u0643\u0649 \u06cb\u0627\u0642\u062a\u0649",
               "PETT",
            };
        final String[] Tuvalu = new String[] {
               "\u062a\u06c7\u06cb\u0627\u0644\u06c7 \u06cb\u0627\u0642\u062a\u0649",
               "TVT",
               "Tuvalu Summer Time",
               "TVST",
               "Tuvalu Time",
               "TVT",
            };
        final String[] Galapagos = new String[] {
               "\u06af\u0627\u0644\u0627\u067e\u0627\u06af\u0648\u0633 \u06cb\u0627\u0642\u062a\u0649",
               "GALT",
               "Galapagos Summer Time",
               "GALST",
               "Galapagos Time",
               "GALT",
            };
        final String[] Macquarie = new String[] {
               "\u0645\u0627\u0643\u0643\u06c7\u06cb\u0627\u0631\u0649 \u0626\u0627\u0631\u0627\u0644\u0644\u0649\u0631\u0649 \u06cb\u0627\u0642\u062a\u0649",
               "MIST",
               "Macquarie Island Daylight Time",
               "MIDT",
               "Macquarie Island Time",
               "MIST",
            };
        final String[] Venezuela = new String[] {
               "\u06cb\u06d0\u0646\u06d0\u0632\u06c7\u0626\u06d0\u0644\u0627 \u06cb\u0627\u0642\u062a\u0649",
               "VET",
               "Venezuela Summer Time",
               "VEST",
               "Venezuela Time",
               "VET",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "\u06be\u0627\u06cb\u0627\u064a-\u0626\u0627\u0644\u06d0\u064a\u06c7\u062a \u0626\u06c6\u0644\u0686\u06d5\u0645\u0644\u0649\u0643 \u06cb\u0627\u0642\u062a\u0649",
               "HAST",
               "\u06be\u0627\u06cb\u0627\u064a-\u0626\u0627\u0644\u06d0\u064a\u06c7\u062a \u064a\u0627\u0632\u0644\u0649\u0642 \u06cb\u0627\u0642\u062a\u0649",
               "HADT",
               "\u06be\u0627\u06cb\u0627\u064a-\u0626\u0627\u0644\u06d0\u064a\u06c7\u062a \u06cb\u0627\u0642\u062a\u0649",
               "HAT",
            };
        final String[] Australia_Central = new String[] {
               "\u0626\u0627\u06cb\u0633\u062a\u0631\u0627\u0644\u0649\u064a\u06d5 \u0626\u0648\u062a\u062a\u06c7\u0631\u0627 \u0642\u0649\u0633\u0649\u0645 \u0626\u06c6\u0644\u0686\u06d5\u0645\u0644\u0649\u0643 \u06cb\u0627\u0642\u062a\u0649",
               "ACST",
               "\u0626\u0627\u06cb\u0633\u062a\u0631\u0627\u0644\u0649\u064a\u06d5 \u0626\u0648\u062a\u062a\u06c7\u0631\u0627 \u0642\u0649\u0633\u0649\u0645 \u064a\u0627\u0632\u0644\u0649\u0642 \u06cb\u0627\u0642\u062a\u0649",
               "ACDT",
               "\u0626\u0627\u06cb\u0633\u062a\u0631\u0627\u0644\u0649\u064a\u06d5 \u0626\u0648\u062a\u062a\u06c7\u0631\u0627 \u0642\u0649\u0633\u0649\u0645 \u06cb\u0627\u0642\u062a\u0649",
               "ACT",
            };
        final String[] America_Pacific = new String[] {
               "\u062a\u0649\u0646\u0686 \u0626\u0648\u0643\u064a\u0627\u0646 \u0626\u06c6\u0644\u0686\u06d5\u0645\u0644\u0649\u0643 \u06cb\u0627\u0642\u062a\u0649",
               "PST",
               "\u062a\u0649\u0646\u0686 \u0626\u0648\u0643\u064a\u0627\u0646 \u064a\u0627\u0632\u0644\u0649\u0642 \u06cb\u0627\u0642\u062a\u0649",
               "PDT",
               "\u062a\u0649\u0646\u0686 \u0626\u0648\u0643\u064a\u0627\u0646 \u06cb\u0627\u0642\u062a\u0649",
               "PT",
            };
        final String[] Phoenix_Islands = new String[] {
               "\u0641\u06d0\u0646\u0649\u0643\u0633 \u0626\u0627\u0631\u0627\u0644\u0644\u0649\u0631\u0649 \u06cb\u0627\u0642\u062a\u0649",
               "PHOT",
               "Phoenix Is. Summer Time",
               "PHOST",
               "Phoenix Is. Time",
               "PHOT",
            };
        final String[] Turkmenistan = new String[] {
               "\u062a\u06c8\u0631\u0643\u0645\u06d5\u0646\u0649\u0633\u062a\u0627\u0646 \u0626\u06c6\u0644\u0686\u06d5\u0645\u0644\u0649\u0643 \u06cb\u0627\u0642\u062a\u0649",
               "TMT",
               "\u062a\u06c8\u0631\u0643\u0645\u06d5\u0646\u0649\u0633\u062a\u0627\u0646 \u064a\u0627\u0632\u0644\u0649\u0642 \u06cb\u0627\u0642\u062a\u0649",
               "TMST",
               "\u062a\u06c8\u0631\u0643\u0645\u06d5\u0646\u0649\u0633\u062a\u0627\u0646 \u06cb\u0627\u0642\u062a\u0649",
               "TMT",
            };
        final String[] Europe_Western = new String[] {
               "\u063a\u06d5\u0631\u0628\u0649\u064a \u064a\u0627\u06cb\u0631\u0648\u067e\u0627 \u0626\u06c6\u0644\u0686\u06d5\u0645\u0644\u0649\u0643 \u06cb\u0627\u0642\u062a\u0649",
               "WET",
               "\u063a\u06d5\u0631\u0628\u0649\u064a \u064a\u0627\u06cb\u0631\u0648\u067e\u0627 \u064a\u0627\u0632\u0644\u0649\u0642 \u06cb\u0627\u0642\u062a\u0649",
               "WEST",
               "\u063a\u06d5\u0631\u0628\u0649\u064a \u064a\u0627\u06cb\u0631\u0648\u067e\u0627 \u06cb\u0627\u0642\u062a\u0649",
               "WET",
            };
        final String[] Cape_Verde = new String[] {
               "\u064a\u06d0\u0634\u0649\u0644 \u062a\u06c7\u0645\u0634\u06c7\u0642 \u0626\u06c6\u0644\u0686\u06d5\u0645\u0644\u0649\u0643 \u06cb\u0627\u0642\u062a\u0649",
               "CVT",
               "\u064a\u06d0\u0634\u0649\u0644 \u062a\u06c7\u0645\u0634\u06c7\u0642 \u064a\u0627\u0632\u0644\u0649\u0642 \u06cb\u0627\u0642\u062a\u0649",
               "CVST",
               "\u064a\u06d0\u0634\u0649\u0644 \u062a\u06c7\u0645\u0634\u06c7\u0642 \u06cb\u0627\u0642\u062a\u0649",
               "CVT",
            };
        final String[] Norfolk = new String[] {
               "\u0646\u0648\u0631\u0641\u0648\u0644\u0643 \u0626\u0627\u0631\u0627\u0644\u0644\u0649\u0631\u0649 \u06cb\u0627\u0642\u062a\u0649",
               "NFT",
               "Norfolk Summer Time",
               "NFST",
               "Norfolk Time",
               "NFT",
            };
        final String[] Guyana = new String[] {
               "\u06af\u0649\u06cb\u0649\u064a\u0627\u0646\u0627 \u06cb\u0627\u0642\u062a\u0649",
               "GYT",
               "Guyana Summer Time",
               "GYST",
               "Guyana Time",
               "GYT",
            };
        final String[] Pitcairn = new String[] {
               "\u067e\u0649\u062a\u0643\u0627\u064a\u0631 \u06cb\u0627\u0642\u062a\u0649",
               "PST",
               "Pitcairn Daylight Time",
               "PDT",
               "Pitcairn Time",
               "PT",
            };
        final String[] Rothera = new String[] {
               "\u0631\u0648\u062a\u06d0\u0631\u0627 \u06cb\u0627\u0642\u062a\u0649",
               "ROTT",
               "Rothera Summer Time",
               "ROTST",
               "Rothera Time",
               "ROTT",
            };
        final String[] Samoa = new String[] {
               "\u0633\u0627\u0645\u0648\u0626\u0627 \u0626\u06c6\u0644\u0686\u06d5\u0645\u0644\u0649\u0643 \u06cb\u0627\u0642\u062a\u0649",
               "SST",
               "\u0633\u06d5\u0645\u06d5\u0631\u0642\u06d5\u0646\u062a \u064a\u0627\u0632\u0644\u0649\u0642 \u06cb\u0627\u0642\u062a\u0649",
               "SDT",
               "\u0633\u0627\u0645\u0648\u0626\u0627 \u06cb\u0627\u0642\u062a\u0649",
               "ST",
            };
        final String[] Palau = new String[] {
               "\u067e\u0627\u0644\u0627\u06cb \u06cb\u0627\u0642\u062a\u0649",
               "PWT",
               "Palau Summer Time",
               "PWST",
               "Palau Time",
               "PWT",
            };
        final String[] Azerbaijan = new String[] {
               "\u0626\u06d5\u0632\u06d5\u0631\u0628\u06d5\u064a\u062c\u0627\u0646 \u0626\u06c6\u0644\u0686\u06d5\u0645\u0644\u0649\u0643 \u06cb\u0627\u0642\u062a\u0649",
               "AZT",
               "\u0626\u06d5\u0632\u06d5\u0631\u0628\u06d5\u064a\u062c\u0627\u0646 \u064a\u0627\u0632\u0644\u0649\u0642 \u06cb\u0627\u0642\u062a\u0649",
               "AZST",
               "\u0626\u06d5\u0632\u06d5\u0631\u0628\u06d5\u064a\u062c\u0627\u0646 \u06cb\u0627\u0642\u062a\u0649",
               "AZT",
            };
        final String[] Mawson = new String[] {
               "\u0645\u0627\u06cb\u0633\u0648\u0646 \u06cb\u0627\u0642\u062a\u0649",
               "MAWT",
               "Mawson Summer Time",
               "MAWST",
               "Mawson Time",
               "MAWT",
            };
        final String[] Mexico_Pacific = new String[] {
               "\u0645\u06d0\u0643\u0633\u0649\u0643\u0627 \u062a\u0649\u0646\u0686 \u0626\u0648\u0643\u064a\u0627\u0646 \u0626\u06c6\u0644\u0686\u06d5\u0645\u0644\u0649\u0643 \u06cb\u0627\u0642\u062a\u0649",
               "MST",
               "\u0645\u06d0\u0643\u0633\u0649\u0643\u0627 \u062a\u0649\u0646\u0686 \u0626\u0648\u0643\u064a\u0627\u0646 \u064a\u0627\u0632\u0644\u0649\u0642 \u06cb\u0627\u0642\u062a\u0649",
               "MDT",
               "\u0645\u06d0\u0643\u0633\u0649\u0643\u0627 \u062a\u0649\u0646\u0686 \u0626\u0648\u0643\u064a\u0627\u0646 \u06cb\u0627\u0642\u062a\u0649",
               "MT",
            };
        final String[] Davis = new String[] {
               "\u062f\u0627\u06cb\u0649\u0633 \u06cb\u0627\u0642\u062a\u0649",
               "DAVT",
               "Davis Summer Time",
               "DAVST",
               "Davis Time",
               "DAVT",
            };
        final String[] Cuba = new String[] {
               "\u0643\u06c7\u0628\u0627 \u0626\u06c6\u0644\u0686\u06d5\u0645\u0644\u0649\u0643 \u06cb\u0627\u0642\u062a\u0649",
               "CST",
               "\u0643\u06c7\u0628\u0627 \u064a\u0627\u0632\u0644\u0649\u0642 \u06cb\u0627\u0642\u062a\u0649",
               "CDT",
               "\u0643\u06c7\u0628\u0627 \u06cb\u0627\u0642\u062a\u0649",
               "CT",
            };
        final String[] Africa_Western = new String[] {
               "\u063a\u06d5\u0631\u0628\u0649\u064a \u0626\u0627\u0641\u0631\u0649\u0642\u0627 \u0626\u06c6\u0644\u0686\u06d5\u0645\u0644\u0649\u0643 \u06cb\u0627\u0642\u062a\u0649",
               "CAT",
               "\u063a\u06d5\u0631\u0628\u0649\u064a \u0626\u0627\u0641\u0631\u0649\u0642\u0627 \u064a\u0627\u0632\u0644\u0649\u0642 \u06cb\u0627\u0642\u062a\u0649",
               "CAST",
               "\u063a\u06d5\u0631\u0628\u0649\u064a \u0626\u0627\u0641\u0631\u0649\u0642\u0627 \u06cb\u0627\u0642\u062a\u0649",
               "CAT",
            };
        final String[] GMT = new String[] {
               "\u06af\u0649\u0631\u0649\u0646\u06cb\u0649\u0686 \u06cb\u0627\u0642\u062a\u0649",
               "GMT",
               "Greenwich Mean Time",
               "GMT",
               "Greenwich Mean Time",
               "GMT",
            };
        final String[] Philippines = new String[] {
               "\u0641\u0649\u0644\u0649\u067e\u067e\u0649\u0646 \u0626\u06c6\u0644\u0686\u06d5\u0645\u0644\u0649\u0643 \u06cb\u0627\u0642\u062a\u0649",
               "PHT",
               "\u0641\u0649\u0644\u0649\u067e\u067e\u0649\u0646 \u064a\u0627\u0632\u0644\u0649\u0642 \u06cb\u0627\u0642\u062a\u0649",
               "PHST",
               "\u0641\u0649\u0644\u0649\u067e\u067e\u0649\u0646 \u06cb\u0627\u0642\u062a\u0649",
               "PHT",
            };
        final String[] French_Southern = new String[] {
               "\u0641\u0649\u0631\u0627\u0646\u0633\u0649\u064a\u06d5\u06af\u06d5 \u0642\u0627\u0631\u0627\u0634\u0644\u0649\u0642 \u062c\u06d5\u0646\u06c7\u0628\u0649\u064a \u06cb\u06d5 \u0626\u0627\u0646\u062a\u0627\u0631\u0643\u062a\u0649\u0643\u0627 \u06cb\u0627\u0642\u062a\u0649",
               "TFT",
               "French Southern & Antarctic Lands Summer Time",
               "TFST",
               "French Southern & Antarctic Lands Time",
               "TFT",
            };
        final String[] South_Georgia = new String[] {
               "\u062c\u06d5\u0646\u06c7\u0628\u0649\u064a \u062c\u0648\u0631\u062c\u0649\u064a\u06d5 \u06cb\u0627\u0642\u062a\u0649",
               "GST",
               "South Georgia Daylight Time",
               "GDT",
               "South Georgia Time",
               "GT",
            };
        final String[] New_Caledonia = new String[] {
               "\u064a\u06d0\u06ad\u0649 \u0643\u0627\u0644\u06d0\u062f\u0648\u0646\u0649\u064a\u06d5 \u0626\u06c6\u0644\u0686\u06d5\u0645\u0644\u0649\u0643 \u06cb\u0627\u0642\u062a\u0649",
               "NCT",
               "\u064a\u06d0\u06ad\u0649 \u0643\u0627\u0644\u06d0\u062f\u0648\u0646\u0649\u064a\u06d5 \u064a\u0627\u0632\u0644\u0649\u0642 \u06cb\u0627\u0642\u062a\u0649",
               "NCST",
               "\u064a\u06d0\u06ad\u0649 \u0643\u0627\u0644\u06d0\u062f\u0648\u0646\u0649\u064a\u06d5 \u06cb\u0627\u0642\u062a\u0649",
               "NCT",
            };
        final String[] Brunei = new String[] {
               "\u0628\u0649\u0631\u06c7\u0646\u0649\u064a \u062f\u0627\u0631\u06c7\u0633\u0633\u0627\u0644\u0627\u0645 \u06cb\u0627\u0642\u062a\u0649",
               "BNT",
               "Brunei Summer Time",
               "BNST",
               "Brunei Time",
               "BNT",
            };
        final String[] Iran = new String[] {
               "\u0626\u0649\u0631\u0627\u0646 \u0626\u06c6\u0644\u0686\u06d5\u0645\u0644\u0649\u0643 \u06cb\u0627\u0642\u062a\u0649",
               "IRST",
               "\u0626\u0649\u0631\u0627\u0646 \u064a\u0627\u0632\u0644\u0649\u0642 \u06cb\u0627\u0642\u062a\u0649",
               "IRDT",
               "\u0626\u0649\u0631\u0627\u0646 \u06cb\u0627\u0642\u062a\u0649",
               "IRT",
            };
        final String[] Easter = new String[] {
               "\u067e\u0627\u0633\u0643\u0627\u0644\u064a\u0627 \u0626\u0627\u0631\u0649\u0644\u0649 \u0626\u06c6\u0644\u0686\u06d5\u0645\u0644\u0649\u0643 \u06cb\u0627\u0642\u062a\u0649",
               "EAST",
               "\u0626\u06d0\u0633\u062a\u06d0\u0631 \u0626\u0627\u0631\u0649\u0644\u0649 \u064a\u0627\u0632\u0644\u0649\u0642 \u06cb\u0627\u0642\u062a\u0649",
               "EASST",
               "\u0626\u06d0\u0633\u062a\u06d0\u0631 \u0626\u0627\u0631\u0649\u0644\u0649 \u06cb\u0627\u0642\u062a\u0649",
               "EAST",
            };
        final String[] Mexico_Northwest = new String[] {
               "\u0645\u06d0\u0643\u0633\u0649\u0643\u0627 \u063a\u06d5\u0631\u0628\u0649\u064a \u0634\u0649\u0645\u0627\u0644\u0649\u064a \u0642\u0649\u0633\u0649\u0645 \u0626\u06c6\u0644\u0686\u06d5\u0645\u0644\u0649\u0643 \u06cb\u0627\u0642\u062a\u0649",
               "PST",
               "\u0645\u06d0\u0643\u0633\u0649\u0643\u0627 \u063a\u06d5\u0631\u0628\u0649\u064a \u0634\u0649\u0645\u0627\u0644\u0649\u064a \u0642\u0649\u0633\u0649\u0645 \u064a\u0627\u0632\u0644\u0649\u0642 \u06cb\u0627\u0642\u062a\u0649",
               "PDT",
               "\u0645\u06d0\u0643\u0633\u0649\u0643\u0627 \u063a\u06d5\u0631\u0628\u0649\u064a \u0634\u0649\u0645\u0627\u0644\u0649\u064a \u0642\u0649\u0633\u0649\u0645 \u06cb\u0627\u0642\u062a\u0649",
               "PT",
            };
        final String[] DumontDUrville = new String[] {
               "\u062f\u06c7\u0645\u0648\u0646\u062a-\u062f\u06c7\u0631\u06cb\u0649\u0644 \u06cb\u0627\u0642\u062a\u0649",
               "DDUT",
               "Dumont-d'Urville Summer Time",
               "DDUST",
               "Dumont-d'Urville Time",
               "DDUT",
            };
        final String[] Tajikistan = new String[] {
               "\u062a\u0627\u062c\u0649\u0643\u0649\u0633\u062a\u0627\u0646 \u06cb\u0627\u0642\u062a\u0649",
               "TJT",
               "Tajikistan Summer Time",
               "TJST",
               "Tajikistan Time",
               "TJT",
            };
        final String[] Tonga = new String[] {
               "\u062a\u0648\u0646\u06af\u0627 \u0626\u06c6\u0644\u0686\u06d5\u0645\u0644\u0649\u0643 \u06cb\u0627\u0642\u062a\u0649",
               "TOT",
               "\u062a\u0648\u0646\u06af\u0627 \u064a\u0627\u0632\u0644\u0649\u0642 \u06cb\u0627\u0642\u062a\u0649",
               "TOST",
               "\u062a\u0648\u0646\u06af\u0627 \u06cb\u0627\u0642\u062a\u0649",
               "TOT",
            };
        final String[] Bangladesh = new String[] {
               "\u0628\u0627\u06ad\u0644\u0627\u062f\u0649\u0634 \u0626\u06c6\u0644\u0686\u06d5\u0645\u0644\u0649\u0643 \u06cb\u0627\u0642\u062a\u0649",
               "BDT",
               "\u0628\u0627\u06ad\u0644\u0627\u062f\u0649\u0634 \u064a\u0627\u0632\u0644\u0649\u0642 \u06cb\u0627\u0642\u062a\u0649",
               "BDST",
               "\u0628\u0627\u06ad\u0644\u0627\u062f\u0649\u0634 \u06cb\u0627\u0642\u062a\u0649",
               "BDT",
            };
        final String[] Peru = new String[] {
               "\u067e\u06d0\u0631\u06c7 \u0626\u06c6\u0644\u0686\u06d5\u0645\u0644\u0649\u0643 \u06cb\u0627\u0642\u062a\u0649",
               "PET",
               "\u067e\u06d0\u0631\u06c7 \u064a\u0627\u0632\u0644\u0649\u0642 \u06cb\u0627\u0642\u062a\u0649",
               "PEST",
               "\u067e\u06d0\u0631\u06c7 \u06cb\u0627\u0642\u062a\u0649",
               "PET",
            };
        final String[] Greenland_Western = new String[] {
               "\u063a\u06d5\u0631\u0628\u0649\u064a \u06af\u0649\u0631\u06d0\u0646\u0644\u0627\u0646\u062f \u0626\u06c6\u0644\u0686\u06d5\u0645\u0644\u0649\u0643 \u06cb\u0627\u0642\u062a\u0649",
               "WGT",
               "\u063a\u06d5\u0631\u0628\u0649\u064a \u06af\u0649\u0631\u06d0\u0646\u0644\u0627\u0646\u062f \u064a\u0627\u0632\u0644\u0649\u0642 \u06cb\u0627\u0642\u062a\u0649",
               "WGST",
               "\u063a\u06d5\u0631\u0628\u0649\u064a \u06af\u0649\u0631\u06d0\u0646\u0644\u0627\u0646\u062f \u06cb\u0627\u0642\u062a\u0649",
               "WGT",
            };
        final String[] Ecuador = new String[] {
               "\u0626\u06d0\u0643\u06cb\u0627\u062f\u0648\u0631 \u06cb\u0627\u0642\u062a\u0649",
               "ECT",
               "Ecuador Summer Time",
               "ECST",
               "Ecuador Time",
               "ECT",
            };
        final String[] Greenland_Eastern = new String[] {
               "\u0634\u06d5\u0631\u0642\u0649\u064a \u06af\u0649\u0631\u06d0\u0646\u0644\u0627\u0646\u062f \u0626\u06c6\u0644\u0686\u06d5\u0645\u0644\u0649\u0643 \u06cb\u0627\u0642\u062a\u0649",
               "EGT",
               "\u0634\u06d5\u0631\u0642\u0649\u064a \u06af\u0649\u0631\u06d0\u0646\u0644\u0627\u0646\u062f \u064a\u0627\u0632\u0644\u0649\u0642 \u06cb\u0627\u0642\u062a\u0649",
               "EGST",
               "\u0634\u06d5\u0631\u0642\u0649\u064a \u06af\u0649\u0631\u06d0\u0646\u0644\u0627\u0646\u062f \u06cb\u0627\u0642\u062a\u0649",
               "EGT",
            };
        final String[] Gulf = new String[] {
               "\u06af\u06c7\u0644\u0641 \u0626\u06c6\u0644\u0686\u06d5\u0645\u0644\u0649\u0643 \u06cb\u0627\u0642\u062a\u0649",
               "GST",
               "Gulf Daylight Time",
               "GDT",
               "Gulf Time",
               "GT",
            };
        final String[] Indonesia_Eastern = new String[] {
               "\u0634\u06d5\u0631\u0642\u0649\u064a \u06be\u0649\u0646\u062f\u0648\u0646\u06d0\u0632\u0649\u064a\u06d5 \u06cb\u0627\u0642\u062a\u0649",
               "WIT",
               "East Indonesia Summer Time",
               "EIST",
               "East Indonesia Time",
               "WIT",
            };
        final String[] Korea = new String[] {
               "\u0643\u0648\u0631\u0649\u064a\u06d5 \u0626\u06c6\u0644\u0686\u06d5\u0645\u0644\u0649\u0643 \u06cb\u0627\u0642\u062a\u0649",
               "KST",
               "\u0643\u0648\u0631\u0649\u064a\u06d5 \u064a\u0627\u0632\u0644\u0649\u0642 \u06cb\u0627\u0642\u062a\u0649",
               "KDT",
               "\u0643\u0648\u0631\u0649\u064a\u06d5 \u06cb\u0627\u0642\u062a\u0649",
               "KT",
            };
        final String[] Australia_Western = new String[] {
               "\u0626\u0627\u06cb\u0633\u062a\u0631\u0627\u0644\u0649\u064a\u06d5 \u063a\u06d5\u0631\u0628\u0649\u064a \u0642\u0649\u0633\u0649\u0645 \u0626\u06c6\u0644\u0686\u06d5\u0645\u0644\u0649\u0643 \u06cb\u0627\u0642\u062a\u0649",
               "AWST",
               "\u0626\u0627\u06cb\u0633\u062a\u0631\u0627\u0644\u0649\u064a\u06d5 \u063a\u06d5\u0631\u0628\u0649\u064a \u0642\u0649\u0633\u0649\u0645 \u064a\u0627\u0632\u0644\u0649\u0642 \u06cb\u0627\u0642\u062a\u0649",
               "AWDT",
               "\u0626\u0627\u06cb\u0633\u062a\u0631\u0627\u0644\u0649\u064a\u06d5 \u063a\u06d5\u0631\u0628\u0649\u064a \u0642\u0649\u0633\u0649\u0645 \u06cb\u0627\u0642\u062a\u0649",
               "AWT",
            };
        final String[] Kyrgystan = new String[] {
               "\u0642\u0649\u0631\u063a\u0649\u0632\u0649\u0633\u062a\u0627\u0646 \u06cb\u0627\u0642\u062a\u0649",
               "KGT",
               "Kirgizstan Summer Time",
               "KGST",
               "Kirgizstan Time",
               "KGT",
            };
        final String[] Indonesia_Western = new String[] {
               "\u063a\u06d5\u0631\u0628\u0649\u064a \u06be\u0649\u0646\u062f\u0648\u0646\u06d0\u0632\u0649\u064a\u06d5 \u06cb\u0627\u0642\u062a\u0649",
               "WIB",
               "West Indonesia Summer Time",
               "WIST",
               "West Indonesia Time",
               "WIB",
            };
        final String[] Australia_Eastern = new String[] {
               "\u0626\u0627\u06cb\u0633\u062a\u0631\u0627\u0644\u0649\u064a\u06d5 \u0634\u06d5\u0631\u0642\u0649\u064a \u0642\u0649\u0633\u0649\u0645 \u0626\u06c6\u0644\u0686\u06d5\u0645\u0644\u0649\u0643 \u06cb\u0627\u0642\u062a\u0649",
               "AEST",
               "\u0626\u0627\u06cb\u0633\u062a\u0631\u0627\u0644\u0649\u064a\u06d5 \u0634\u06d5\u0631\u0642\u0649\u064a \u0642\u0649\u0633\u0649\u0645 \u064a\u0627\u0632\u0644\u0649\u0642 \u06cb\u0627\u0642\u062a\u0649",
               "AEDT",
               "\u0626\u0627\u06cb\u0633\u062a\u0631\u0627\u0644\u0649\u064a\u06d5 \u0634\u06d5\u0631\u0642\u0649\u064a \u0642\u0649\u0633\u0649\u0645 \u06cb\u0627\u0642\u062a\u0649",
               "AET",
            };
        final String[] French_Guiana = new String[] {
               "\u0641\u0649\u0631\u0627\u0646\u0633\u0649\u064a\u06d5\u06af\u06d5 \u0642\u0627\u0631\u0627\u0634\u0644\u0649\u0642 \u06af\u0649\u06cb\u0649\u064a\u0627\u0646\u0627 \u06cb\u0627\u0642\u062a\u0649",
               "GFT",
               "French Guiana Summer Time",
               "GFST",
               "French Guiana Time",
               "GFT",
            };
        final String[] Colombia = new String[] {
               "\u0643\u0648\u0644\u0648\u0645\u0628\u0649\u064a\u06d5 \u0626\u06c6\u0644\u0686\u06d5\u0645\u0644\u0649\u0643 \u06cb\u0627\u0642\u062a\u0649",
               "COT",
               "\u0643\u0648\u0644\u0648\u0645\u0628\u0649\u064a\u06d5 \u064a\u0627\u0632\u0644\u0649\u0642 \u06cb\u0627\u0642\u062a\u0649",
               "COST",
               "\u0643\u0648\u0644\u0648\u0645\u0628\u0649\u064a\u06d5 \u06cb\u0627\u0642\u062a\u0649",
               "COT",
            };
        final String[] Chile = new String[] {
               "\u0686\u0649\u0644\u0649 \u0626\u06c6\u0644\u0686\u06d5\u0645\u0644\u0649\u0643 \u06cb\u0627\u0642\u062a\u0649",
               "CLT",
               "\u0686\u0649\u0644\u0649 \u064a\u0627\u0632\u0644\u0649\u0642 \u06cb\u0627\u0642\u062a\u0649",
               "CLST",
               "\u0686\u0649\u0644\u0649 \u06cb\u0627\u0642\u062a\u0649",
               "CLT",
            };
        final String[] Gilbert_Islands = new String[] {
               "\u06af\u0649\u0644\u0628\u06d0\u0631\u062a \u0626\u0627\u0631\u0627\u0644\u0644\u0649\u0631\u0649 \u06cb\u0627\u0642\u062a\u0649",
               "GILT",
               "Gilbert Is. Summer Time",
               "GILST",
               "Gilbert Is. Time",
               "GILT",
            };
        final String[] America_Mountain = new String[] {
               "\u062a\u0627\u063a \u0626\u06c6\u0644\u0686\u06d5\u0645\u0644\u0649\u0643 \u06cb\u0627\u0642\u062a\u0649",
               "MST",
               "\u062a\u0627\u063a \u064a\u0627\u0632\u0644\u0649\u0642 \u06cb\u0627\u0642\u062a\u0649",
               "MDT",
               "\u062a\u0627\u063a \u06cb\u0627\u0642\u062a\u0649",
               "MT",
            };
        final String[] Marquesas = new String[] {
               "\u0645\u0627\u0631\u0643\u0649\u0632 \u06cb\u0627\u0642\u062a\u0649",
               "MART",
               "Marquesas Summer Time",
               "MARST",
               "Marquesas Time",
               "MART",
            };
        final String[] Arabian = new String[] {
               "\u0626\u06d5\u0631\u06d5\u0628 \u0626\u06c6\u0644\u0686\u06d5\u0645\u0644\u0649\u0643 \u06cb\u0627\u0642\u062a\u0649",
               "AST",
               "\u0626\u06d5\u0631\u06d5\u0628 \u064a\u0627\u0632\u0644\u0649\u0642 \u06cb\u0627\u0642\u062a\u0649",
               "ADT",
               "\u0626\u06d5\u0631\u06d5\u0628 \u06cb\u0627\u0642\u062a\u0649",
               "AT",
            };
        final String[] Alaska = new String[] {
               "\u0626\u0627\u0644\u064a\u0627\u0633\u0643\u0627 \u0626\u06c6\u0644\u0686\u06d5\u0645\u0644\u0649\u0643 \u06cb\u0627\u0642\u062a\u0649",
               "AKST",
               "\u0626\u0627\u0644\u064a\u0627\u0633\u0643\u0627 \u064a\u0627\u0632\u0644\u0649\u0642 \u06cb\u0627\u0642\u062a\u0649",
               "AKDT",
               "\u0626\u0627\u0644\u064a\u0627\u0633\u0643\u0627 \u06cb\u0627\u0642\u062a\u0649",
               "AKT",
            };
        final String[] Vladivostok = new String[] {
               "\u06cb\u0649\u0644\u0627\u062f\u0649\u06cb\u0648\u0633\u062a\u0648\u0643 \u0626\u06c6\u0644\u0686\u06d5\u0645\u0644\u0649\u0643 \u06cb\u0627\u0642\u062a\u0649",
               "VLAT",
               "\u06cb\u0649\u0644\u0627\u062f\u0649\u06cb\u0648\u0633\u062a\u0648\u0643 \u064a\u0627\u0632\u0644\u0649\u0642 \u06cb\u0627\u0642\u062a\u0649",
               "VLAST",
               "\u06cb\u0649\u0644\u0627\u062f\u0649\u06cb\u0648\u0633\u062a\u0648\u0643 \u06cb\u0627\u0642\u062a\u0649",
               "VLAT",
            };
        final String[] Chamorro = new String[] {
               "\u0686\u0627\u0645\u0648\u0631\u0631\u0648 \u0626\u06c6\u0644\u0686\u06d5\u0645\u0644\u0649\u0643 \u06cb\u0627\u0642\u062a\u0649",
               "ChST",
               "Chamorro Daylight Time",
               "ChDT",
               "Chamorro Time",
               "ChT",
            };
        final String[] Irkutsk = new String[] {
               "\u0626\u0649\u0631\u0643\u06c7\u062a\u0633\u0643 \u0626\u06c6\u0644\u0686\u06d5\u0645\u0644\u0649\u0643 \u06cb\u0627\u0642\u062a\u0649",
               "IRKT",
               "\u0626\u0649\u0631\u0643\u06c7\u062a\u0633\u0643 \u064a\u0627\u0632\u0644\u0649\u0642 \u06cb\u0627\u0642\u062a\u0649",
               "IRKST",
               "\u0626\u0649\u0631\u0643\u06c7\u062a\u0633\u0643 \u06cb\u0627\u0642\u062a\u0649",
               "IRKT",
            };
        final String[] Georgia = new String[] {
               "\u06af\u0649\u0631\u06c7\u0632\u0649\u064a\u06d5 \u0626\u06c6\u0644\u0686\u06d5\u0645\u0644\u0649\u0643 \u06cb\u0627\u0642\u062a\u0649",
               "GET",
               "\u06af\u0649\u0631\u06c7\u0632\u0649\u064a\u06d5 \u064a\u0627\u0632\u0644\u0649\u0642 \u06cb\u0627\u0642\u062a\u0649",
               "GEST",
               "\u06af\u0649\u0631\u06c7\u0632\u0649\u064a\u06d5 \u06cb\u0627\u0642\u062a\u0649",
               "GET",
            };
        final String[] Tokelau = new String[] {
               "\u062a\u0648\u0643\u06d0\u0644\u0627\u06cb \u06cb\u0627\u0642\u062a\u0649",
               "TKT",
               "Tokelau Summer Time",
               "TKST",
               "Tokelau Time",
               "TKT",
            };
        final String[] Papua_New_Guinea = new String[] {
               "\u067e\u0627\u067e\u06c7\u0626\u0627 \u064a\u06d0\u06ad\u0649 \u06af\u0649\u06cb\u0649\u0646\u06d0\u064a\u06d5\u0633\u0649 \u06cb\u0627\u0642\u062a\u0649",
               "PGT",
               "Papua New Guinea Summer Time",
               "PGST",
               "Papua New Guinea Time",
               "PGT",
            };
        final String[] Noronha = new String[] {
               "\u0641\u06d0\u0631\u0646\u0627\u0646\u062f\u0648-\u0646\u0648\u0631\u0648\u0646\u062e\u0627 \u0626\u06c6\u0644\u0686\u06d5\u0645\u0644\u0649\u0643 \u06cb\u0627\u0642\u062a\u0649",
               "FNT",
               "\u0641\u06d0\u0631\u0646\u0627\u0646\u062f\u0648-\u0646\u0648\u0631\u0648\u0646\u062e\u0627 \u064a\u0627\u0632\u0644\u0649\u0642 \u06cb\u0627\u0642\u062a\u0649",
               "FNST",
               "\u0641\u06d0\u0631\u0646\u0627\u0646\u062f\u0648-\u0646\u0648\u0631\u0648\u0646\u062e\u0627 \u06cb\u0627\u0642\u062a\u0649",
               "FNT",
            };
        final String[] Choibalsan = new String[] {
               "\u0686\u0648\u064a\u0628\u0627\u0644\u0633\u0627\u0646 \u0626\u06c6\u0644\u0686\u06d5\u0645\u0644\u0649\u0643 \u06cb\u0627\u0642\u062a\u0649",
               "CHOT",
               "\u0686\u0648\u064a\u0628\u0627\u0644\u0633\u0627\u0646 \u064a\u0627\u0632\u0644\u0649\u0642 \u06cb\u0627\u0642\u062a\u0649",
               "CHOST",
               "\u0686\u0648\u064a\u0628\u0627\u0644\u0633\u0627\u0646 \u06cb\u0627\u0642\u062a\u0649",
               "CHOT",
            };
        final String[] Brasilia = new String[] {
               "\u0628\u0649\u0631\u0627\u0632\u0649\u0644\u0649\u064a\u06d5 \u0626\u06c6\u0644\u0686\u06d5\u0645\u0644\u0649\u0643 \u06cb\u0627\u0642\u062a\u0649",
               "BRT",
               "\u0628\u0649\u0631\u0627\u0632\u0649\u0644\u0649\u064a\u06d5 \u064a\u0627\u0632\u0644\u0649\u0642 \u06cb\u0627\u0642\u062a\u0649",
               "BRST",
               "\u0628\u0649\u0631\u0627\u0632\u0649\u0644\u0649\u064a\u06d5 \u06cb\u0627\u0642\u062a\u0649",
               "BRT",
            };
        final String[] China = new String[] {
               "\u062c\u06c7\u06ad\u06af\u0648 \u0626\u06c6\u0644\u0686\u06d5\u0645\u0644\u0649\u0643 \u06cb\u0627\u0642\u062a\u0649",
               "CST",
               "\u062c\u06c7\u06ad\u06af\u0648 \u064a\u0627\u0632\u0644\u0649\u0642 \u06cb\u0627\u0642\u062a\u0649",
               "CDT",
               "\u062c\u06c7\u06ad\u06af\u0648 \u06cb\u0627\u0642\u062a\u0649",
               "CT",
            };
        final String[] Armenia = new String[] {
               "\u0626\u06d5\u0631\u0645\u06d0\u0646\u0649\u064a\u06d5 \u0626\u06c6\u0644\u0686\u06d5\u0645\u0644\u0649\u0643 \u06cb\u0627\u0642\u062a\u0649",
               "AMT",
               "\u0626\u06d5\u0631\u0645\u06d0\u0646\u0649\u064a\u06d5 \u064a\u0627\u0632\u0644\u0649\u0642 \u06cb\u0627\u0642\u062a\u0649",
               "AMST",
               "\u0626\u06d5\u0631\u0645\u06d0\u0646\u0649\u064a\u06d5 \u06cb\u0627\u0642\u062a\u0649",
               "AMT",
            };
        final String[] Samara = new String[] {
               "\u0633\u0627\u0645\u0627\u0631\u0627 \u0626\u06c6\u0644\u0686\u06d5\u0645\u0644\u0649\u0643 \u06cb\u0627\u0642\u062a\u0649",
               "SAMT",
               "\u0633\u0627\u0645\u0627\u0631\u0627 \u064a\u0627\u0632\u0644\u0649\u0642 \u06cb\u0627\u0642\u062a\u0649",
               "SAMST",
               "\u0633\u0627\u0645\u0627\u0631\u0627 \u06cb\u0627\u0642\u062a\u0649",
               "SAMT",
            };
        final String[] India = new String[] {
               "\u06be\u0649\u0646\u062f\u0649\u0633\u062a\u0627\u0646 \u0626\u06c6\u0644\u0686\u06d5\u0645\u0644\u0649\u0643 \u06cb\u0627\u0642\u062a\u0649",
               "IST",
               "India Daylight Time",
               "IDT",
               "India Time",
               "IT",
            };
        final String[] Cook = new String[] {
               "\u0643\u06c7\u0643 \u0626\u0627\u0631\u0627\u0644\u0644\u0649\u0631\u0649 \u0626\u06c6\u0644\u0686\u06d5\u0645\u0644\u0649\u0643 \u06cb\u0627\u0642\u062a\u0649",
               "CKT",
               "\u0643\u06c7\u0643 \u0626\u0627\u0631\u0627\u0644\u0644\u0649\u0631\u0649 \u064a\u06d0\u0631\u0649\u0645 \u064a\u0627\u0632\u0644\u0649\u0642 \u06cb\u0627\u0642\u062a\u0649",
               "CKHST",
               "\u0643\u06c7\u0643 \u0626\u0627\u0631\u0627\u0644\u0644\u0649\u0631\u0649 \u06cb\u0627\u0642\u062a\u0649",
               "CKT",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "Asia/Aden", Arabian },
            { "America/Cuiaba", Amazon },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "America/El_Salvador", America_Central },
            { "Asia/Pontianak", Indonesia_Western },
            { "Africa/Cairo", Europe_Eastern },
            { "Pacific/Pago_Pago", Samoa },
            { "Africa/Mbabane", Africa_Southern },
            { "Asia/Kuching", Malaysia },
            { "Pacific/Rarotonga", Cook },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Europe/London",
                new String[] {
                    "\u06af\u0649\u0631\u0649\u0646\u06cb\u0649\u0686 \u06cb\u0627\u0642\u062a\u0649",
                    "GMT",
                    "\u0626\u06d5\u0646\u06af\u0644\u0649\u064a\u06d5 \u064a\u0627\u0632\u0644\u0649\u0642 \u06cb\u0627\u0642\u062a\u0649",
                    "GMT",
                    "Greenwich Mean Time",
                    "GMT",
                }
            },
            { "America/Belize", America_Central },
            { "America/Panama", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Asia/Yerevan", Armenia },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Jersey", GMT },
            { "America/Tegucigalpa", America_Central },
            { "Europe/Istanbul", Europe_Eastern },
            { "America/Eirunepe", Acre },
            { "America/Miquelon", Pierre_Miquelon },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Atlantic/St_Helena", GMT },
            { "Europe/Guernsey", GMT },
            { "America/Grand_Turk", Atlantic },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Phnom_Penh", Indochina },
            { "Africa/Kigali", Africa_Central },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Asia/Dubai", Gulf },
            { "Europe/Isle_of_Man", GMT },
            { "America/Araguaina", Brasilia },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Fakaofo", Tokelau },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "Antarctica/Syowa", Syowa },
            { "Indian/Reunion", Reunion },
            { "Pacific/Palau", Palau },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "America/Montevideo", Uruguay },
            { "Africa/Windhoek", Africa_Western },
            { "Asia/Karachi", Pakistan },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Australia/Perth", Australia_Western },
            { "Asia/Chita", Yakutsk },
            { "Pacific/Easter", Easter },
            { "Antarctica/Davis", Davis },
            { "Antarctica/McMurdo", New_Zealand },
            { "America/Manaus", Amazon },
            { "Africa/Freetown", GMT },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "Pacific/Tahiti", Tahiti },
            { "Africa/Asmera", Africa_Eastern },
            { "Europe/Busingen", Europe_Central },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Africa/Malabo", Africa_Western },
            { "Europe/Skopje", Europe_Central },
            { "America/Catamarca", Argentina },
            { "America/Godthab", Greenland_Western },
            { "Europe/Sarajevo", Europe_Central },
            { "Africa/Lagos", Africa_Western },
            { "America/Cordoba", Argentina },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mauritius", Mauritius },
            { "America/Regina", America_Central },
            { "America/Dawson_Creek", America_Mountain },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "America/Anguilla", Atlantic },
            { "Asia/Dili", East_Timor },
            { "Africa/Bamako", GMT },
            { "Pacific/Wallis", Wallis },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Lubumbashi", Africa_Central },
            { "America/Havana", Cuba },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Omsk", Omsk },
            { "Europe/Vaduz", Europe_Central },
            { "Asia/Dhaka", Bangladesh },
            { "America/Barbados", Atlantic },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Chatham", Chatham },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "America/Curacao", Atlantic },
            { "Asia/Dushanbe", Tajikistan },
            { "America/Guyana", Guyana },
            { "America/Guayaquil", Ecuador },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rankin_Inlet", America_Central },
            { "Pacific/Ponape", Ponape },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Europe/Zagreb", Europe_Central },
            { "America/Port_of_Spain", Atlantic },
            { "Europe/Helsinki", Europe_Eastern },
            { "Asia/Beirut", Europe_Eastern },
            { "Pacific/Bougainville", New_Zealand },
            { "Africa/Sao_Tome", GMT },
            { "Indian/Chagos", Indian_Ocean },
            { "America/Cayenne", French_Guiana },
            { "Asia/Yakutsk", Yakutsk },
            { "Pacific/Galapagos", Galapagos },
            { "Africa/Ndjamena", Africa_Western },
            { "Pacific/Fiji", Fiji },
            { "America/Rainy_River", America_Central },
            { "Indian/Maldives", Maldives },
            { "Asia/Oral", Kazakhstan_Western },
            { "America/Yellowknife", America_Mountain },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Jakarta", Indonesia_Western },
            { "Africa/Ceuta", Europe_Central },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "America/Noronha", Noronha },
            { "America/Swift_Current", America_Central },
            { "Australia/Adelaide", Australia_Central },
            { "America/Metlakatla", Alaska },
            { "Africa/Djibouti", Africa_Eastern },
            { "America/Paramaribo", Suriname },
            { "Europe/Simferopol", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "Europe/Prague", Europe_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/Mawson", Mawson },
            { "America/Kralendijk", Atlantic },
            { "Antarctica/Troll", GMT },
            { "Europe/Samara", Samara },
            { "Indian/Christmas", Christmas },
            { "America/Antigua", Atlantic },
            { "Pacific/Gambier", Gambier },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Pacific/Funafuti", Tuvalu },
            { "Antarctica/Macquarie", Macquarie },
            { "America/Moncton", Atlantic },
            { "Africa/Gaborone", Africa_Central },
            { "America/St_Vincent", Atlantic },
            { "Asia/Gaza", Europe_Eastern },
            { "PST8PDT", America_Pacific },
            { "Atlantic/Faeroe", Europe_Western },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "America/Yakutat", Alaska },
            { "Antarctica/Casey", Australia_Western },
            { "Europe/Copenhagen", Europe_Central },
            { "Atlantic/Azores", Azores },
            { "Europe/Vienna", Europe_Central },
            { "Pacific/Pitcairn", Pitcairn },
            { "America/Mazatlan", Mexico_Pacific },
            { "Pacific/Nauru", Nauru },
            { "Europe/Tirane", Europe_Central },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "America/Dominica", Atlantic },
            { "Africa/Abidjan", GMT },
            { "America/Mendoza", Argentina },
            { "America/Santarem", Brasilia },
            { "America/Asuncion", Paraguay },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "EST5EDT", America_Eastern },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Wake", Wake },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "Europe/Amsterdam", Europe_Central },
            { "America/Indiana/Knox", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "Africa/Accra", GMT },
            { "America/Maceio", Brasilia },
            { "Pacific/Niue", Niue },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Dublin",
                new String[] {
                    "\u06af\u0649\u0631\u0649\u0646\u06cb\u0649\u0686 \u06cb\u0627\u0642\u062a\u0649",
                    "GMT",
                    "\u0626\u0649\u0631\u06d0\u0644\u0627\u0646\u062f \u064a\u0627\u0632\u0644\u0649\u0642 \u06cb\u0627\u0642\u062a\u0649",
                    "GMT",
                    "Greenwich Mean Time",
                    "GMT",
                }
            },
            { "Pacific/Truk", Truk },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "Asia/Bishkek", Kyrgystan },
            { "Atlantic/Stanley", Falkland },
            { "Indian/Mahe", Seychelles },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Vladivostok", Vladivostok },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "America/Kentucky/Monticello", America_Eastern },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Coral_Harbour", America_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Baghdad", Arabian },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Tijuana", America_Pacific },
            { "Pacific/Saipan", Chamorro },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", Mexico_Pacific },
            { "America/Ojinaga", America_Mountain },
            { "Asia/Hovd", Hovd },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Santiago", Chile },
            { "Asia/Baku", Azerbaijan },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/La_Paz", Bolivia },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "Asia/Taipei", Taipei },
            { "Asia/Manila", Philippines },
            { "Asia/Bangkok", Indochina },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Atlantic/Madeira", Europe_Western },
            { "Antarctica/Palmer", Chile },
            { "America/Thunder_Bay", America_Eastern },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Creston", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "Antarctica/Vostok", Vostok },
            { "Europe/Andorra", Europe_Central },
            { "Asia/Vientiane", Indochina },
            { "Pacific/Kiritimati", Line_Islands },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Asia/Riyadh", Arabian },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/Oslo", Europe_Central },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "Pacific/Efate", Vanuatu },
            { "Africa/Lome", GMT },
            { "America/Bogota", Colombia },
            { "America/Menominee", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "Pacific/Norfolk", Norfolk },
            { "America/Resolute", America_Central },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "Africa/Bujumbura", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "Pacific/Auckland", New_Zealand },
            { "America/Glace_Bay", Atlantic },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "Asia/Magadan", Magadan },
            { "America/Port-au-Prince", America_Eastern },
            { "America/St_Barthelemy", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Africa/Luanda", Africa_Western },
            { "America/Nipigon", America_Eastern },
            { "Asia/Muscat", Gulf },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Cancun", America_Eastern },
            { "Africa/Maseru", Africa_Southern },
            { "Pacific/Kosrae", Kosrae },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "Australia/Sydney", Australia_Eastern },
            { "America/Lima", Peru },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "Asia/Brunei", Brunei },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Colombo", India },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Europe/Volgograd", Moscow },
            { "America/Lower_Princes", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Africa/Blantyre", Africa_Central },
            { "America/Rio_Branco", Acre },
            { "America/Danmarkshavn", GMT },
            { "America/Detroit", America_Eastern },
            { "America/Thule", Atlantic },
            { "Africa/Lusaka", Africa_Central },
            { "Asia/Hong_Kong", Hong_Kong },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Dakar", GMT },
            { "America/Tortola", Atlantic },
            { "America/Porto_Velho", Amazon },
            { "Asia/Sakhalin", Sakhalin },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Asia/Kamchatka", Kamchatka },
            { "Africa/Harare", Africa_Central },
            { "America/Nome", Alaska },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Khartoum", Africa_Eastern },
            { "Africa/Johannesburg", Africa_Southern },
            { "Africa/Bangui", Africa_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Africa/Bissau", GMT },
            { "Asia/Tehran", Iran },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "Asia/Saigon", Indochina },
            { "Pacific/Midway", Samoa },
            { "America/Jujuy", Argentina },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "America/Pangnirtung", America_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Africa/Niamey", Africa_Western },
            { "America/Whitehorse", America_Pacific },
            { "Pacific/Noumea", New_Caledonia },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Boa_Vista", Amazon },
            { "America/Grenada", Atlantic },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Rangoon", Myanmar },
            { "Europe/Bratislava", Europe_Central },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Kabul", Afghanistan },
            { "Indian/Cocos", Cocos },
            { "Pacific/Tongatapu", Tonga },
            { "America/Merida", America_Central },
            { "America/St_Kitts", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Caracas", Venezuela },
            { "America/Guadeloupe", Atlantic },
            { "Asia/Hebron", Europe_Eastern },
            { "Indian/Kerguelen", French_Southern },
            { "Africa/Monrovia", GMT },
            { "Asia/Ust-Nera", Vladivostok },
            { "Asia/Srednekolymsk", Singapore },
            { "America/North_Dakota/New_Salem", America_Central },
            { "Asia/Anadyr", Magadan },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "America/Winnipeg", America_Central },
            { "Europe/Vatican", Europe_Central },
            { "Asia/Amman", Europe_Eastern },
            { "America/Toronto", America_Eastern },
            { "Asia/Singapore", Singapore },
            { "Australia/Lindeman", Australia_Eastern },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Guadalcanal", Solomon },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Monaco", Europe_Central },
        };
        return data;
    }
}
