/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.ClipboardAssistance;
import com.sun.glass.ui.Pixels;
import com.sun.javafx.tk.ImageLoader;
import com.sun.javafx.tk.PermissionHelper;
import com.sun.javafx.tk.TKClipboard;
import com.sun.javafx.tk.Toolkit;
import com.sun.javafx.tk.quantum.PixelUtils;
import com.sun.prism.Image;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.SocketPermission;
import java.net.URL;
import java.nio.ByteBuffer;
import java.security.AccessControlContext;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.scene.image.PixelReader;
import javafx.scene.image.WritablePixelFormat;
import javafx.scene.input.DataFormat;
import javafx.scene.input.TransferMode;
import javafx.util.Pair;

final class QuantumClipboard
implements TKClipboard {
    private ClipboardAssistance systemAssistant;
    private AccessControlContext accessContext = null;
    private boolean isCaching;
    private List<Pair<DataFormat, Object>> dataCache;
    private Set<TransferMode> transferModesCache;
    private javafx.scene.image.Image dragImage = null;
    private double dragOffsetX = 0.0;
    private double dragOffsetY = 0.0;
    private static ClipboardAssistance currentDragboard;
    private static final Pattern findTagIMG;

    private QuantumClipboard() {
    }

    @Override
    public void setSecurityContext(AccessControlContext acc) {
        if (this.accessContext != null) {
            throw new RuntimeException("Clipboard security context has been already set!");
        }
        this.accessContext = acc;
    }

    private AccessControlContext getAccessControlContext() {
        if (this.accessContext == null) {
            throw new RuntimeException("Clipboard security context has not been set!");
        }
        return this.accessContext;
    }

    public static QuantumClipboard getClipboardInstance(ClipboardAssistance assistant) {
        QuantumClipboard c = new QuantumClipboard();
        c.systemAssistant = assistant;
        c.isCaching = false;
        return c;
    }

    static ClipboardAssistance getCurrentDragboard() {
        return currentDragboard;
    }

    static void releaseCurrentDragboard() {
        currentDragboard = null;
    }

    public static QuantumClipboard getDragboardInstance(ClipboardAssistance assistant, boolean isDragSource) {
        QuantumClipboard c = new QuantumClipboard();
        c.systemAssistant = assistant;
        c.isCaching = true;
        if (isDragSource) {
            currentDragboard = assistant;
        }
        return c;
    }

    public static int transferModesToClipboardActions(Set<TransferMode> tms) {
        int actions = 0;
        block5: for (TransferMode t : tms) {
            switch (t) {
                case COPY: {
                    actions |= 1;
                    continue block5;
                }
                case MOVE: {
                    actions |= 2;
                    continue block5;
                }
                case LINK: {
                    actions |= 0x40000000;
                    continue block5;
                }
            }
            throw new IllegalArgumentException("unsupported TransferMode " + tms);
        }
        return actions;
    }

    public void setSupportedTransferMode(Set<TransferMode> tm) {
        if (this.isCaching) {
            this.transferModesCache = tm;
        }
        int actions = QuantumClipboard.transferModesToClipboardActions(tm);
        this.systemAssistant.setSupportedActions(actions);
    }

    public static Set<TransferMode> clipboardActionsToTransferModes(int actions) {
        EnumSet<TransferMode> tms = EnumSet.noneOf(TransferMode.class);
        if ((actions & 1) != 0) {
            tms.add(TransferMode.COPY);
        }
        if ((actions & 2) != 0) {
            tms.add(TransferMode.MOVE);
        }
        if ((actions & 0x40000000) != 0) {
            tms.add(TransferMode.LINK);
        }
        return tms;
    }

    @Override
    public Set<TransferMode> getTransferModes() {
        if (this.transferModesCache != null) {
            return EnumSet.copyOf(this.transferModesCache);
        }
        ClipboardAssistance assistant = currentDragboard != null ? currentDragboard : this.systemAssistant;
        Set<TransferMode> tms = QuantumClipboard.clipboardActionsToTransferModes(assistant.getSupportedSourceActions());
        return tms;
    }

    @Override
    public void setDragView(javafx.scene.image.Image image) {
        this.dragImage = image;
    }

    @Override
    public void setDragViewOffsetX(double offsetX) {
        this.dragOffsetX = offsetX;
    }

    @Override
    public void setDragViewOffsetY(double offsetY) {
        this.dragOffsetY = offsetY;
    }

    @Override
    public javafx.scene.image.Image getDragView() {
        return this.dragImage;
    }

    @Override
    public double getDragViewOffsetX() {
        return this.dragOffsetX;
    }

    @Override
    public double getDragViewOffsetY() {
        return this.dragOffsetY;
    }

    public void close() {
        this.systemAssistant.close();
    }

    public void flush() {
        if (this.isCaching) {
            this.putContentToPeer(this.dataCache.toArray(new Pair[0]));
        }
        this.clearCache();
        this.clearDragView();
        this.systemAssistant.flush();
    }

    @Override
    public Object getContent(DataFormat dataFormat) {
        ClipboardAssistance assistant;
        if (this.dataCache != null) {
            for (Pair<DataFormat, Object> pair : this.dataCache) {
                if (pair.getKey() != dataFormat) continue;
                return pair.getValue();
            }
            return null;
        }
        ClipboardAssistance clipboardAssistance = assistant = currentDragboard != null ? currentDragboard : this.systemAssistant;
        if (dataFormat == DataFormat.IMAGE) {
            return this.readImage();
        }
        if (dataFormat == DataFormat.URL) {
            return assistant.getData("text/uri-list");
        }
        if (dataFormat == DataFormat.FILES) {
            Object data = assistant.getData("application/x-java-file-list");
            if (data == null) {
                return Collections.emptyList();
            }
            String[] paths = (String[])data;
            ArrayList<File> list = new ArrayList<File>(paths.length);
            for (int i = 0; i < paths.length; ++i) {
                list.add(new File(paths[i]));
            }
            return list;
        }
        for (String mimeType : dataFormat.getIdentifiers()) {
            Object data = assistant.getData(mimeType);
            if (data instanceof ByteBuffer) {
                try {
                    ByteBuffer bb = (ByteBuffer)data;
                    ByteArrayInputStream bis = new ByteArrayInputStream(bb.array());
                    ObjectInputStream in = new ObjectInputStream(bis){

                        @Override
                        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                            return Class.forName(desc.getName(), false, Thread.currentThread().getContextClassLoader());
                        }
                    };
                    data = in.readObject();
                }
                catch (IOException iOException) {
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            if (data == null) continue;
            return data;
        }
        return null;
    }

    private static javafx.scene.image.Image convertObjectToImage(Object obj) {
        Pixels pixels;
        if (obj instanceof javafx.scene.image.Image) {
            return (javafx.scene.image.Image)obj;
        }
        if (obj instanceof ByteBuffer) {
            ByteBuffer bb = (ByteBuffer)obj;
            try {
                bb.rewind();
                int width = bb.getInt();
                int height = bb.getInt();
                pixels = Application.GetApplication().createPixels(width, height, bb.slice());
            }
            catch (Exception e) {
                return null;
            }
        } else if (obj instanceof Pixels) {
            pixels = (Pixels)obj;
        } else {
            return null;
        }
        Image platformImage = PixelUtils.pixelsToImage(pixels);
        ImageLoader il = Toolkit.getToolkit().loadPlatformImage(platformImage);
        return javafx.scene.image.Image.impl_fromPlatformImage(il);
    }

    private javafx.scene.image.Image readImage() {
        ClipboardAssistance assistant = currentDragboard != null ? currentDragboard : this.systemAssistant;
        Object rawData = assistant.getData("application/x-java-rawimage");
        if (rawData == null) {
            String url;
            Object htmlData = assistant.getData("text/html");
            if (htmlData != null && (url = this.parseIMG(htmlData)) != null) {
                try {
                    SecurityManager sm = System.getSecurityManager();
                    if (sm != null) {
                        AccessControlContext context = this.getAccessControlContext();
                        URL u = new URL(url);
                        String protocol = u.getProtocol();
                        if (protocol.equalsIgnoreCase("jar")) {
                            String file = u.getFile();
                            u = new URL(file);
                            protocol = u.getProtocol();
                        }
                        if (protocol.equalsIgnoreCase("file")) {
                            FilePermission fp = new FilePermission(u.getFile(), "read");
                            sm.checkPermission(fp, context);
                        } else if (protocol.equalsIgnoreCase("ftp") || protocol.equalsIgnoreCase("http") || protocol.equalsIgnoreCase("https")) {
                            int port = u.getPort();
                            String hoststr = port == -1 ? u.getHost() : u.getHost() + ":" + port;
                            SocketPermission sp = new SocketPermission(hoststr, "connect");
                            sm.checkPermission(sp, context);
                        } else {
                            Permission clipboardPerm = PermissionHelper.getAccessClipboardPermission();
                            sm.checkPermission(clipboardPerm, context);
                        }
                    }
                    return new javafx.scene.image.Image(url);
                }
                catch (MalformedURLException mue) {
                    return null;
                }
                catch (SecurityException se) {
                    return null;
                }
            }
            return null;
        }
        return QuantumClipboard.convertObjectToImage(rawData);
    }

    private String parseIMG(Object data) {
        if (data == null) {
            return null;
        }
        if (!(data instanceof String)) {
            return null;
        }
        String str = (String)data;
        Matcher matcher = findTagIMG.matcher(str);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    private boolean placeImage(javafx.scene.image.Image image) {
        if (image == null) {
            return false;
        }
        String url = image.impl_getUrl();
        if (url == null || PixelUtils.supportedFormatType(url)) {
            Image prismImage = (Image)image.impl_getPlatformImage();
            Pixels pixels = PixelUtils.imageToPixels(prismImage);
            if (pixels != null) {
                this.systemAssistant.setData("application/x-java-rawimage", pixels);
                return true;
            }
            return false;
        }
        this.systemAssistant.setData("text/uri-list", url);
        return true;
    }

    @Override
    public Set<DataFormat> getContentTypes() {
        HashSet<DataFormat> set = new HashSet<DataFormat>();
        if (this.dataCache != null) {
            for (Pair<DataFormat, Object> pair : this.dataCache) {
                set.add(pair.getKey());
            }
            return set;
        }
        ClipboardAssistance assistant = currentDragboard != null ? currentDragboard : this.systemAssistant;
        String[] types = assistant.getMimeTypes();
        if (types == null) {
            return set;
        }
        for (String t : types) {
            if (t.equalsIgnoreCase("application/x-java-rawimage")) {
                set.add(DataFormat.IMAGE);
                continue;
            }
            if (t.equalsIgnoreCase("text/uri-list")) {
                set.add(DataFormat.URL);
                continue;
            }
            if (t.equalsIgnoreCase("application/x-java-file-list")) {
                set.add(DataFormat.FILES);
                continue;
            }
            if (t.equalsIgnoreCase("text/html")) {
                set.add(DataFormat.HTML);
                try {
                    if (this.parseIMG(assistant.getData("text/html")) == null) continue;
                    set.add(DataFormat.IMAGE);
                }
                catch (Exception exception) {}
                continue;
            }
            DataFormat dataFormat = DataFormat.lookupMimeType(t);
            if (dataFormat == null) {
                dataFormat = new DataFormat(t);
            }
            set.add(dataFormat);
        }
        return set;
    }

    @Override
    public boolean hasContent(DataFormat dataFormat) {
        if (this.dataCache != null) {
            for (Pair<DataFormat, Object> pair : this.dataCache) {
                if (pair.getKey() != dataFormat) continue;
                return true;
            }
            return false;
        }
        ClipboardAssistance assistant = currentDragboard != null ? currentDragboard : this.systemAssistant;
        String[] stypes = assistant.getMimeTypes();
        if (stypes == null) {
            return false;
        }
        for (String t : stypes) {
            if (dataFormat == DataFormat.IMAGE && t.equalsIgnoreCase("application/x-java-rawimage")) {
                return true;
            }
            if (dataFormat == DataFormat.URL && t.equalsIgnoreCase("text/uri-list")) {
                return true;
            }
            if (dataFormat == DataFormat.IMAGE && t.equalsIgnoreCase("text/html") && this.parseIMG(assistant.getData("text/html")) != null) {
                return true;
            }
            if (dataFormat == DataFormat.FILES && t.equalsIgnoreCase("application/x-java-file-list")) {
                return true;
            }
            DataFormat found = DataFormat.lookupMimeType(t);
            if (found == null || !found.equals(dataFormat)) continue;
            return true;
        }
        return false;
    }

    private static ByteBuffer prepareImage(javafx.scene.image.Image image) {
        PixelReader pr = image.getPixelReader();
        int w = (int)image.getWidth();
        int h = (int)image.getHeight();
        byte[] pixels = new byte[w * h * 4];
        pr.getPixels(0, 0, w, h, WritablePixelFormat.getByteBgraInstance(), pixels, 0, w * 4);
        ByteBuffer dragImageBuffer = ByteBuffer.allocate(8 + w * h * 4);
        dragImageBuffer.putInt(w);
        dragImageBuffer.putInt(h);
        dragImageBuffer.put(pixels);
        return dragImageBuffer;
    }

    private static ByteBuffer prepareOffset(double offsetX, double offsetY) {
        ByteBuffer dragImageOffset = ByteBuffer.allocate(8);
        dragImageOffset.rewind();
        dragImageOffset.putInt((int)offsetX);
        dragImageOffset.putInt((int)offsetY);
        return dragImageOffset;
    }

    private boolean putContentToPeer(Pair<DataFormat, Object> ... content) {
        this.systemAssistant.emptyCache();
        boolean dataSet = false;
        for (Pair<DataFormat, Object> pair : content) {
            DataFormat dataFormat = pair.getKey();
            Object data = pair.getValue();
            if (dataFormat == DataFormat.IMAGE) {
                dataSet = this.placeImage(QuantumClipboard.convertObjectToImage(data));
                continue;
            }
            if (dataFormat == DataFormat.URL) {
                this.systemAssistant.setData("text/uri-list", data);
                dataSet = true;
                continue;
            }
            if (dataFormat == DataFormat.RTF) {
                this.systemAssistant.setData("text/rtf", data);
                dataSet = true;
                continue;
            }
            if (dataFormat == DataFormat.FILES) {
                List list = (List)data;
                if (list.size() == 0) continue;
                String[] paths = new String[list.size()];
                int i = 0;
                for (File f : list) {
                    paths[i++] = f.getAbsolutePath();
                }
                this.systemAssistant.setData("application/x-java-file-list", paths);
                dataSet = true;
                continue;
            }
            if (data instanceof Serializable) {
                if (dataFormat != DataFormat.PLAIN_TEXT && dataFormat != DataFormat.HTML || !(data instanceof String)) {
                    try {
                        ByteArrayOutputStream bos = new ByteArrayOutputStream();
                        ObjectOutputStream out = new ObjectOutputStream(bos);
                        out.writeObject(data);
                        out.close();
                        data = ByteBuffer.wrap(bos.toByteArray());
                    }
                    catch (IOException e) {
                        throw new IllegalArgumentException("Could not serialize the data", e);
                    }
                }
            } else if (data instanceof InputStream) {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                try (InputStream is = (InputStream)data;){
                    int i = is.read();
                    while (i != -1) {
                        bout.write(i);
                        i = is.read();
                    }
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Could not serialize the data", e);
                }
                data = ByteBuffer.wrap(bout.toByteArray());
            } else if (!(data instanceof ByteBuffer)) {
                throw new IllegalArgumentException("Only serializable objects or ByteBuffer can be used as data with data format " + dataFormat);
            }
            for (String mimeType : dataFormat.getIdentifiers()) {
                this.systemAssistant.setData(mimeType, data);
                dataSet = true;
            }
        }
        if (this.dragImage != null) {
            ByteBuffer imageBuffer = QuantumClipboard.prepareImage(this.dragImage);
            ByteBuffer offsetBuffer = QuantumClipboard.prepareOffset(this.dragOffsetX, this.dragOffsetY);
            this.systemAssistant.setData("application/x-java-drag-image", imageBuffer);
            this.systemAssistant.setData("application/x-java-drag-image-offset", offsetBuffer);
        }
        return dataSet;
    }

    @Override
    public boolean putContent(Pair<DataFormat, Object> ... content) {
        for (Pair<DataFormat, Object> pair : content) {
            DataFormat format = pair.getKey();
            Object data = pair.getValue();
            if (format == null) {
                throw new NullPointerException("Clipboard.putContent: null data format");
            }
            if (data != null) continue;
            throw new NullPointerException("Clipboard.putContent: null data");
        }
        boolean dataSet = false;
        if (this.isCaching) {
            if (this.dataCache == null) {
                this.dataCache = new ArrayList<Pair<DataFormat, Object>>(content.length);
            }
            for (Pair<DataFormat, Object> pair : content) {
                this.dataCache.add(pair);
                dataSet = true;
            }
        } else {
            dataSet = this.putContentToPeer(content);
            this.systemAssistant.flush();
        }
        return dataSet;
    }

    private void clearCache() {
        this.dataCache = null;
        this.transferModesCache = null;
    }

    private void clearDragView() {
        this.dragImage = null;
        this.dragOffsetY = 0.0;
        this.dragOffsetX = 0.0;
    }

    static {
        findTagIMG = Pattern.compile("IMG\\s+SRC=\\\"([^\\\"]+)\\\"", 34);
    }
}

