/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.sg.prism;

import com.sun.javafx.geom.Vec3d;
import com.sun.javafx.geom.transform.Affine3D;
import com.sun.javafx.sg.prism.NGAmbientLight;
import com.sun.javafx.sg.prism.NGLightBase;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.sg.prism.NGPhongMaterial;
import com.sun.javafx.sg.prism.NGPointLight;
import com.sun.javafx.sg.prism.NGTriangleMesh;
import com.sun.prism.Graphics;
import com.sun.prism.Material;
import com.sun.prism.MeshView;
import com.sun.prism.PrinterGraphics;
import com.sun.prism.ResourceFactory;
import javafx.application.ConditionalFeature;
import javafx.application.Platform;
import javafx.scene.shape.CullFace;
import javafx.scene.shape.DrawMode;

public abstract class NGShape3D
extends NGNode {
    private NGPhongMaterial material;
    private DrawMode drawMode;
    private CullFace cullFace;
    private boolean materialDirty = false;
    private boolean drawModeDirty = false;
    NGTriangleMesh mesh;
    private MeshView meshView;

    public void setMaterial(NGPhongMaterial material) {
        this.material = material;
        this.materialDirty = true;
        this.visualsChanged();
    }

    public void setDrawMode(Object drawMode) {
        this.drawMode = (DrawMode)((Object)drawMode);
        this.drawModeDirty = true;
        this.visualsChanged();
    }

    public void setCullFace(Object cullFace) {
        this.cullFace = (CullFace)((Object)cullFace);
        this.visualsChanged();
    }

    void invalidate() {
        this.meshView = null;
        this.visualsChanged();
    }

    private void renderMeshView(Graphics g) {
        g.setup3DRendering();
        ResourceFactory rf = g.getResourceFactory();
        if (this.meshView == null && this.mesh != null) {
            this.meshView = rf.createMeshView(this.mesh.createMesh(rf));
            this.drawModeDirty = true;
            this.materialDirty = true;
        }
        if (this.meshView == null || !this.mesh.validate()) {
            return;
        }
        Material mtl = this.material.createMaterial(rf);
        if (this.materialDirty) {
            this.meshView.setMaterial(mtl);
            this.materialDirty = false;
        }
        int cullingMode = this.cullFace.ordinal();
        if (this.cullFace.ordinal() != MeshView.CULL_NONE && g.getTransformNoClone().getDeterminant() < 0.0) {
            cullingMode = cullingMode == MeshView.CULL_BACK ? MeshView.CULL_FRONT : MeshView.CULL_BACK;
        }
        this.meshView.setCullingMode(cullingMode);
        if (this.drawModeDirty) {
            this.meshView.setWireframe(this.drawMode == DrawMode.LINE);
            this.drawModeDirty = false;
        }
        int pointLightIdx = 0;
        if (g.getLights() == null || g.getLights()[0] == null) {
            this.meshView.setAmbientLight(0.0f, 0.0f, 0.0f);
            Vec3d cameraPos = g.getCameraNoClone().getPositionInWorld(null);
            this.meshView.setPointLight(pointLightIdx++, (float)cameraPos.x, (float)cameraPos.y, (float)cameraPos.z, 1.0f, 1.0f, 1.0f, 1.0f);
        } else {
            NGLightBase lightBase;
            float ambientRed = 0.0f;
            float ambientBlue = 0.0f;
            float ambientGreen = 0.0f;
            for (int i = 0; i < g.getLights().length && (lightBase = g.getLights()[i]) != null; ++i) {
                if (!lightBase.affects(this)) continue;
                float rL = lightBase.getColor().getRed();
                float gL = lightBase.getColor().getGreen();
                float bL = lightBase.getColor().getBlue();
                if (lightBase instanceof NGPointLight) {
                    NGPointLight light = (NGPointLight)lightBase;
                    if (rL == 0.0f && gL == 0.0f && bL == 0.0f) continue;
                    Affine3D lightWT = light.getWorldTransform();
                    this.meshView.setPointLight(pointLightIdx++, (float)lightWT.getMxt(), (float)lightWT.getMyt(), (float)lightWT.getMzt(), rL, gL, bL, 1.0f);
                    continue;
                }
                if (!(lightBase instanceof NGAmbientLight)) continue;
                ambientRed += rL;
                ambientGreen += gL;
                ambientBlue += bL;
            }
            ambientRed = NGShape3D.saturate(ambientRed);
            ambientGreen = NGShape3D.saturate(ambientGreen);
            ambientBlue = NGShape3D.saturate(ambientBlue);
            this.meshView.setAmbientLight(ambientRed, ambientGreen, ambientBlue);
        }
        while (pointLightIdx < 3) {
            this.meshView.setPointLight(pointLightIdx++, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        }
        this.meshView.render(g);
    }

    private static float saturate(float value) {
        return value < 1.0f ? (value < 0.0f ? 0.0f : value) : 1.0f;
    }

    public void setMesh(NGTriangleMesh triangleMesh) {
        this.mesh = triangleMesh;
        this.meshView = null;
        this.visualsChanged();
    }

    @Override
    protected void renderContent(Graphics g) {
        if (!Platform.isSupported(ConditionalFeature.SCENE3D) || this.material == null || g instanceof PrinterGraphics) {
            return;
        }
        this.renderMeshView(g);
    }

    @Override
    boolean isShape3D() {
        return true;
    }

    @Override
    protected boolean hasOverlappingContents() {
        return false;
    }

    @Override
    public void release() {
    }
}

