/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.behavior;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.behavior.KeyBinding;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.control.ButtonBase;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;

public class ButtonBehavior<C extends ButtonBase>
extends BehaviorBase<C> {
    private boolean keyDown;
    private static final String PRESS_ACTION = "Press";
    private static final String RELEASE_ACTION = "Release";
    protected static final List<KeyBinding> BUTTON_BINDINGS = new ArrayList<KeyBinding>();

    public ButtonBehavior(C button) {
        super(button, BUTTON_BINDINGS);
    }

    public ButtonBehavior(C button, List<KeyBinding> bindings) {
        super(button, bindings);
    }

    @Override
    protected void focusChanged() {
        ButtonBase button = (ButtonBase)this.getControl();
        if (this.keyDown && !button.isFocused()) {
            this.keyDown = false;
            button.disarm();
        }
    }

    @Override
    protected void callAction(String name) {
        if (!((ButtonBase)this.getControl()).isDisabled()) {
            if (PRESS_ACTION.equals(name)) {
                this.keyPressed();
            } else if (RELEASE_ACTION.equals(name)) {
                this.keyReleased();
            } else {
                super.callAction(name);
            }
        }
    }

    private void keyPressed() {
        ButtonBase button = (ButtonBase)this.getControl();
        if (!button.isPressed() && !button.isArmed()) {
            this.keyDown = true;
            button.arm();
        }
    }

    private void keyReleased() {
        ButtonBase button = (ButtonBase)this.getControl();
        if (this.keyDown) {
            this.keyDown = false;
            if (button.isArmed()) {
                button.disarm();
                button.fire();
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        boolean valid;
        ButtonBase button = (ButtonBase)this.getControl();
        super.mousePressed(e);
        if (!button.isFocused() && button.isFocusTraversable()) {
            button.requestFocus();
        }
        boolean bl = valid = e.getButton() == MouseButton.PRIMARY && !e.isMiddleButtonDown() && !e.isSecondaryButtonDown() && !e.isShiftDown() && !e.isControlDown() && !e.isAltDown() && !e.isMetaDown();
        if (!button.isArmed() && valid) {
            button.arm();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        ButtonBase button = (ButtonBase)this.getControl();
        if (!this.keyDown && button.isArmed()) {
            button.fire();
            button.disarm();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        ButtonBase button = (ButtonBase)this.getControl();
        super.mouseEntered(e);
        if (!this.keyDown && button.isPressed()) {
            button.arm();
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        ButtonBase button = (ButtonBase)this.getControl();
        super.mouseExited(e);
        if (!this.keyDown && button.isArmed()) {
            button.disarm();
        }
    }

    static {
        BUTTON_BINDINGS.add(new KeyBinding(KeyCode.SPACE, KeyEvent.KEY_PRESSED, PRESS_ACTION));
        BUTTON_BINDINGS.add(new KeyBinding(KeyCode.SPACE, KeyEvent.KEY_RELEASED, RELEASE_ACTION));
    }
}

