/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.css;

import com.sun.javafx.css.BitSet;
import com.sun.javafx.css.PseudoClassImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javafx.css.PseudoClass;

public final class PseudoClassState
extends BitSet<PseudoClass> {
    static final Map<String, Integer> pseudoClassMap = new HashMap<String, Integer>(64);
    static final List<PseudoClass> pseudoClasses = new ArrayList<PseudoClass>();

    public PseudoClassState() {
    }

    PseudoClassState(List<String> pseudoClassNames) {
        int nMax = pseudoClassNames != null ? pseudoClassNames.size() : 0;
        for (int n = 0; n < nMax; ++n) {
            PseudoClass sc = PseudoClassState.getPseudoClass(pseudoClassNames.get(n));
            this.add(sc);
        }
    }

    @Override
    public Object[] toArray() {
        return this.toArray(new PseudoClass[this.size()]);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (a.length < this.size()) {
            a = new PseudoClass[this.size()];
        }
        int index = 0;
        while (index < this.getBits().length) {
            long state = this.getBits()[index];
            for (int bit = 0; bit < 64; ++bit) {
                long mask = 1L << bit;
                if ((state & mask) != mask) continue;
                int n = index * 64 + bit;
                PseudoClass impl = PseudoClassState.getPseudoClass(n);
                a[index++] = impl;
            }
        }
        return a;
    }

    public String toString() {
        ArrayList<String> strings = new ArrayList<String>();
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            strings.add(((PseudoClass)iter.next()).getPseudoClassName());
        }
        return ((Object)strings).toString();
    }

    @Override
    protected PseudoClass cast(Object o) {
        if (o == null) {
            throw new NullPointerException("null arg");
        }
        PseudoClass pseudoClass = (PseudoClass)o;
        return pseudoClass;
    }

    @Override
    protected PseudoClass getT(int index) {
        return PseudoClassState.getPseudoClass(index);
    }

    @Override
    protected int getIndex(PseudoClass t) {
        if (t instanceof PseudoClassImpl) {
            return ((PseudoClassImpl)t).getIndex();
        }
        String pseudoClass = t.getPseudoClassName();
        Integer index = pseudoClassMap.get(pseudoClass);
        if (index == null) {
            index = pseudoClasses.size();
            pseudoClasses.add(new PseudoClassImpl(pseudoClass, index));
            pseudoClassMap.put(pseudoClass, index);
        }
        return index;
    }

    public static PseudoClass getPseudoClass(String pseudoClass) {
        if (pseudoClass == null || pseudoClass.trim().isEmpty()) {
            throw new IllegalArgumentException("pseudoClass cannot be null or empty String");
        }
        PseudoClass instance = null;
        Integer value = pseudoClassMap.get(pseudoClass);
        int index = value != null ? value : -1;
        int size = pseudoClasses.size();
        assert (index < size);
        if (index != -1 && index < size) {
            instance = pseudoClasses.get(index);
        }
        if (instance == null) {
            instance = new PseudoClassImpl(pseudoClass, size);
            pseudoClasses.add(instance);
            pseudoClassMap.put(pseudoClass, size);
        }
        return instance;
    }

    static PseudoClass getPseudoClass(int index) {
        if (0 <= index && index < pseudoClasses.size()) {
            return pseudoClasses.get(index);
        }
        return null;
    }
}

