/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tools.ant;

import com.sun.javafx.tools.ant.Application;
import com.sun.javafx.tools.ant.Permissions;
import com.sun.javafx.tools.ant.Platform;
import com.sun.javafx.tools.ant.Resources;
import com.sun.javafx.tools.ant.Utils;
import com.sun.javafx.tools.packager.CreateJarParams;
import com.sun.javafx.tools.packager.PackagerLib;
import java.io.File;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Manifest;
import org.apache.tools.ant.types.FileSet;

public class FXJar
extends Task {
    private String destFile = null;
    private String codebase = null;
    private Application app = null;
    private Platform platform = null;
    private Resources resources = null;
    private List<FileSet> filesets = new LinkedList<FileSet>();
    private Manifest manifest = null;
    private PackagerLib packager = new PackagerLib();
    private CreateJarParams createJarParams = new CreateJarParams();
    private boolean css2bin = false;
    private boolean verbose = false;
    private Permissions perms = null;

    public void setVerbose(boolean v) {
        this.verbose = v;
    }

    public Application createApplication() {
        this.app = new Application();
        return this.app;
    }

    public Platform createPlatform() {
        this.platform = new Platform();
        return this.platform;
    }

    public Permissions createPermissions() {
        this.perms = new Permissions();
        return this.perms;
    }

    public Resources createResources() {
        this.resources = new Resources();
        return this.resources;
    }

    public void setDestfile(String v) {
        this.destFile = v;
    }

    public void setCodebase(String v) {
        this.codebase = v;
    }

    public void setCss2Bin(boolean v) {
        this.css2bin = v;
    }

    public void execute() {
        File f;
        this.checkAttributesAndElements();
        this.createJarParams.setCss2bin(this.css2bin);
        if (this.app != null) {
            this.createJarParams.setApplicationClass(this.app.get().mainClass);
            this.createJarParams.setPreloader(this.app.get().preloaderClass);
            this.createJarParams.setFallback(this.app.get().fallbackApp);
            this.createJarParams.setParams(this.app.get().parameters);
            this.createJarParams.setArguments(this.app.get().getArguments());
        }
        if (this.perms != null) {
            this.createJarParams.setAllPermissions(this.perms.getElevated());
        }
        if (this.codebase != null) {
            this.createJarParams.setCodebase(this.codebase);
        }
        if (this.platform != null) {
            this.createJarParams.setFxVersion(this.platform.get().javafx);
        }
        if (this.resources != null) {
            this.createJarParams.setClasspath(this.resources.exportAsClassPath());
        }
        this.createJarParams.setOutdir((f = new File(this.destFile)).isAbsolute() ? null : this.getProject().getBaseDir());
        this.createJarParams.setOutfile(this.destFile);
        if (this.manifest != null) {
            this.createJarParams.setManifestAttrs(FXJar.getAttrSet(this.manifest));
        }
        for (FileSet fileset : this.filesets) {
            Utils.addResources(this.createJarParams, fileset);
        }
        try {
            this.packager.packageAsJar(this.createJarParams);
        }
        catch (Exception e) {
            throw new BuildException(e.getMessage(), (Throwable)e);
        }
    }

    public Manifest createManifest() {
        this.manifest = new Manifest();
        return this.manifest;
    }

    public FileSet createFileSet() {
        FileSet fileset = new FileSet();
        fileset.setProject(this.getProject());
        this.filesets.add(fileset);
        return fileset;
    }

    private void checkAttributesAndElements() {
        if (this.destFile == null) {
            throw new BuildException("You must specify the destfile file to create.");
        }
        File f = new File(this.destFile);
        if (!f.isAbsolute()) {
            f = new File(this.getProject().getBaseDir(), this.destFile);
        }
        if (f.exists() && !f.isFile()) {
            throw new BuildException(this.destFile + " is not a file.");
        }
        if (f.exists() && !f.canWrite()) {
            throw new BuildException(this.destFile + " is read-only.");
        }
        if (this.filesets.isEmpty()) {
            throw new BuildException("You must specify at least one fileset to be packed.");
        }
        boolean haveNonEmpty = false;
        for (FileSet fileset : this.filesets) {
            if (fileset.size() == 0) continue;
            haveNonEmpty = true;
            break;
        }
        if (!haveNonEmpty) {
            throw new BuildException("All filesets are empty.");
        }
        if (this.app != null) {
            this.app.selfcheck();
        }
    }

    private static Map<String, String> getAttrSet(Manifest manifest) {
        HashMap<String, String> result = new HashMap<String, String>();
        Manifest.Section mainSection = manifest.getMainSection();
        Enumeration e = mainSection.getAttributeKeys();
        while (e.hasMoreElements()) {
            String attrKey = (String)e.nextElement();
            Manifest.Attribute attr = mainSection.getAttribute(attrKey);
            result.put(attr.getName(), attr.getValue());
        }
        return result;
    }
}

