#ifndef _EFL_INTERPOLATOR_SINUSOIDAL_EO_H_
#define _EFL_INTERPOLATOR_SINUSOIDAL_EO_H_

#ifndef _EFL_INTERPOLATOR_SINUSOIDAL_EO_CLASS_TYPE
#define _EFL_INTERPOLATOR_SINUSOIDAL_EO_CLASS_TYPE

typedef Eo Efl_Interpolator_Sinusoidal;

#endif

#ifndef _EFL_INTERPOLATOR_SINUSOIDAL_EO_TYPES
#define _EFL_INTERPOLATOR_SINUSOIDAL_EO_TYPES


#endif
/**
 * @brief Efl sinusoidal interpolator class
 *
 * output = (1 - cos(input * Pi)) / 2;
 *
 * @ingroup Efl_Interpolator_Sinusoidal
 */
#define EFL_INTERPOLATOR_SINUSOIDAL_CLASS efl_interpolator_sinusoidal_class_get()

EWAPI const Efl_Class *efl_interpolator_sinusoidal_class_get(void);

/**
 * @brief Factor property
 *
 * @param[in] obj The object.
 * @param[in] factor Factor of the interpolation function.
 *
 * @ingroup Efl_Interpolator_Sinusoidal
 */
EOAPI void efl_interpolator_sinusoidal_factor_set(Eo *obj, double factor);

/**
 * @brief Factor property
 *
 * @param[in] obj The object.
 *
 * @return Factor of the interpolation function.
 *
 * @ingroup Efl_Interpolator_Sinusoidal
 */
EOAPI double efl_interpolator_sinusoidal_factor_get(const Eo *obj);

#endif
