/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.util.HashMap;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import sun.font.Font2D;
import sun.font.FontUtilities;

public class FontFamily {
    private static ConcurrentHashMap<String, FontFamily> familyNameMap = new ConcurrentHashMap();
    private static HashMap<String, FontFamily> allLocaleNames;
    protected String familyName;
    protected Font2D plain;
    protected Font2D bold;
    protected Font2D italic;
    protected Font2D bolditalic;
    protected boolean logicalFont = false;
    protected int familyRank;

    public static FontFamily getFamily(String name) {
        return familyNameMap.get(name.toLowerCase(Locale.ENGLISH));
    }

    public static String[] getAllFamilyNames() {
        return null;
    }

    static void remove(Font2D font2D) {
        String name = font2D.getFamilyName(Locale.ENGLISH);
        FontFamily family = FontFamily.getFamily(name);
        if (family == null) {
            return;
        }
        if (family.plain == font2D) {
            family.plain = null;
        }
        if (family.bold == font2D) {
            family.bold = null;
        }
        if (family.italic == font2D) {
            family.italic = null;
        }
        if (family.bolditalic == font2D) {
            family.bolditalic = null;
        }
        if (family.plain == null && family.bold == null && family.plain == null && family.bold == null) {
            familyNameMap.remove(name);
        }
    }

    public FontFamily(String name, boolean isLogFont, int rank) {
        this.logicalFont = isLogFont;
        this.familyName = name;
        this.familyRank = rank;
        familyNameMap.put(name.toLowerCase(Locale.ENGLISH), this);
    }

    FontFamily(String name) {
        this.logicalFont = false;
        this.familyName = name;
        this.familyRank = 4;
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public int getRank() {
        return this.familyRank;
    }

    public void setFont(Font2D font, int style) {
        if (font.getRank() > this.familyRank) {
            if (FontUtilities.isLogging()) {
                FontUtilities.getLogger().warning("Rejecting adding " + font + " of lower rank " + font.getRank() + " to family " + this + " of rank " + this.familyRank);
            }
            return;
        }
        switch (style) {
            case 0: {
                this.plain = font;
                break;
            }
            case 1: {
                this.bold = font;
                break;
            }
            case 2: {
                this.italic = font;
                break;
            }
            case 3: {
                this.bolditalic = font;
                break;
            }
        }
    }

    public Font2D getFontWithExactStyleMatch(int style) {
        switch (style) {
            case 0: {
                return this.plain;
            }
            case 1: {
                return this.bold;
            }
            case 2: {
                return this.italic;
            }
            case 3: {
                return this.bolditalic;
            }
        }
        return null;
    }

    public Font2D getFont(int style) {
        switch (style) {
            case 0: {
                return this.plain;
            }
            case 1: {
                if (this.bold != null) {
                    return this.bold;
                }
                if (this.plain != null && this.plain.canDoStyle(style)) {
                    return this.plain;
                }
                return null;
            }
            case 2: {
                if (this.italic != null) {
                    return this.italic;
                }
                if (this.plain != null && this.plain.canDoStyle(style)) {
                    return this.plain;
                }
                return null;
            }
            case 3: {
                if (this.bolditalic != null) {
                    return this.bolditalic;
                }
                if (this.italic != null && this.italic.canDoStyle(style)) {
                    return this.italic;
                }
                if (this.bold != null && this.bold.canDoStyle(style)) {
                    return this.italic;
                }
                if (this.plain != null && this.plain.canDoStyle(style)) {
                    return this.plain;
                }
                return null;
            }
        }
        return null;
    }

    Font2D getClosestStyle(int style) {
        switch (style) {
            case 0: {
                if (this.bold != null) {
                    return this.bold;
                }
                if (this.italic != null) {
                    return this.italic;
                }
                return this.bolditalic;
            }
            case 1: {
                if (this.plain != null) {
                    return this.plain;
                }
                if (this.bolditalic != null) {
                    return this.bolditalic;
                }
                return this.italic;
            }
            case 2: {
                if (this.bolditalic != null) {
                    return this.bolditalic;
                }
                if (this.plain != null) {
                    return this.plain;
                }
                return this.bold;
            }
            case 3: {
                if (this.italic != null) {
                    return this.italic;
                }
                if (this.bold != null) {
                    return this.bold;
                }
                return this.plain;
            }
        }
        return null;
    }

    static synchronized void addLocaleNames(FontFamily family, String[] names) {
        if (allLocaleNames == null) {
            allLocaleNames = new HashMap();
        }
        for (int i = 0; i < names.length; ++i) {
            allLocaleNames.put(names[i].toLowerCase(), family);
        }
    }

    public static synchronized FontFamily getLocaleFamily(String name) {
        if (allLocaleNames == null) {
            return null;
        }
        return allLocaleNames.get(name.toLowerCase());
    }

    public String toString() {
        return "Font family: " + this.familyName + " plain=" + this.plain + " bold=" + this.bold + " italic=" + this.italic + " bolditalic=" + this.bolditalic;
    }
}

