/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.InvalidationListener;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.control.ResizeFeaturesBase;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TreeTableColumn;

class TableUtil {
    private TableUtil() {
    }

    static void removeTableColumnListener(List<? extends TableColumnBase> list, InvalidationListener columnVisibleObserver, InvalidationListener columnSortableObserver, InvalidationListener columnSortTypeObserver, InvalidationListener columnComparatorObserver) {
        if (list == null) {
            return;
        }
        for (TableColumnBase tableColumnBase : list) {
            tableColumnBase.visibleProperty().removeListener(columnVisibleObserver);
            tableColumnBase.sortableProperty().removeListener(columnSortableObserver);
            tableColumnBase.comparatorProperty().removeListener(columnComparatorObserver);
            if (tableColumnBase instanceof TableColumn) {
                ((TableColumn)tableColumnBase).sortTypeProperty().removeListener(columnSortTypeObserver);
            } else if (tableColumnBase instanceof TreeTableColumn) {
                ((TreeTableColumn)tableColumnBase).sortTypeProperty().removeListener(columnSortTypeObserver);
            }
            TableUtil.removeTableColumnListener(tableColumnBase.getColumns(), columnVisibleObserver, columnSortableObserver, columnSortTypeObserver, columnComparatorObserver);
        }
    }

    static void addTableColumnListener(List<? extends TableColumnBase> list, InvalidationListener columnVisibleObserver, InvalidationListener columnSortableObserver, InvalidationListener columnSortTypeObserver, InvalidationListener columnComparatorObserver) {
        if (list == null) {
            return;
        }
        for (TableColumnBase tableColumnBase : list) {
            tableColumnBase.visibleProperty().addListener(columnVisibleObserver);
            tableColumnBase.sortableProperty().addListener(columnSortableObserver);
            tableColumnBase.comparatorProperty().addListener(columnComparatorObserver);
            if (tableColumnBase instanceof TableColumn) {
                ((TableColumn)tableColumnBase).sortTypeProperty().addListener(columnSortTypeObserver);
            } else if (tableColumnBase instanceof TreeTableColumn) {
                ((TreeTableColumn)tableColumnBase).sortTypeProperty().addListener(columnSortTypeObserver);
            }
            TableUtil.addTableColumnListener(tableColumnBase.getColumns(), columnVisibleObserver, columnSortableObserver, columnSortTypeObserver, columnComparatorObserver);
        }
    }

    static void removeColumnsListener(List<? extends TableColumnBase> list, ListChangeListener cl) {
        if (list == null) {
            return;
        }
        for (TableColumnBase tableColumnBase : list) {
            tableColumnBase.getColumns().removeListener(cl);
            TableUtil.removeColumnsListener(tableColumnBase.getColumns(), cl);
        }
    }

    static void addColumnsListener(List<? extends TableColumnBase> list, ListChangeListener cl) {
        if (list == null) {
            return;
        }
        for (TableColumnBase tableColumnBase : list) {
            tableColumnBase.getColumns().addListener(cl);
            TableUtil.addColumnsListener(tableColumnBase.getColumns(), cl);
        }
    }

    static void handleSortFailure(ObservableList<? extends TableColumnBase> sortOrder, SortEventType sortEventType, Object ... supportInfo) {
        if (sortEventType == SortEventType.COLUMN_SORT_TYPE_CHANGE) {
            TableColumnBase changedColumn = (TableColumnBase)supportInfo[0];
            TableUtil.revertSortType(changedColumn);
        } else if (sortEventType == SortEventType.SORT_ORDER_CHANGE) {
            ListChangeListener.Change change = (ListChangeListener.Change)supportInfo[0];
            ArrayList toRemove = new ArrayList();
            ArrayList toAdd = new ArrayList();
            while (change.next()) {
                if (change.wasAdded()) {
                    toRemove.addAll(change.getAddedSubList());
                }
                if (!change.wasRemoved()) continue;
                toAdd.addAll(change.getRemoved());
            }
            sortOrder.removeAll(toRemove);
            sortOrder.addAll(toAdd);
        } else if (sortEventType == SortEventType.COLUMN_SORTABLE_CHANGE || sortEventType == SortEventType.COLUMN_COMPARATOR_CHANGE) {
            // empty if block
        }
    }

    private static void revertSortType(TableColumnBase changedColumn) {
        if (changedColumn instanceof TableColumn) {
            TableColumn tableColumn = (TableColumn)changedColumn;
            TableColumn.SortType sortType = tableColumn.getSortType();
            if (sortType == TableColumn.SortType.ASCENDING) {
                tableColumn.setSortType(null);
            } else if (sortType == TableColumn.SortType.DESCENDING) {
                tableColumn.setSortType(TableColumn.SortType.ASCENDING);
            } else if (sortType == null) {
                tableColumn.setSortType(TableColumn.SortType.DESCENDING);
            }
        } else if (changedColumn instanceof TreeTableColumn) {
            TreeTableColumn tableColumn = (TreeTableColumn)changedColumn;
            TreeTableColumn.SortType sortType = tableColumn.getSortType();
            if (sortType == TreeTableColumn.SortType.ASCENDING) {
                tableColumn.setSortType(null);
            } else if (sortType == TreeTableColumn.SortType.DESCENDING) {
                tableColumn.setSortType(TreeTableColumn.SortType.ASCENDING);
            } else if (sortType == null) {
                tableColumn.setSortType(TreeTableColumn.SortType.DESCENDING);
            }
        }
    }

    static boolean constrainedResize(ResizeFeaturesBase prop, boolean isFirstRun, double tableWidth, List<? extends TableColumnBase<?, ?>> visibleLeafColumns) {
        boolean isShrinking;
        TableColumnBase<?, ?> column = prop.getColumn();
        double delta = prop.getDelta();
        double totalLowerBound = 0.0;
        double totalUpperBound = 0.0;
        if (tableWidth == 0.0) {
            return false;
        }
        double colWidth = 0.0;
        for (TableColumnBase<?, ?> col : visibleLeafColumns) {
            colWidth += col.getWidth();
        }
        if (Math.abs(colWidth - tableWidth) > 1.0) {
            isShrinking = colWidth > tableWidth;
            double target = tableWidth;
            if (isFirstRun) {
                for (TableColumnBase<?, ?> col : visibleLeafColumns) {
                    totalLowerBound += col.getMinWidth();
                    totalUpperBound += col.getMaxWidth();
                }
                totalUpperBound = totalUpperBound == Double.POSITIVE_INFINITY ? Double.MAX_VALUE : (totalUpperBound == Double.NEGATIVE_INFINITY ? Double.MIN_VALUE : totalUpperBound);
                for (TableColumnBase<?, ?> col : visibleLeafColumns) {
                    double newSize;
                    double lowerBound = col.getMinWidth();
                    double upperBound = col.getMaxWidth();
                    if (Math.abs(totalLowerBound - totalUpperBound) < 1.0E-7) {
                        newSize = lowerBound;
                    } else {
                        double f = (target - totalLowerBound) / (totalUpperBound - totalLowerBound);
                        newSize = Math.round(lowerBound + f * (upperBound - lowerBound));
                    }
                    double remainder = TableUtil.resize(col, newSize - col.getWidth());
                    target -= newSize + remainder;
                    totalLowerBound -= lowerBound;
                    totalUpperBound -= upperBound;
                }
                isFirstRun = false;
            } else {
                double actualDelta = tableWidth - colWidth;
                List<TableColumnBase<?, ?>> cols = visibleLeafColumns;
                TableUtil.resizeColumns(cols, actualDelta);
            }
        }
        if (column == null) {
            return false;
        }
        isShrinking = delta < 0.0;
        TableColumnBase<?, ?> leafColumn = column;
        while (leafColumn.getColumns().size() > 0) {
            leafColumn = (TableColumnBase<?, ?>)leafColumn.getColumns().get(leafColumn.getColumns().size() - 1);
        }
        int colPos = visibleLeafColumns.indexOf(leafColumn);
        int endColPos = visibleLeafColumns.size() - 1;
        double remainingDelta = delta;
        while (endColPos > colPos && remainingDelta != 0.0) {
            TableColumnBase<?, ?> growingCol;
            TableColumnBase<?, ?> resizingCol = visibleLeafColumns.get(endColPos);
            --endColPos;
            if (!resizingCol.isResizable()) continue;
            TableColumnBase<?, ?> shrinkingCol = isShrinking ? leafColumn : resizingCol;
            TableColumnBase<?, ?> tableColumnBase = growingCol = !isShrinking ? leafColumn : resizingCol;
            if (growingCol.getWidth() > growingCol.getPrefWidth()) {
                List<TableColumnBase<?, ?>> seq = visibleLeafColumns.subList(colPos + 1, endColPos + 1);
                for (int i = seq.size() - 1; i >= 0; --i) {
                    TableColumnBase<?, ?> c = seq.get(i);
                    if (!(c.getWidth() < c.getPrefWidth())) continue;
                    growingCol = c;
                    break;
                }
            }
            double sdiff = Math.min(Math.abs(remainingDelta), shrinkingCol.getWidth() - shrinkingCol.getMinWidth());
            double delta1 = TableUtil.resize(shrinkingCol, -sdiff);
            double delta2 = TableUtil.resize(growingCol, sdiff);
            remainingDelta += isShrinking ? sdiff : -sdiff;
        }
        return remainingDelta == 0.0;
    }

    static double resize(TableColumnBase column, double delta) {
        if (delta == 0.0) {
            return 0.0;
        }
        if (!column.isResizable()) {
            return delta;
        }
        boolean isShrinking = delta < 0.0;
        List<TableColumnBase<?, ?>> resizingChildren = TableUtil.getResizableChildren(column, isShrinking);
        if (resizingChildren.size() > 0) {
            return TableUtil.resizeColumns(resizingChildren, delta);
        }
        double newWidth = column.getWidth() + delta;
        if (newWidth > column.getMaxWidth()) {
            column.impl_setWidth(column.getMaxWidth());
            return newWidth - column.getMaxWidth();
        }
        if (newWidth < column.getMinWidth()) {
            column.impl_setWidth(column.getMinWidth());
            return newWidth - column.getMinWidth();
        }
        column.impl_setWidth(newWidth);
        return 0.0;
    }

    private static List<TableColumnBase<?, ?>> getResizableChildren(TableColumnBase<?, ?> column, boolean isShrinking) {
        if (column == null || column.getColumns().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList tablecolumns = new ArrayList();
        for (TableColumnBase tableColumnBase : column.getColumns()) {
            if (!tableColumnBase.isVisible() || !tableColumnBase.isResizable()) continue;
            if (isShrinking && tableColumnBase.getWidth() > tableColumnBase.getMinWidth()) {
                tablecolumns.add(tableColumnBase);
                continue;
            }
            if (isShrinking || !(tableColumnBase.getWidth() < tableColumnBase.getMaxWidth())) continue;
            tablecolumns.add(tableColumnBase);
        }
        return tablecolumns;
    }

    private static double resizeColumns(List<? extends TableColumnBase<?, ?>> columns, double delta) {
        int columnCount = columns.size();
        double colDelta = delta / (double)columnCount;
        double remainingDelta = delta;
        int col = 0;
        boolean isClean = true;
        for (TableColumnBase<?, ?> childCol : columns) {
            ++col;
            double leftOverDelta = TableUtil.resize(childCol, colDelta);
            remainingDelta = remainingDelta - colDelta + leftOverDelta;
            if (leftOverDelta == 0.0) continue;
            isClean = false;
            colDelta = remainingDelta / (double)(columnCount - col);
        }
        return isClean ? 0.0 : remainingDelta;
    }

    static enum SortEventType {
        SORT_ORDER_CHANGE,
        COLUMN_SORT_TYPE_CHANGE,
        COLUMN_SORTABLE_CHANGE,
        COLUMN_COMPARATOR_CHANGE;

    }
}

