/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webkit.network;

import com.sun.webkit.network.Cookie;
import com.sun.webkit.network.CookieStore;
import com.sun.webkit.network.ExtendedTime;
import com.sun.webkit.network.PublicSuffixes;
import java.net.CookieHandler;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class CookieManager
extends CookieHandler {
    private static final Logger logger = Logger.getLogger(CookieManager.class.getName());
    private final CookieStore store = new CookieStore();

    @Override
    public Map<String, List<String>> get(URI uri, Map<String, List<String>> requestHeaders) {
        Map<String, List<String>> result;
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "uri: [{0}], requestHeaders: {1}", new Object[]{uri, CookieManager.toLogString(requestHeaders)});
        }
        if (uri == null) {
            throw new IllegalArgumentException("uri is null");
        }
        if (requestHeaders == null) {
            throw new IllegalArgumentException("requestHeaders is null");
        }
        String cookieString = this.get(uri);
        if (cookieString != null) {
            result = new HashMap();
            result.put("Cookie", Arrays.asList(cookieString));
        } else {
            result = Collections.emptyMap();
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "result: {0}", CookieManager.toLogString(result));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String get(URI uri) {
        List<Cookie> cookieList;
        String host = uri.getHost();
        if (host == null || host.length() == 0) {
            logger.log(Level.FINEST, "Null or empty URI host, returning null");
            return null;
        }
        host = CookieManager.canonicalize(host);
        String scheme = uri.getScheme();
        boolean secureProtocol = "https".equalsIgnoreCase(scheme) || "javascripts".equalsIgnoreCase(scheme);
        boolean httpApi = "http".equalsIgnoreCase(scheme) || "https".equalsIgnoreCase(scheme);
        CookieStore cookieStore = this.store;
        synchronized (cookieStore) {
            cookieList = this.store.get(host, uri.getPath(), secureProtocol, httpApi);
        }
        StringBuilder sb = new StringBuilder();
        for (Cookie cookie : cookieList) {
            if (sb.length() > 0) {
                sb.append("; ");
            }
            sb.append(cookie.getName());
            sb.append('=');
            sb.append(cookie.getValue());
        }
        return sb.length() > 0 ? sb.toString() : null;
    }

    @Override
    public void put(URI uri, Map<String, List<String>> responseHeaders) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "uri: [{0}], responseHeaders: {1}", new Object[]{uri, CookieManager.toLogString(responseHeaders)});
        }
        if (uri == null) {
            throw new IllegalArgumentException("uri is null");
        }
        if (responseHeaders == null) {
            throw new IllegalArgumentException("responseHeaders is null");
        }
        for (Map.Entry<String, List<String>> entry : responseHeaders.entrySet()) {
            String key = entry.getKey();
            if (!"Set-Cookie".equalsIgnoreCase(key)) continue;
            ExtendedTime currentTime = ExtendedTime.currentTime();
            ListIterator<String> it = entry.getValue().listIterator(entry.getValue().size());
            while (it.hasPrevious()) {
                Cookie cookie = Cookie.parse(it.previous(), currentTime);
                if (cookie == null) continue;
                this.put(uri, cookie);
                currentTime = currentTime.incrementSubtime();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void put(URI uri, Cookie cookie) {
        boolean httpApi;
        logger.log(Level.FINEST, "cookie: {0}", cookie);
        String host = uri.getHost();
        if (host == null || host.length() == 0) {
            logger.log(Level.FINEST, "Null or empty URI host, ignoring cookie");
            return;
        }
        host = CookieManager.canonicalize(host);
        if (PublicSuffixes.isPublicSuffix(cookie.getDomain())) {
            if (cookie.getDomain().equals(host)) {
                cookie.setDomain("");
            } else {
                logger.log(Level.FINEST, "Domain is public suffix, ignoring cookie");
                return;
            }
        }
        if (cookie.getDomain().length() > 0) {
            if (!Cookie.domainMatches(host, cookie.getDomain())) {
                logger.log(Level.FINEST, "Hostname does not match domain, ignoring cookie");
                return;
            }
            cookie.setHostOnly(false);
        } else {
            cookie.setHostOnly(true);
            cookie.setDomain(host);
        }
        if (cookie.getPath() == null) {
            cookie.setPath(Cookie.defaultPath(uri));
        }
        boolean bl = httpApi = "http".equalsIgnoreCase(uri.getScheme()) || "https".equalsIgnoreCase(uri.getScheme());
        if (cookie.getHttpOnly() && !httpApi) {
            logger.log(Level.FINEST, "HttpOnly cookie received from non-HTTP API, ignoring cookie");
            return;
        }
        CookieStore cookieStore = this.store;
        synchronized (cookieStore) {
            Cookie oldCookie = this.store.get(cookie);
            if (oldCookie != null) {
                if (oldCookie.getHttpOnly() && !httpApi) {
                    logger.log(Level.FINEST, "Non-HTTP API attempts to overwrite HttpOnly cookie, blocked");
                    return;
                }
                cookie.setCreationTime(oldCookie.getCreationTime());
            }
            this.store.put(cookie);
        }
        logger.log(Level.FINEST, "Stored: {0}", cookie);
    }

    private static String toLogString(Map<String, List<String>> headers) {
        if (headers == null) {
            return null;
        }
        if (headers.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            String key = entry.getKey();
            for (String value : entry.getValue()) {
                sb.append(String.format("%n    ", new Object[0]));
                sb.append(key);
                sb.append(": ");
                sb.append(value);
            }
        }
        return sb.toString();
    }

    private static String canonicalize(String hostname) {
        return hostname.toLowerCase();
    }
}

