/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.webkit.drt;

import com.sun.javafx.webkit.KeyCodeMap;
import com.sun.webkit.WebPage;
import com.sun.webkit.event.WCKeyEvent;
import com.sun.webkit.event.WCMouseEvent;
import com.sun.webkit.event.WCMouseWheelEvent;
import java.util.HashMap;
import java.util.Map;
import javafx.scene.input.KeyCode;

final class EventSender {
    private static final int ALT = 1;
    private static final int CTRL = 2;
    private static final int META = 4;
    private static final int SHIFT = 8;
    private static final int PRESSED = 16;
    private static final float ZOOM = 1.2f;
    private static final float SCROLL = 40.0f;
    private static final Map<Object, KeyCode> MAP = new HashMap<Object, KeyCode>();
    private final WebPage webPage;
    private boolean dragMode = true;
    private int mousePositionX;
    private int mousePositionY;
    private boolean mousePressed;
    private int mouseButton = 0;
    private long timeOffset;
    private int modifiers;

    EventSender(WebPage webPage) {
        this.webPage = webPage;
    }

    private void keyDown(String key, int modifiers) {
        String keyChar = null;
        KeyCode code = MAP.get(key);
        if (1 == key.length()) {
            if (code == null) {
                code = MAP.get(Character.toUpperCase(key.charAt(0)));
            }
            keyChar = key;
        }
        if (code == null) {
            System.err.println("unexpected key = " + key);
        } else {
            KeyCodeMap.Entry keyCodeEntry = KeyCodeMap.lookup(code);
            String keyIdentifier = keyCodeEntry.getKeyIdentifier();
            int windowsVirtualKeyCode = keyCodeEntry.getWindowsVirtualKeyCode();
            this.dispatchKeyEvent(1, null, keyIdentifier, windowsVirtualKeyCode, modifiers);
            this.dispatchKeyEvent(0, keyChar, null, 0, modifiers);
            this.dispatchKeyEvent(2, null, keyIdentifier, windowsVirtualKeyCode, modifiers);
        }
    }

    private void mouseUpDown(int button, int modifiers) {
        this.mouseButton = button;
        this.mousePressed = EventSender.isSet(modifiers, 16);
        this.dispatchMouseEvent(this.mousePressed ? 0 : 1, button, 1, modifiers);
    }

    private void mouseMoveTo(int x, int y) {
        this.mousePositionX = x;
        this.mousePositionY = y;
        this.dispatchMouseEvent(this.mousePressed ? 3 : 2, this.mousePressed ? this.mouseButton : 0, 0, 0);
    }

    private void mouseScroll(float x, float y, boolean continuous) {
        if (continuous) {
            x /= 40.0f;
            y /= 40.0f;
        }
        this.webPage.dispatchMouseWheelEvent(new WCMouseWheelEvent(this.mousePositionX, this.mousePositionY, this.mousePositionX, this.mousePositionY, this.getEventTime(), false, false, false, false, x, y));
    }

    private void leapForward(int timeOffset) {
        this.timeOffset += (long)timeOffset;
    }

    private void contextClick() {
        this.dispatchMouseEvent(0, 2, 1, 0);
        this.dispatchMouseEvent(1, 2, 1, 0);
    }

    private void scheduleAsynchronousClick() {
        this.dispatchMouseEvent(0, 1, 1, 0);
        this.dispatchMouseEvent(1, 1, 1, 0);
    }

    private void touchStart() {
        throw new UnsupportedOperationException("touchStart");
    }

    private void touchCancel() {
        throw new UnsupportedOperationException("touchCancel");
    }

    private void touchMove() {
        throw new UnsupportedOperationException("touchMove");
    }

    private void touchEnd() {
        throw new UnsupportedOperationException("touchEnd");
    }

    private void addTouchPoint(int x, int y) {
        throw new UnsupportedOperationException("addTouchPoint");
    }

    private void updateTouchPoint(int i, int x, int y) {
        throw new UnsupportedOperationException("updateTouchPoint");
    }

    private void cancelTouchPoint(int i) {
        throw new UnsupportedOperationException("cancelTouchPoint");
    }

    private void releaseTouchPoint(int i) {
        throw new UnsupportedOperationException("releaseTouchPoint");
    }

    private void clearTouchPoints() {
        throw new UnsupportedOperationException("clearTouchPoints");
    }

    private void setTouchModifier(int modifier, boolean set) {
        this.modifiers = set ? this.modifiers | modifier : this.modifiers & ~modifier;
    }

    private void scalePageBy(float scale, int x, int y) {
        throw new UnsupportedOperationException("scalePageBy(" + scale + "); x=" + x + "; y=" + y);
    }

    private void zoom(boolean in, boolean textOnly) {
        float factor = this.webPage.getZoomFactor(textOnly);
        this.webPage.setZoomFactor(in ? factor * 1.2f : factor / 1.2f, textOnly);
    }

    private void beginDragWithFiles(String[] names) {
        StringBuilder sb = new StringBuilder("beginDragWithFiles");
        for (String name : names) {
            sb.append(", ").append(name);
        }
        throw new UnsupportedOperationException(sb.append('.').toString());
    }

    private boolean getDragMode() {
        return this.dragMode;
    }

    private void setDragMode(boolean mode) {
        this.dragMode = mode;
    }

    private long getEventTime() {
        return this.timeOffset + System.currentTimeMillis();
    }

    private void dispatchKeyEvent(int type, String text, String keyIdentifier, int windowsVirtualKeyCode, int modifiers) {
        this.webPage.dispatchKeyEvent(new WCKeyEvent(type, text, keyIdentifier, windowsVirtualKeyCode, EventSender.isSet(modifiers, 8), EventSender.isSet(modifiers, 2), EventSender.isSet(modifiers, 1), EventSender.isSet(modifiers, 4), this.getEventTime()));
    }

    private void dispatchMouseEvent(int type, int button, int clicks, int modifiers) {
        this.webPage.dispatchMouseEvent(new WCMouseEvent(type, button, clicks, this.mousePositionX, this.mousePositionY, this.mousePositionX, this.mousePositionY, this.getEventTime(), EventSender.isSet(modifiers, 8), EventSender.isSet(modifiers, 2), EventSender.isSet(modifiers, 1), EventSender.isSet(modifiers, 4), false));
    }

    private static boolean isSet(int modifiers, int modifier) {
        return modifier == (modifier & modifiers);
    }

    static {
        MAP.put("\r", KeyCode.ENTER);
        MAP.put("pageUp", KeyCode.PAGE_UP);
        MAP.put("pageDown", KeyCode.PAGE_DOWN);
        MAP.put("leftArrow", KeyCode.LEFT);
        MAP.put("upArrow", KeyCode.UP);
        MAP.put("rightArrow", KeyCode.RIGHT);
        MAP.put("downArrow", KeyCode.DOWN);
        MAP.put("printScreen", KeyCode.PRINTSCREEN);
        MAP.put("menu", KeyCode.CONTEXT_MENU);
        for (KeyCode code : KeyCode.values()) {
            MAP.put(code.impl_getCode(), code);
            MAP.put(code.getName().toLowerCase(), code);
            MAP.put(code.getName(), code);
        }
    }
}

