/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import com.sun.glass.ui.monocle.KeyInput;
import com.sun.glass.ui.monocle.KeyState;
import com.sun.glass.ui.monocle.LinuxEventBuffer;
import com.sun.glass.ui.monocle.LinuxInputDevice;
import com.sun.glass.ui.monocle.LinuxInputProcessor;

class LinuxKeyProcessor
implements LinuxInputProcessor {
    private KeyInput key = KeyInput.getInstance();
    private KeyState state = new KeyState();

    LinuxKeyProcessor() {
    }

    @Override
    public void processEvents(LinuxInputDevice device) {
        LinuxEventBuffer buffer = device.getBuffer();
        this.key.getState(this.state);
        while (buffer.hasNextEvent()) {
            block0 : switch (buffer.getEventType()) {
                case 1: {
                    int vk = LinuxKeyProcessor.getVirtualKeyCode(buffer.getEventCode());
                    if (vk == 0) break;
                    if (buffer.getEventValue() == 0) {
                        this.state.releaseKey(vk);
                        break;
                    }
                    this.state.pressKey(vk);
                    break;
                }
                case 0: {
                    switch (buffer.getEventCode()) {
                        case 0: {
                            this.key.setState(this.state);
                            break block0;
                        }
                    }
                    break;
                }
            }
            buffer.nextEvent();
        }
    }

    static int getVirtualKeyCode(int linuxKeyCode) {
        if (linuxKeyCode >= 2 && linuxKeyCode <= 10) {
            return linuxKeyCode - 2 + 49;
        }
        if (linuxKeyCode >= 512 && linuxKeyCode <= 521) {
            return linuxKeyCode - 512 + 48;
        }
        if (linuxKeyCode >= 59 && linuxKeyCode <= 68) {
            return linuxKeyCode - 59 + 112;
        }
        if (linuxKeyCode >= 87 && linuxKeyCode <= 88) {
            return linuxKeyCode - 87 + 122;
        }
        if (linuxKeyCode >= 183 && linuxKeyCode <= 194) {
            return linuxKeyCode - 183 + 61440;
        }
        switch (linuxKeyCode) {
            case 11: {
                return 48;
            }
            case 30: {
                return 65;
            }
            case 48: {
                return 66;
            }
            case 46: {
                return 67;
            }
            case 32: {
                return 68;
            }
            case 18: {
                return 69;
            }
            case 33: {
                return 70;
            }
            case 34: {
                return 71;
            }
            case 35: {
                return 72;
            }
            case 23: {
                return 73;
            }
            case 36: {
                return 74;
            }
            case 37: {
                return 75;
            }
            case 38: {
                return 76;
            }
            case 50: {
                return 77;
            }
            case 49: {
                return 78;
            }
            case 24: {
                return 79;
            }
            case 25: {
                return 80;
            }
            case 16: {
                return 81;
            }
            case 19: {
                return 82;
            }
            case 31: {
                return 83;
            }
            case 20: {
                return 84;
            }
            case 22: {
                return 85;
            }
            case 47: {
                return 86;
            }
            case 17: {
                return 87;
            }
            case 45: {
                return 88;
            }
            case 21: {
                return 89;
            }
            case 44: {
                return 90;
            }
            case 29: 
            case 97: {
                return 17;
            }
            case 42: 
            case 54: {
                return 16;
            }
            case 58: {
                return 20;
            }
            case 15: {
                return 9;
            }
            case 41: {
                return 192;
            }
            case 12: {
                return 45;
            }
            case 13: {
                return 61;
            }
            case 14: {
                return 8;
            }
            case 26: {
                return 161;
            }
            case 27: {
                return 162;
            }
            case 43: {
                return 92;
            }
            case 39: {
                return 59;
            }
            case 40: {
                return 222;
            }
            case 51: {
                return 44;
            }
            case 52: {
                return 46;
            }
            case 53: {
                return 47;
            }
            case 56: 
            case 100: {
                return 18;
            }
            case 125: 
            case 126: {
                return 768;
            }
            case 57: {
                return 32;
            }
            case 139: {
                return 525;
            }
            case 28: {
                return 10;
            }
            case 105: {
                return 37;
            }
            case 106: {
                return 39;
            }
            case 103: {
                return 38;
            }
            case 108: {
                return 40;
            }
            case 102: {
                return 36;
            }
            case 111: {
                return 127;
            }
            case 110: {
                return 155;
            }
            case 107: {
                return 35;
            }
            case 109: {
                return 34;
            }
            case 104: {
                return 33;
            }
            case 69: {
                return 144;
            }
            case 1: {
                return 27;
            }
            case 522: {
                return 106;
            }
        }
        return 0;
    }
}

