/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.mail.Address;
import javax.mail.Session;
import javax.mail.internet.AddressException;
import javax.mail.internet.MimeUtility;

public class InternetAddress
extends Address
implements Cloneable {
    private static final String RFC822 = "rfc822";
    protected String address;
    protected String personal;
    protected String encodedPersonal;
    private static final int NONE = 0;
    private static final int LAX = 1;
    private static final int STRICT = 2;
    private static final int STRICT_OR_LAX = 3;
    private static final String needsQuoting = "()<>@,;:\\\".[]";

    public InternetAddress() {
    }

    public InternetAddress(String address) throws AddressException {
        this(address, false);
    }

    public InternetAddress(String address, boolean strict) throws AddressException {
        InternetAddress[] addresses = InternetAddress.parseHeader(address, strict);
        if (addresses.length != 1) {
            throw new AddressException("Illegal address", address);
        }
        this.address = addresses[0].address;
        this.personal = addresses[0].personal;
        this.encodedPersonal = addresses[0].encodedPersonal;
        if (strict) {
            InternetAddress.validate(address, true, true);
        }
    }

    public InternetAddress(String address, String personal) throws UnsupportedEncodingException {
        this(address, personal, null);
    }

    public InternetAddress(String address, String personal, String charset) throws UnsupportedEncodingException {
        this.address = address;
        this.setPersonal(personal, charset);
    }

    public Object clone() {
        InternetAddress clone = new InternetAddress();
        clone.address = this.address;
        clone.personal = this.personal;
        clone.encodedPersonal = this.encodedPersonal;
        return clone;
    }

    @Override
    public String getType() {
        return RFC822;
    }

    public boolean isGroup() {
        int start = this.address.indexOf(58);
        if (start == -1) {
            return false;
        }
        int end = this.address.length() - 1;
        return this.address.charAt(end) == ';';
    }

    public InternetAddress[] getGroup(boolean strict) throws AddressException {
        int start = this.address.indexOf(58);
        int end = this.address.length() - 1;
        if (start == -1 || this.address.charAt(end) == ';') {
            return null;
        }
        return InternetAddress.parseHeader(this.address.substring(start + 1, end), strict);
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setPersonal(String name, String charset) throws UnsupportedEncodingException {
        this.personal = name;
        this.encodedPersonal = name != null ? (charset == null ? MimeUtility.encodeWord(name) : MimeUtility.encodeWord(name, charset, null)) : null;
    }

    public void setPersonal(String name) throws UnsupportedEncodingException {
        this.setPersonal(name, null);
    }

    public String getAddress() {
        return this.address;
    }

    public String getPersonal() {
        if (this.personal != null) {
            return this.personal;
        }
        if (this.encodedPersonal != null) {
            try {
                this.personal = MimeUtility.decodeText(this.encodedPersonal);
                return this.personal;
            }
            catch (Exception e) {
                return this.encodedPersonal;
            }
        }
        return null;
    }

    public void validate() throws AddressException {
        InternetAddress.validate(this.address, true, true);
    }

    @Override
    public String toString() {
        if (this.encodedPersonal == null && this.personal != null) {
            try {
                this.encodedPersonal = MimeUtility.encodeWord(this.personal);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        StringBuffer buffer = new StringBuffer();
        if (this.encodedPersonal != null) {
            buffer.append(InternetAddress.quote(this.encodedPersonal));
            buffer.append(' ');
            buffer.append('<');
            buffer.append(this.address);
            buffer.append('>');
        } else if (InternetAddress.isGroupAddress(this.address) || InternetAddress.isSimpleAddress(this.address)) {
            buffer.append(this.address);
        } else {
            buffer.append('<');
            buffer.append(this.address);
            buffer.append('>');
        }
        return buffer.toString();
    }

    public String toUnicodeString() {
        StringBuffer buffer = new StringBuffer();
        if (this.getPersonal() != null) {
            buffer.append(InternetAddress.quote(this.personal));
            buffer.append(' ');
            buffer.append('<');
            buffer.append(this.address);
            buffer.append('>');
        } else if (InternetAddress.isGroupAddress(this.address) || InternetAddress.isSimpleAddress(this.address)) {
            buffer.append(this.address);
        } else {
            buffer.append('<');
            buffer.append(this.address);
            buffer.append('>');
        }
        return buffer.toString();
    }

    private static boolean isSimpleAddress(String address) {
        return address.indexOf(34) == -1 && address.indexOf(40) == -1 && address.indexOf(41) == -1 && address.indexOf(44) == -1 && address.indexOf(58) == -1 && address.indexOf(59) == -1 && address.indexOf(60) == -1 && address.indexOf(62) == -1 && address.indexOf(91) == -1 && address.indexOf(92) == -1 && address.indexOf(93) == -1;
    }

    private static boolean isGroupAddress(String address) {
        int len = address.length();
        return len > 0 && address.indexOf(58) > 0 && address.charAt(len - 1) == ';';
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof InternetAddress) {
            String otherAddress = ((InternetAddress)other).getAddress();
            return this == other || this.address != null && this.address.equalsIgnoreCase(otherAddress);
        }
        return false;
    }

    public int hashCode() {
        return this.address == null ? 0 : this.address.hashCode();
    }

    public static String toString(Address[] addresses) {
        return InternetAddress.toString(addresses, 0);
    }

    public static String toString(Address[] addresses, int used) {
        if (addresses == null || addresses.length == 0) {
            return null;
        }
        String crlf = "\r\n";
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < addresses.length; ++i) {
            if (i != 0) {
                buffer.append(", ");
                used += 2;
            }
            String addressText = addresses[i].toString();
            int len = addressText.length();
            int fl = addressText.indexOf(crlf);
            if (fl < 0) {
                fl = addressText.length();
            }
            int ll = addressText.lastIndexOf(crlf);
            if (used + fl > 76) {
                buffer.append("\r\n\t");
                used = 8;
            }
            buffer.append(addressText);
            used = ll > -1 ? used + len : len - ll - 2;
        }
        return buffer.toString();
    }

    public static InternetAddress getLocalAddress(Session session) {
        String username = null;
        String hostname = null;
        String address = null;
        try {
            if (session == null) {
                username = System.getProperty("user.name");
                hostname = InetAddress.getLocalHost().getHostName();
            } else {
                address = session.getProperty("mail.from");
                if (address == null) {
                    InetAddress localhost;
                    username = session.getProperty("mail.user");
                    if (username == null) {
                        username = session.getProperty("user.name");
                    }
                    if (username == null) {
                        username = System.getProperty("user.name");
                    }
                    if ((hostname = session.getProperty("mail.host")) == null && (localhost = InetAddress.getLocalHost()) != null) {
                        hostname = localhost.getCanonicalHostName();
                    }
                }
            }
            if (address == null && username != null && hostname != null) {
                StringBuffer buffer = new StringBuffer();
                buffer.append(username);
                buffer.append('@');
                buffer.append(hostname);
                address = buffer.toString();
            }
            if (address != null) {
                return new InternetAddress(address);
            }
        }
        catch (AddressException addressException) {
        }
        catch (SecurityException securityException) {
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return null;
    }

    public static InternetAddress[] parse(String addresslist) throws AddressException {
        return InternetAddress.parse(addresslist, true);
    }

    public static InternetAddress[] parse(String addresslist, boolean strict) throws AddressException {
        return InternetAddress.parse(addresslist, strict ? 2 : 0);
    }

    public static InternetAddress[] parseHeader(String addresslist, boolean strict) throws AddressException {
        return InternetAddress.parse(addresslist, strict ? 3 : 1);
    }

    private static InternetAddress[] parse(String addresslist, int rules) throws AddressException {
        int pos;
        boolean inGroup = false;
        boolean gotDelimiter = false;
        boolean inAddress = false;
        int len = addresslist.length();
        int pEnd = -1;
        int pStart = -1;
        int start = -1;
        int end = -1;
        ArrayList<InternetAddress> acc = new ArrayList<InternetAddress>();
        block30: for (pos = 0; pos < len; ++pos) {
            char c = addresslist.charAt(pos);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block30;
                }
                case '<': {
                    inAddress = true;
                    if (gotDelimiter) {
                        throw new AddressException("Too many route-addr", addresslist, pos);
                    }
                    if (!inGroup) {
                        start = pStart;
                        if (start >= 0) {
                            end = pos;
                        }
                        pStart = pos + 1;
                    }
                    ++pos;
                    boolean inQuote = false;
                    boolean gotKet = false;
                    while (pos < len && !gotKet) {
                        char c2 = addresslist.charAt(pos);
                        switch (c2) {
                            case '\"': {
                                inQuote = !inQuote;
                                break;
                            }
                            case '>': {
                                if (inQuote) break;
                                gotKet = true;
                                --pos;
                                break;
                            }
                            case '\\': {
                                ++pos;
                            }
                        }
                        ++pos;
                    }
                    if (!gotKet && pos >= len) {
                        if (inQuote) {
                            throw new AddressException("Unmatched '\"'", addresslist, pos);
                        }
                        throw new AddressException("Unmatched '<'", addresslist, pos);
                    }
                    gotDelimiter = true;
                    pEnd = pos;
                    continue block30;
                }
                case '>': {
                    throw new AddressException("Unmatched '>'", addresslist, pos);
                }
                case '(': {
                    inAddress = true;
                    if (pStart >= 0 && pEnd == -1) {
                        pEnd = pos;
                    }
                    if (start == -1) {
                        start = pos + 1;
                    }
                    ++pos;
                    int parenCount = 1;
                    while (pos < len && parenCount > 0) {
                        c = addresslist.charAt(pos);
                        switch (c) {
                            case '(': {
                                ++parenCount;
                                break;
                            }
                            case ')': {
                                --parenCount;
                                break;
                            }
                            case '\\': {
                                ++pos;
                            }
                        }
                        ++pos;
                    }
                    if (parenCount > 0) {
                        throw new AddressException("Unmatched '('", addresslist, pos);
                    }
                    --pos;
                    if (end != -1) continue block30;
                    end = pos;
                    continue block30;
                }
                case ')': {
                    throw new AddressException("Unmatched ')'", addresslist, pos);
                }
                case '\"': {
                    inAddress = true;
                    if (pStart == -1) {
                        pStart = pos;
                    }
                    ++pos;
                    boolean gotQuote = false;
                    while (pos < len && !gotQuote) {
                        c = addresslist.charAt(pos);
                        switch (c) {
                            case '\"': {
                                gotQuote = true;
                                --pos;
                                break;
                            }
                            case '\\': {
                                ++pos;
                            }
                        }
                        ++pos;
                    }
                    if (pos < len) continue block30;
                    throw new AddressException("Unmatched '\"'", addresslist, pos);
                }
                case '[': {
                    inAddress = true;
                    ++pos;
                    boolean gotBracket = false;
                    while (pos < len && !gotBracket) {
                        c = addresslist.charAt(pos);
                        switch (c) {
                            case ']': {
                                gotBracket = true;
                                --pos;
                                break;
                            }
                            case '\\': {
                                ++pos;
                            }
                        }
                        ++pos;
                    }
                    if (pos < len) continue block30;
                    throw new AddressException("Unmatched '['", addresslist, pos);
                }
                case ',': {
                    InternetAddress address;
                    if (pStart == -1) {
                        gotDelimiter = false;
                        inAddress = false;
                        pEnd = -1;
                        continue block30;
                    }
                    if (inGroup) continue block30;
                    if (pEnd == -1) {
                        pEnd = pos;
                    }
                    String addressText = addresslist.substring(pStart, pEnd);
                    addressText = addressText.trim();
                    if (inAddress || (rules | 3) != 0) {
                        if ((rules & 2) != 0 || (rules & 1) == 0) {
                            InternetAddress.validate(addressText, gotDelimiter, false);
                        }
                        address = new InternetAddress();
                        address.setAddress(addressText);
                        if (start >= 0) {
                            String personal = addresslist.substring(start, end);
                            personal = personal.trim();
                            address.encodedPersonal = InternetAddress.unquote(personal);
                            end = -1;
                            start = -1;
                        }
                        acc.add(address);
                    } else {
                        StringTokenizer st = new StringTokenizer(addressText);
                        while (st.hasMoreTokens()) {
                            addressText = st.nextToken();
                            InternetAddress.validate(addressText, false, false);
                            InternetAddress address2 = new InternetAddress();
                            address2.setAddress(addressText);
                            acc.add(address2);
                        }
                    }
                    gotDelimiter = false;
                    inAddress = false;
                    pStart = -1;
                    pEnd = -1;
                    continue block30;
                }
                case ':': {
                    inAddress = true;
                    if (inGroup) {
                        throw new AddressException("Cannot have nested group", addresslist, pos);
                    }
                    inGroup = true;
                    continue block30;
                }
                case ';': {
                    if (!inGroup) {
                        throw new AddressException("Unexpected ';'", addresslist, pos);
                    }
                    inGroup = false;
                    pEnd = pos + 1;
                    String addressText = addresslist.substring(pStart, pEnd);
                    addressText = addressText.trim();
                    InternetAddress address = new InternetAddress();
                    address.setAddress(addressText);
                    acc.add(address);
                    gotDelimiter = false;
                    pEnd = -1;
                    pStart = -1;
                    continue block30;
                }
                default: {
                    if (pStart != -1) continue block30;
                    pStart = pos;
                }
            }
        }
        if (pStart > -1) {
            if (pEnd == -1) {
                pEnd = pos;
            }
            String addressText = addresslist.substring(pStart, pEnd);
            addressText = addressText.trim();
            if (inAddress || (rules | 3) != 0) {
                if ((rules & 2) != 0 || (rules & 1) == 0) {
                    InternetAddress.validate(addressText, gotDelimiter, false);
                }
                InternetAddress address = new InternetAddress();
                address.setAddress(addressText);
                if (start >= 0) {
                    String personal = addresslist.substring(start, end);
                    personal = personal.trim();
                    address.encodedPersonal = InternetAddress.unquote(personal);
                }
                acc.add(address);
            } else {
                StringTokenizer st = new StringTokenizer(addressText);
                while (st.hasMoreTokens()) {
                    addressText = st.nextToken();
                    InternetAddress.validate(addressText, false, false);
                    InternetAddress address = new InternetAddress();
                    address.setAddress(addressText);
                    acc.add(address);
                }
            }
        }
        InternetAddress[] addresses = new InternetAddress[acc.size()];
        acc.toArray(addresses);
        return addresses;
    }

    private static void validate(String address, boolean gotDelimiter, boolean strict) throws AddressException {
        int i;
        int pos = 0;
        if (!strict || gotDelimiter) {
            int i2 = address.indexOf(44, pos);
            if (i2 < 0) {
                i2 = address.indexOf(58, pos);
            }
            while (i2 > -1) {
                if (address.charAt(pos) != '@') {
                    throw new AddressException("Illegal route-addr", address);
                }
                if (address.charAt(i2) != ':') {
                    i2 = address.indexOf(44, pos);
                    if (i2 >= 0) continue;
                    i2 = address.indexOf(58, pos);
                    continue;
                }
                pos = i2 + 1;
                i2 = -1;
            }
        }
        String localName = address;
        String domain = null;
        int atIndex = address.indexOf(64, pos);
        if (atIndex > -1) {
            if (atIndex == pos) {
                throw new AddressException("Missing local name", address);
            }
            if (atIndex == address.length() - 1) {
                throw new AddressException("Missing domain", address);
            }
            localName = address.substring(pos, atIndex);
            domain = address.substring(atIndex + 1);
        } else if (strict) {
            throw new AddressException("Missing final @domain", address);
        }
        String illegalWS = "\t\n\r ";
        int len = 4;
        for (int i3 = 0; i3 < len; ++i3) {
            if (address.indexOf(illegalWS.charAt(i3)) <= -1) continue;
            throw new AddressException("Illegal whitespace", address);
        }
        String illegalName = "\"(),:;<>@[\\]";
        len = 12;
        for (i = 0; i < len; ++i) {
            if (localName.indexOf(illegalName.charAt(i)) <= -1) continue;
            throw new AddressException("Illegal local name", address);
        }
        if (domain != null) {
            for (i = 0; i < len; ++i) {
                if (domain.indexOf(illegalName.charAt(i)) <= -1) continue;
                throw new AddressException("Illegal domain", address);
            }
        }
    }

    private static String quote(String text) {
        int len = text.length();
        boolean needsQuotes = false;
        for (int i = 0; i < len; ++i) {
            char c = text.charAt(i);
            if (c == '\"' || c == '\\') {
                StringBuffer buffer = new StringBuffer(len + 3);
                buffer.append('\"');
                for (int j = 0; j < len; ++j) {
                    c = text.charAt(j);
                    if (c == '\"' || c == '\\') {
                        buffer.append('\\');
                    }
                    buffer.append(c);
                }
                buffer.append('\"');
                return buffer.toString();
            }
            if ((c >= ' ' || c == '\r' || c == '\n' || c == '\t') && c < '\u007f' && needsQuoting.indexOf(c) <= -1) continue;
            needsQuotes = true;
        }
        if (needsQuotes) {
            StringBuffer buffer = new StringBuffer(len + 2);
            buffer.append('\"');
            buffer.append(text);
            buffer.append('\"');
            text = buffer.toString();
        }
        return text;
    }

    private static String unquote(String text) {
        int len = text.length();
        if (len > 2 && text.charAt(0) == '\"' && text.charAt(len - 1) == '\"' && (text = text.substring(1, len - 1)).indexOf(92) > -1) {
            StringBuffer buffer = new StringBuffer(len -= 2);
            for (int i = 0; i < len; ++i) {
                char c = text.charAt(i);
                if (c == '\\' && i < len - 1) {
                    c = text.charAt(++i);
                }
                buffer.append(c);
            }
            text = buffer.toString();
        }
        return text;
    }
}

