/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.runtime.html.browser;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.runtime.html.browser.DocumentChangededListener;
import net.sourceforge.jnlp.runtime.html.browser.HtmlBrowserPanel;
import net.sourceforge.jnlp.util.UrlUtils;
import net.sourceforge.jnlp.util.logging.OutputController;

public class LinksPanel
extends JPanel
implements DocumentChangededListener {
    private URL baseUrl;
    private final Set<String> added = new HashSet<String>();
    private HtmlBrowserPanel browser;
    private static int counter = 0;
    public static final String URL_REGEX = "\\(?\\b(https://|http://|www[.])[-A-Za-z0-9+&;@#/%?=~_()|!:,.;]*[-A-Za-z0-9+&amp;@#/%=~_()|]";
    public static final Pattern URL_REGEX_PATTERN = Pattern.compile("\\(?\\b(https://|http://|www[.])[-A-Za-z0-9+&;@#/%?=~_()|!:,.;]*[-A-Za-z0-9+&amp;@#/%=~_()|]");
    private static final String HTML_QUOTING_REGEX = "(\"|')";
    public static final String HREF_REGEX_START = "(?i)href\\s*=\\s*(\"|')";
    private static final String HREF_REGEX_END = "(\"|')";
    public static final String HREF_REGEX = "(?i)href\\s*=\\s*(\"|').*?(\"|')";
    public static final Pattern HREF_REGEX_PATERN = Pattern.compile("(?i)href\\s*=\\s*(\"|').*?(\"|')");

    public void setInternalBrowser(HtmlBrowserPanel browser) {
        this.browser = browser;
    }

    public LinksPanel() {
        super(new GridLayout(0, 1));
        this.addClearButton();
    }

    private void addClearButton() {
        JButton clear = new JButton(Translator.R("BrowserClearAll"));
        clear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LinksPanel.this.removeAll();
                LinksPanel.this.added.clear();
                LinksPanel.this.addClearButton();
            }
        });
        this.add(clear);
    }

    public void setBaseUrl(URL baseUrl) {
        this.baseUrl = baseUrl;
    }

    public List<String> pullAbsoluteLinks(String text) {
        ArrayList<String> links = new ArrayList<String>();
        Matcher m = URL_REGEX_PATTERN.matcher(text);
        while (m.find()) {
            String urlStr = m.group();
            if (urlStr.startsWith("(") && urlStr.endsWith(")")) {
                urlStr = urlStr.substring(1, urlStr.length() - 1);
            }
            links.add(urlStr);
        }
        return links;
    }

    public List<String> pullHrefs(String text) {
        ArrayList<String> links = new ArrayList<String>();
        Matcher m = HREF_REGEX_PATERN.matcher(text);
        while (m.find()) {
            String urlStr = m.group();
            urlStr = urlStr.replaceFirst(HREF_REGEX_START, "");
            urlStr = urlStr.substring(0, urlStr.length() - 1);
            links.add(urlStr);
        }
        return links;
    }

    public void parseAndAdd(String currentSource) {
        List<String> l = this.pullAbsoluteLinks(currentSource);
        for (String string : l) {
            this.addLink(string);
        }
        l = this.pullHrefs(currentSource);
        for (String string : l) {
            if (!this.added.add(string)) continue;
            this.addLink(this.absolutize(string));
        }
    }

    private String absolutize(String string) {
        if (this.baseUrl == null) {
            return string;
        }
        return UrlUtils.ensureSlashTail(UrlUtils.removeFileName(this.baseUrl)).toExternalForm() + string;
    }

    @Override
    public void documentChangeded(String current) {
        this.parseAndAdd(current);
    }

    private void addLink(String string) {
        OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, string);
        if (this.added.add(string)) {
            this.add(new RowHolder(string));
        }
    }

    @Override
    public void addressChangeded(String url) {
        this.addLink(url);
    }

    @Override
    public void addressChangeded(URL url) {
        if (url != null) {
            this.baseUrl = url;
            this.addLink(url.toExternalForm());
        }
    }

    public List<String> getAllUrls() {
        return new ArrayList<String>(this.added);
    }

    private class RowHolder
    extends JPanel {
        private final String url;

        public RowHolder(String urll) {
            super(new BorderLayout());
            counter++;
            Color bg = this.getBackground();
            if (counter % 2 == 1) {
                bg = new Color(Math.max(0, bg.getRed() - 20), Math.min(255, bg.getGreen() + 20), Math.max(0, bg.getBlue() - 20));
            }
            this.url = urll;
            JLabel l = new JLabel(this.url);
            l.setBackground(bg);
            this.add(l);
            JPanel buttonsPanel = new JPanel(new GridLayout(1, 0));
            buttonsPanel.setBackground(bg);
            JButton b1 = new JButton(Translator.R("BrowserOpenExternal"));
            b1.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    block2: {
                        try {
                            Desktop.getDesktop().browse(new URI(RowHolder.this.url));
                        }
                        catch (Exception ex) {
                            OutputController.getLogger().log(ex);
                            if (JNLPRuntime.isHeadless()) break block2;
                            JOptionPane.showMessageDialog(null, ex);
                        }
                    }
                }
            });
            buttonsPanel.add(b1);
            JButton b2 = new JButton(Translator.R("BrowserOpeninternal"));
            b2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LinksPanel.this.browser.gotoUrl(RowHolder.this.url);
                }
            });
            buttonsPanel.add(b2);
            JButton b3 = new JButton(Translator.R("BrowserCopyUrlToClip"));
            b3.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StringSelection selection = new StringSelection(RowHolder.this.url);
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    clipboard.setContents(selection, selection);
                }
            });
            buttonsPanel.add(b3);
            this.setBackground(bg);
            this.add((Component)buttonsPanel, "East");
        }
    }
}

