#ifndef _EFL_UI_FOCUS_MANAGER_EO_LEGACY_H_
#define _EFL_UI_FOCUS_MANAGER_EO_LEGACY_H_

#ifndef _EFL_UI_FOCUS_MANAGER_EO_CLASS_TYPE
#define _EFL_UI_FOCUS_MANAGER_EO_CLASS_TYPE

typedef Eo Efl_Ui_Focus_Manager;

#endif

#ifndef _EFL_UI_FOCUS_MANAGER_EO_TYPES
#define _EFL_UI_FOCUS_MANAGER_EO_TYPES

/** Structure holding the graph of relations between focussable objects.
 *
 * @since 1.20
 *
 * @ingroup Efl_Ui_Focus
 */
typedef struct _Efl_Ui_Focus_Relations
{
  Eina_List *right; /**< List of objects on the right side */
  Eina_List *left; /**< [List of objects on the left side */
  Eina_List *top; /**< [List of objects above */
  Eina_List *down; /**< [List of objects below */
  Efl_Ui_Focus_Object *next; /**< [Next object */
  Efl_Ui_Focus_Object *prev; /**< Previous object */
  Efl_Ui_Focus_Object *parent; /**< Parent object */
  Efl_Ui_Focus_Manager *redirect; /**< Redirect manager */
  Efl_Ui_Focus_Object *node; /**< The node where this is the information from */
  Eina_Bool logical; /**< @c true if this node is only logical */
  int position_in_history; /**< The position in the history stack */
} Efl_Ui_Focus_Relations;

/** Structure holding the focus object with extra information on logical end
 *
 * @since 1.21
 *
 * @ingroup Efl_Ui_Focus
 */
typedef struct _Efl_Ui_Focus_Manager_Logical_End_Detail
{
  Eina_Bool is_regular_end; /**< @c true if logical end, @c false otherwise */
  Efl_Ui_Focus_Object *element; /**< Focus object element */
} Efl_Ui_Focus_Manager_Logical_End_Detail;


#endif
















#endif
