#ifndef _EFL_UI_FACTORY_EO_H_
#define _EFL_UI_FACTORY_EO_H_

#ifndef _EFL_UI_FACTORY_EO_CLASS_TYPE
#define _EFL_UI_FACTORY_EO_CLASS_TYPE

typedef Eo Efl_Ui_Factory;

#endif

#ifndef _EFL_UI_FACTORY_EO_TYPES
#define _EFL_UI_FACTORY_EO_TYPES


#endif
/** Efl UI factory interface
 *
 * @ingroup Efl_Ui_Factory
 */
#define EFL_UI_FACTORY_INTERFACE efl_ui_factory_interface_get()

EWAPI const Efl_Class *efl_ui_factory_interface_get(void);

/**
 * @brief Create a UI object from the necessary properties in the specified
 * model.
 *
 * @param[in] obj The object.
 * @param[in] model Efl model
 * @param[in] parent Efl canvas
 *
 * @return Created UI object
 *
 * @ingroup Efl_Ui_Factory
 */
EOAPI Efl_Gfx_Entity *efl_ui_factory_create(Eo *obj, Efl_Model *model, Efl_Gfx_Entity *parent);

/**
 * @brief Release a UI object and disconnect from models.
 *
 * @param[in] obj The object.
 * @param[in] ui_view Efl canvas
 *
 * @ingroup Efl_Ui_Factory
 */
EOAPI void efl_ui_factory_release(Eo *obj, Efl_Gfx_Entity *ui_view);

/**
 * @brief Connect factory to a model
 *
 * @param[in] obj The object.
 * @param[in] name Model name
 * @param[in] factory Efl factory
 *
 * @ingroup Efl_Ui_Factory
 */
EOAPI void efl_ui_factory_model_connect(Eo *obj, const char *name, Efl_Ui_Factory *factory);

#endif
