/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.matchers;

import com.google.errorprone.VisitorState;
import com.google.errorprone.matchers.Matcher;
import com.sun.source.tree.MethodTree;
import java.util.Set;
import javax.lang.model.element.Modifier;

public class MethodVisibility
implements Matcher<MethodTree> {
    private final Visibility visibility;

    public MethodVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    @Override
    public boolean matches(MethodTree t, VisitorState state) {
        Set<Modifier> modifiers = t.getModifiers().getFlags();
        if (this.visibility == Visibility.DEFAULT) {
            return !modifiers.contains((Object)Visibility.PUBLIC.toModifier()) && !modifiers.contains((Object)Visibility.PROTECTED.toModifier()) && !modifiers.contains((Object)Visibility.PRIVATE.toModifier());
        }
        return modifiers.contains((Object)this.visibility.toModifier());
    }

    public static enum Visibility {
        PUBLIC(Modifier.PUBLIC),
        PROTECTED(Modifier.PROTECTED),
        DEFAULT(null),
        PRIVATE(Modifier.PRIVATE);

        private Modifier correspondingModifier;

        private Visibility(Modifier correspondingModifier) {
            this.correspondingModifier = correspondingModifier;
        }

        public Modifier toModifier() {
            return this.correspondingModifier;
        }
    }
}

