/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Scope;
import com.google.common.annotations.Beta;
import java.util.EnumSet;

@Beta
public class Implementation {
    private final Class<? extends Detector> mClass;
    private final EnumSet<Scope> mScope;
    private EnumSet<Scope>[] mAnalysisScopes;
    private static final EnumSet<Scope>[] EMPTY = new EnumSet[0];

    public Implementation(Class<? extends Detector> detectorClass, EnumSet<Scope> scope) {
        this(detectorClass, scope, EMPTY);
    }

    public Implementation(Class<? extends Detector> detectorClass, EnumSet<Scope> scope, EnumSet<Scope> ... analysisScopes) {
        this.mClass = detectorClass;
        this.mScope = scope;
        this.mAnalysisScopes = analysisScopes;
    }

    public Class<? extends Detector> getDetectorClass() {
        return this.mClass;
    }

    public String toString() {
        return this.mClass.toString();
    }

    public EnumSet<Scope> getScope() {
        return this.mScope;
    }

    public EnumSet<Scope>[] getAnalysisScopes() {
        return this.mAnalysisScopes;
    }

    public boolean isAdequate(EnumSet<Scope> scope) {
        if (scope.containsAll(this.mScope)) {
            return true;
        }
        if (this.mAnalysisScopes != null) {
            for (EnumSet<Scope> analysisScope : this.mAnalysisScopes) {
                if (!scope.containsAll(analysisScope)) continue;
                return true;
            }
        }
        return false;
    }
}

