/// <reference types="node" />
export interface PinningResult {
    certificate?: ElectronCertificate;
    decoding?: boolean;
    errorMessage?: string;
    fingerprintCheck?: boolean;
    verifiedIssuerRootPubkeys?: boolean;
    verifiedPublicKeyInfo?: boolean;
}
interface ElectronCertificate {
    data: string;
    fingerprint: string;
    issuer: ElectronCertificatePrincipal;
    issuerCert: ElectronCertificate;
    issuerName: string;
    serialNumber: string;
    subject: ElectronCertificatePrincipal;
    subjectName: string;
    validExpiry: number;
    validStart: number;
}
interface ElectronCertificatePrincipal {
    commonName: string;
    country: string;
    locality: string;
    organizations: string[];
    organizationUnits: string[];
    state: string;
}
declare function buildCert(buffer: Buffer): string;
declare function getDERFormattedCertificate(url: string): Promise<Buffer>;
declare function getFingerprint(derCert: Buffer): string;
declare function hostnameShouldBePinned(hostname: string): boolean;
declare function verifyPinning(hostname: string, certificate: ElectronCertificate): PinningResult;
export { buildCert, getDERFormattedCertificate, getFingerprint, hostnameShouldBePinned, verifyPinning };
