M = Manifold(3, 'M')
X = M.chart('x1 x2 x3'); x1, x2, x3 = X[:]
t, B_0, m, q, L, T = var('t B_0 m q L T')
B = B_0*t/T*exp(-(x1**2 + x2**2)/L**2)
D = X.symbolic_velocities()
eqns = [q*B/m*D[1], -q*B/m*D[0], 0]
p = M.point((0,0,0), name='p')
Tp = M.tangent_space(p)
v = Tp((1,0,1))
c = M.integrated_curve(eqns, D, (t, 0, 5), v, name='c')
sol = c.solve(step=0.2,
              parameters_values={B_0:1, m:1, q:1, L:10, T:1},
              solution_key='carac time 1')
interp = c.interpolate(solution_key='carac time 1',
                       interpolation_key='interp 1')
c_plot_2d_1 = c.plot_integrated(ambient_coords=[x1, x2],
                interpolation_key='interp 1', thickness=2.5,
                display_tangent=True, plot_points=200,
                plot_points_tangent=10, scale=0.5, color='blue',
                color_tangent='red')
sphinx_plot(c_plot_2d_1)