/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.config;

import com.intellij.cvsSupport2.config.AbstractConfiguration;
import com.intellij.cvsSupport2.ui.experts.importToCvs.FileExtension;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.DifferenceFilter;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jdom.Element;

public class ImportConfiguration
extends AbstractConfiguration {
    public String VENDOR;
    public String RELEASE_TAG;
    public String LOG_MESSAGE;
    public boolean CHECKOUT_AFTER_IMPORT = true;
    public String KEYWORD_SUBSTITUTION_WRAPPERS = "";
    public boolean MAKE_NEW_FILES_READ_ONLY = false;

    public static ImportConfiguration getInstance() {
        return (ImportConfiguration)ServiceManager.getService(ImportConfiguration.class);
    }

    public ImportConfiguration() {
        super("ImportConfiguration");
    }

    public Collection<FileExtension> getExtensions() {
        String[] wrappers;
        if (StringUtil.isEmpty((String)this.KEYWORD_SUBSTITUTION_WRAPPERS)) {
            return Collections.emptyList();
        }
        ArrayList<FileExtension> result = new ArrayList<FileExtension>();
        for (String wrapper : wrappers = this.KEYWORD_SUBSTITUTION_WRAPPERS.split(";")) {
            String[] extAndSubstitution = wrapper.split(" ");
            if (extAndSubstitution.length != 2) continue;
            result.add(new FileExtension(extAndSubstitution[0], extAndSubstitution[1]));
        }
        return result;
    }

    public void setExtensions(List<FileExtension> items) {
        StringBuilder buffer = new StringBuilder();
        for (FileExtension extension : items) {
            buffer.append(extension.getExtension());
            buffer.append(" ");
            buffer.append(extension.getKeywordSubstitution().getSubstitution().toString());
            buffer.append(";");
        }
        this.KEYWORD_SUBSTITUTION_WRAPPERS = buffer.toString();
    }

    @Override
    public void writeExternal(Element element) throws WriteExternalException {
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element, (DefaultJDOMExternalizer.JDOMFilter)new DifferenceFilter((Object)this, (Object)new ImportConfiguration()));
    }
}

