/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.CommonBundle;
import com.intellij.ide.actions.CloseTabToolbarAction;
import com.intellij.ide.errorTreeView.ErrorTreeElementKind;
import com.intellij.ide.errorTreeView.HotfixData;
import com.intellij.ide.errorTreeView.SimpleErrorData;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.CommittedChangesProvider;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.TransactionProvider;
import com.intellij.openapi.vcs.TransactionRunnable;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.actions.AnnotateToggleAction;
import com.intellij.openapi.vcs.annotate.AnnotationProvider;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.CommitResultHandler;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.committed.ChangesBrowserDialog;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesCache;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesFilterDialog;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesPanel;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesTableModel;
import com.intellij.openapi.vcs.changes.committed.RepositoryLocationCache;
import com.intellij.openapi.vcs.changes.ui.ChangeListViewerDialog;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentI;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.vcs.changes.ui.CommitChangeListDialog;
import com.intellij.openapi.vcs.changes.ui.RollbackChangesDialog;
import com.intellij.openapi.vcs.changes.ui.SelectFilePathsDialog;
import com.intellij.openapi.vcs.changes.ui.SelectFilesDialog;
import com.intellij.openapi.vcs.history.FileHistoryRefresher;
import com.intellij.openapi.vcs.history.FileHistoryRefresherI;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.BackgroundableActionLock;
import com.intellij.openapi.vcs.impl.VcsBackgroundableActions;
import com.intellij.openapi.vcs.impl.VcsErrorViewPanel;
import com.intellij.openapi.vcs.merge.MergeDialogCustomizer;
import com.intellij.openapi.vcs.merge.MergeProvider;
import com.intellij.openapi.vcs.merge.MultipleFileMergeDialog;
import com.intellij.openapi.vcs.versionBrowser.ChangeBrowserSettings;
import com.intellij.openapi.vcs.versionBrowser.ChangesBrowserSettingsEditor;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.AppIcon;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManagerUtil;
import com.intellij.ui.content.MessageView;
import com.intellij.util.ArrayUtil;
import com.intellij.util.AsynchConsumer;
import com.intellij.util.BufferedListConsumer;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ConfirmationDialog;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.history.VcsHistoryProviderEx;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.Component;
import java.awt.Window;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AbstractVcsHelperImpl
extends AbstractVcsHelper {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.impl.AbstractVcsHelperImpl");
    private static final String CHANGES_DETAILS_WINDOW_KEY = "CommittedChangesDetailsLock";
    private Consumer<VcsException> myCustomHandler;

    protected AbstractVcsHelperImpl(@NotNull Project project) {
        if (project == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(0);
        }
        super(project);
        this.myCustomHandler = null;
    }

    public void openMessagesView(VcsErrorViewPanel errorTreeView, @NotNull String tabDisplayName) {
        if (tabDisplayName == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(1);
        }
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        commandProcessor.executeCommand(this.myProject, () -> {
            MessageView messageView = MessageView.SERVICE.getInstance(this.myProject);
            messageView.runWhenInitialized(() -> {
                Content content = ContentFactory.SERVICE.getInstance().createContent((JComponent)errorTreeView, tabDisplayName, true);
                messageView.getContentManager().addContent(content);
                Disposer.register((Disposable)content, (Disposable)errorTreeView);
                messageView.getContentManager().setSelectedContent(content);
                ContentManagerUtil.cleanupContents(content, this.myProject, tabDisplayName);
                ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(ToolWindowId.MESSAGES_WINDOW).activate(null);
            });
        }, VcsBundle.message((String)"command.name.open.error.message.view", (Object[])new Object[0]), null);
    }

    public void showFileHistory(@NotNull VcsHistoryProvider historyProvider, @NotNull FilePath path, @NotNull AbstractVcs vcs) {
        if (historyProvider == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(2);
        }
        if (path == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(3);
        }
        if (vcs == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(4);
        }
        this.showFileHistory(historyProvider, vcs.getAnnotationProvider(), path, vcs);
    }

    public void showFileHistory(@NotNull VcsHistoryProvider historyProvider, @Nullable AnnotationProvider annotationProvider, @NotNull FilePath path, @NotNull AbstractVcs vcs) {
        if (historyProvider == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(5);
        }
        if (path == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(6);
        }
        if (vcs == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(7);
        }
        FileHistoryRefresherI refresher = FileHistoryRefresher.findOrCreate(historyProvider, path, vcs);
        refresher.selectContent();
        refresher.refresh(true);
    }

    public void showFileHistory(@NotNull VcsHistoryProviderEx historyProvider, @NotNull FilePath path, @NotNull AbstractVcs vcs, @Nullable VcsRevisionNumber startingRevisionNumber) {
        if (historyProvider == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(8);
        }
        if (path == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(9);
        }
        if (vcs == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(10);
        }
        FileHistoryRefresherI refresher = FileHistoryRefresher.findOrCreate(historyProvider, path, vcs, startingRevisionNumber);
        refresher.selectContent();
        refresher.refresh(true);
    }

    public void showRollbackChangesDialog(List<Change> changes2) {
        RollbackChangesDialog.rollbackChanges(this.myProject, changes2);
    }

    @Nullable
    public Collection<VirtualFile> selectFilesToProcess(List<VirtualFile> files2, String title, @Nullable String prompt, @Nullable String singleFileTitle, @Nullable String singleFilePromptTemplate, @NotNull VcsShowConfirmationOption confirmationOption) {
        if (confirmationOption == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(11);
        }
        if (files2 == null || files2.isEmpty()) {
            return null;
        }
        String okActionName = CommonBundle.getAddButtonText();
        String cancelActionName = CommonBundle.getCancelButtonText();
        if (files2.size() == 1 && singleFileTitle != null && singleFilePromptTemplate != null) {
            String filePrompt = MessageFormat.format(singleFilePromptTemplate, FileUtil.getLocationRelativeToUserHome((String)files2.get(0).getPresentableUrl()));
            if (ConfirmationDialog.requestForConfirmation((VcsShowConfirmationOption)confirmationOption, (Project)this.myProject, (String)filePrompt, (String)singleFileTitle, (Icon)Messages.getQuestionIcon(), (String)okActionName, (String)cancelActionName)) {
                return files2;
            }
            return null;
        }
        SelectFilesDialog dlg = SelectFilesDialog.init(this.myProject, files2, prompt, confirmationOption, true, false, okActionName, cancelActionName);
        dlg.setTitle(title);
        if (!confirmationOption.isPersistent()) {
            dlg.setDoNotAskOption(null);
        }
        if (dlg.showAndGet()) {
            Collection<VirtualFile> selection = dlg.getSelectedFiles();
            ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>();
            for (VirtualFile file2 : files2) {
                if (!selection.contains(file2)) continue;
                result2.add(file2);
            }
            return result2;
        }
        return null;
    }

    @Nullable
    public Collection<FilePath> selectFilePathsToProcess(@NotNull List<FilePath> files2, String title, @Nullable String prompt, @Nullable String singleFileTitle, @Nullable String singleFilePromptTemplate, @NotNull VcsShowConfirmationOption confirmationOption, @Nullable String okActionName, @Nullable String cancelActionName) {
        if (files2 == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(12);
        }
        if (confirmationOption == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(13);
        }
        if (files2.size() == 1 && singleFileTitle != null && singleFilePromptTemplate != null) {
            String filePrompt = MessageFormat.format(singleFilePromptTemplate, files2.get(0).getPresentableUrl());
            if (ConfirmationDialog.requestForConfirmation((VcsShowConfirmationOption)confirmationOption, (Project)this.myProject, (String)filePrompt, (String)singleFileTitle, (Icon)Messages.getQuestionIcon(), (String)okActionName, (String)cancelActionName)) {
                return files2;
            }
            return null;
        }
        SelectFilePathsDialog dlg = new SelectFilePathsDialog(this.myProject, files2, prompt, confirmationOption, okActionName, cancelActionName, true);
        dlg.setTitle(title);
        if (!confirmationOption.isPersistent()) {
            dlg.setDoNotAskOption(null);
        }
        return dlg.showAndGet() ? dlg.getSelectedFiles() : null;
    }

    @Nullable
    public Collection<FilePath> selectFilePathsToProcess(@NotNull List<FilePath> files2, String title, @Nullable String prompt, @Nullable String singleFileTitle, @Nullable String singleFilePromptTemplate, @NotNull VcsShowConfirmationOption confirmationOption) {
        if (files2 == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(14);
        }
        if (confirmationOption == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(15);
        }
        return this.selectFilePathsToProcess(files2, title, prompt, singleFileTitle, singleFilePromptTemplate, confirmationOption, null, null);
    }

    public void showErrors(List<VcsException> abstractVcsExceptions, @NotNull String tabDisplayName) {
        if (tabDisplayName == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(16);
        }
        this.showErrorsImpl(abstractVcsExceptions.isEmpty(), (Getter<VcsException>)((Getter)() -> (VcsException)((Object)((Object)abstractVcsExceptions.get(0)))), tabDisplayName, (Consumer<VcsErrorViewPanel>)((Consumer)vcsErrorViewPanel -> AbstractVcsHelperImpl.addDirectMessages(vcsErrorViewPanel, abstractVcsExceptions)));
    }

    public boolean commitChanges(@NotNull Collection<Change> changes2, @NotNull LocalChangeList initialChangeList, @NotNull String commitMessage2, @Nullable CommitResultHandler customResultHandler) {
        if (changes2 == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(17);
        }
        if (initialChangeList == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(18);
        }
        if (commitMessage2 == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(19);
        }
        return CommitChangeListDialog.commitChanges(this.myProject, changes2, initialChangeList, CommitChangeListDialog.collectExecutors(this.myProject, changes2), true, commitMessage2, customResultHandler);
    }

    private static void addDirectMessages(VcsErrorViewPanel vcsErrorViewPanel, List<VcsException> abstractVcsExceptions) {
        for (VcsException exception : abstractVcsExceptions) {
            String[] messages = AbstractVcsHelperImpl.getExceptionMessages(exception);
            vcsErrorViewPanel.addMessage(AbstractVcsHelperImpl.getErrorCategory(exception), messages, exception.getVirtualFile(), -1, -1, null);
        }
    }

    private static String[] getExceptionMessages(@NotNull VcsException exception) {
        String[] messages;
        if (exception == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(20);
        }
        if ((messages = exception.getMessages()).length == 0) {
            messages = new String[]{VcsBundle.message((String)"exception.text.unknown.error", (Object[])new Object[0])};
        }
        ArrayList list2 = new ArrayList();
        for (String message : messages) {
            list2.addAll(StringUtil.split((String)StringUtil.convertLineSeparators((String)message), (String)"\n"));
        }
        return ArrayUtil.toStringArray(list2);
    }

    private void showErrorsImpl(boolean isEmpty2, Getter<VcsException> firstGetter, @NotNull String tabDisplayName, Consumer<VcsErrorViewPanel> viewFiller) {
        if (tabDisplayName == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(21);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            VcsException exception;
            if (!isEmpty2 && !this.handleCustom(exception = (VcsException)((Object)firstGetter.get()))) {
                throw new RuntimeException(exception);
            }
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            if (isEmpty2) {
                ContentManagerUtil.cleanupContents(null, this.myProject, tabDisplayName);
                return;
            }
            VcsErrorViewPanel errorTreeView = new VcsErrorViewPanel(this.myProject);
            this.openMessagesView(errorTreeView, tabDisplayName);
            viewFiller.consume((Object)errorTreeView);
        });
    }

    public boolean handleCustom(VcsException exception) {
        if (this.myCustomHandler != null) {
            this.myCustomHandler.consume((Object)exception);
            return true;
        }
        return false;
    }

    public void showErrors(Map<HotfixData, List<VcsException>> exceptionGroups, @NotNull String tabDisplayName) {
        if (tabDisplayName == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(22);
        }
        this.showErrorsImpl(exceptionGroups.isEmpty(), (Getter<VcsException>)((Getter)() -> {
            List exceptionList = (List)exceptionGroups.values().iterator().next();
            return exceptionList == null ? null : (exceptionList.isEmpty() ? null : (VcsException)((Object)((Object)exceptionList.get(0))));
        }), tabDisplayName, (Consumer<VcsErrorViewPanel>)((Consumer)vcsErrorViewPanel -> {
            for (Map.Entry entry : exceptionGroups.entrySet()) {
                if (entry.getKey() == null) {
                    AbstractVcsHelperImpl.addDirectMessages(vcsErrorViewPanel, (List)entry.getValue());
                    continue;
                }
                List exceptionList = (List)entry.getValue();
                ArrayList<SimpleErrorData> list2 = new ArrayList<SimpleErrorData>(exceptionList.size());
                for (VcsException exception : exceptionList) {
                    String[] messages = AbstractVcsHelperImpl.getExceptionMessages(exception);
                    list2.add(new SimpleErrorData(ErrorTreeElementKind.convertMessageFromCompilerErrorType((int)AbstractVcsHelperImpl.getErrorCategory(exception)), messages, exception.getVirtualFile()));
                }
                vcsErrorViewPanel.addHotfixGroup((HotfixData)entry.getKey(), list2);
            }
        }));
    }

    private static int getErrorCategory(VcsException exception) {
        if (exception.isWarning()) {
            return 5;
        }
        return 4;
    }

    public List<VcsException> runTransactionRunnable(AbstractVcs vcs, TransactionRunnable runnable2, Object vcsParameters) {
        boolean transactionSupported;
        ArrayList<VcsException> exceptions = new ArrayList<VcsException>();
        TransactionProvider transactionProvider = vcs.getTransactionProvider();
        boolean bl = transactionSupported = transactionProvider != null;
        if (transactionSupported) {
            transactionProvider.startTransaction(vcsParameters);
        }
        runnable2.run(exceptions);
        if (transactionSupported) {
            if (exceptions.isEmpty()) {
                try {
                    transactionProvider.commitTransaction(vcsParameters);
                }
                catch (VcsException e) {
                    exceptions.add(e);
                    transactionProvider.rollbackTransaction(vcsParameters);
                }
            } else {
                transactionProvider.rollbackTransaction(vcsParameters);
            }
        }
        return exceptions;
    }

    public void showAnnotation(FileAnnotation annotation, VirtualFile file2, AbstractVcs vcs) {
        this.showAnnotation(annotation, file2, vcs, 0);
    }

    public void showAnnotation(FileAnnotation annotation, VirtualFile file2, AbstractVcs vcs, int line) {
        Editor editor;
        TextEditor textFileEditor;
        FileEditor fileEditor = FileEditorManager.getInstance((Project)this.myProject).getSelectedEditor(file2);
        if (fileEditor instanceof TextEditor) {
            textFileEditor = (TextEditor)fileEditor;
        } else {
            Object[] editors = FileEditorManager.getInstance((Project)this.myProject).getEditors(file2);
            textFileEditor = (TextEditor)ContainerUtil.findInstance((Object[])editors, TextEditor.class);
        }
        if (textFileEditor != null) {
            editor = textFileEditor.getEditor();
        } else {
            OpenFileDescriptor openFileDescriptor = new OpenFileDescriptor(this.myProject, file2, line, 0);
            editor = FileEditorManager.getInstance((Project)this.myProject).openTextEditor(openFileDescriptor, true);
        }
        if (editor == null) {
            Messages.showMessageDialog((String)VcsBundle.message((String)"message.text.cannot.open.editor", (Object[])new Object[]{file2.getPresentableUrl()}), (String)VcsBundle.message((String)"message.title.cannot.open.editor", (Object[])new Object[0]), (Icon)Messages.getInformationIcon());
            return;
        }
        AnnotateToggleAction.doAnnotate(editor, this.myProject, annotation, vcs);
    }

    public void showChangesBrowser(List<CommittedChangeList> changelists) {
        this.showChangesBrowser(changelists, null);
    }

    public void showChangesBrowser(List<CommittedChangeList> changelists, @Nls String title) {
        this.showChangesBrowser(new CommittedChangesTableModel(changelists, false), title, false, null);
    }

    private ChangesBrowserDialog createChangesBrowserDialog(CommittedChangesTableModel changelists, String title, boolean showSearchAgain, @Nullable Component parent, Consumer<ChangesBrowserDialog> initRunnable) {
        ChangesBrowserDialog dlg;
        ChangesBrowserDialog.Mode mode = showSearchAgain ? ChangesBrowserDialog.Mode.Browse : ChangesBrowserDialog.Mode.Simple;
        ChangesBrowserDialog changesBrowserDialog = dlg = parent != null ? new ChangesBrowserDialog(this.myProject, parent, changelists, mode, initRunnable) : new ChangesBrowserDialog(this.myProject, changelists, mode, initRunnable);
        if (title != null) {
            dlg.setTitle(title);
        }
        return dlg;
    }

    private void showChangesBrowser(CommittedChangesTableModel changelists, String title, boolean showSearchAgain, @Nullable Component parent) {
        ChangesBrowserDialog dlg;
        ChangesBrowserDialog.Mode mode = showSearchAgain ? ChangesBrowserDialog.Mode.Browse : ChangesBrowserDialog.Mode.Simple;
        ChangesBrowserDialog changesBrowserDialog = dlg = parent != null ? new ChangesBrowserDialog(this.myProject, parent, changelists, mode, null) : new ChangesBrowserDialog(this.myProject, changelists, mode, null);
        if (title != null) {
            dlg.setTitle(title);
        }
        dlg.show();
    }

    public void showChangesListBrowser(CommittedChangeList changelist, @Nullable VirtualFile toSelect2, @Nls String title) {
        ChangeListViewerDialog dlg = new ChangeListViewerDialog(this.myProject, changelist, toSelect2);
        if (title != null) {
            dlg.setTitle(title);
        }
        dlg.show();
    }

    public void showChangesListBrowser(CommittedChangeList changelist, @Nls String title) {
        this.showChangesListBrowser(changelist, null, title);
    }

    public void showWhatDiffersBrowser(Component parent, Collection<Change> changes2, @Nls String title) {
        ChangeListViewerDialog dlg = new ChangeListViewerDialog(parent, this.myProject, changes2);
        if (title != null) {
            dlg.setTitle(title);
        }
        dlg.show();
    }

    public void showChangesBrowser(CommittedChangesProvider provider, RepositoryLocation location, @Nls String title, Component parent) {
        boolean ok;
        ChangesBrowserSettingsEditor filterUI = provider.createFilterUI(true);
        ChangeBrowserSettings settings = provider.createDefaultSettings();
        if (filterUI != null) {
            CommittedChangesFilterDialog dlg = new CommittedChangesFilterDialog(this.myProject, filterUI, settings);
            dlg.show();
            ok = dlg.getExitCode() == 0;
            settings = dlg.getSettings();
        } else {
            ok = true;
        }
        if (ok) {
            if (this.myProject.isDefault() || ProjectLevelVcsManager.getInstance((Project)this.myProject).getAllActiveVcss().length == 0 || !ModalityState.NON_MODAL.equals(ModalityState.current())) {
                ArrayList<CommittedChangeList> versions = new ArrayList<CommittedChangeList>();
                if (parent == null || !parent.isValid()) {
                    parent = WindowManager.getInstance().suggestParentWindow(this.myProject);
                }
                CommittedChangesTableModel model = new CommittedChangesTableModel(versions, true);
                AsynchronousListsLoader[] task = new AsynchronousListsLoader[1];
                ChangeBrowserSettings finalSettings = settings;
                ChangesBrowserDialog dlg = this.createChangesBrowserDialog(model, title, filterUI != null, parent, (Consumer<ChangesBrowserDialog>)((Consumer)changesBrowserDialog -> {
                    task[0] = new AsynchronousListsLoader(this.myProject, provider, location, finalSettings, (ChangesBrowserDialog)((Object)changesBrowserDialog));
                    ProgressManager.getInstance().run((Task)task[0]);
                }));
                dlg.startLoading();
                dlg.show();
                if (task[0] != null) {
                    task[0].cancel();
                    List<VcsException> exceptions = task[0].getExceptions();
                    if (!exceptions.isEmpty()) {
                        Messages.showErrorDialog((Project)this.myProject, (String)VcsBundle.message((String)"browse.changes.error.message", (Object[])new Object[]{exceptions.get(0).getMessage()}), (String)VcsBundle.message((String)"browse.changes.error.title", (Object[])new Object[0]));
                        return;
                    }
                    if (!task[0].isRevisionsReturned()) {
                        Messages.showInfoMessage((Project)this.myProject, (String)VcsBundle.message((String)"browse.changes.nothing.found", (Object[])new Object[0]), (String)VcsBundle.message((String)"browse.changes.nothing.found.title", (Object[])new Object[0]));
                    }
                }
            } else {
                this.openCommittedChangesTab(provider, location, settings, 0, title);
            }
        }
    }

    @NotNull
    public List<VirtualFile> showMergeDialog(@NotNull List<VirtualFile> files2, @NotNull MergeProvider provider, @NotNull MergeDialogCustomizer mergeDialogCustomizer) {
        if (files2 == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(23);
        }
        if (provider == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(24);
        }
        if (mergeDialogCustomizer == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(25);
        }
        if (files2.isEmpty()) {
            List<VirtualFile> list2 = Collections.emptyList();
            if (list2 == null) {
                AbstractVcsHelperImpl.$$$reportNull$$$0(26);
            }
            return list2;
        }
        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)false, (boolean)false, (VirtualFile[])((VirtualFile[])ArrayUtil.toObjectArray(files2, VirtualFile.class)));
        MultipleFileMergeDialog fileMergeDialog = new MultipleFileMergeDialog(this.myProject, files2, provider, mergeDialogCustomizer);
        AppIcon.getInstance().requestAttention(this.myProject, true);
        fileMergeDialog.show();
        List<VirtualFile> list3 = fileMergeDialog.getProcessedFiles();
        if (list3 == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(27);
        }
        return list3;
    }

    public void openCommittedChangesTab(AbstractVcs vcs, VirtualFile root, ChangeBrowserSettings settings, int maxCount, String title) {
        RepositoryLocationCache cache = CommittedChangesCache.getInstance(this.myProject).getLocationCache();
        RepositoryLocation location = cache.getLocation(vcs, VcsUtil.getFilePath((VirtualFile)root), false);
        this.openCommittedChangesTab(vcs.getCommittedChangesProvider(), location, settings, maxCount, title);
    }

    public void openCommittedChangesTab(CommittedChangesProvider provider, RepositoryLocation location, ChangeBrowserSettings settings, int maxCount, String title) {
        DefaultActionGroup extraActions = new DefaultActionGroup();
        CommittedChangesPanel panel2 = new CommittedChangesPanel(this.myProject, provider, settings, location, (ActionGroup)extraActions);
        panel2.setMaxCount(maxCount);
        panel2.refreshChanges(false);
        ContentFactory factory = ContentFactory.SERVICE.getInstance();
        if (title == null && location != null) {
            title = VcsBundle.message((String)"browse.changes.content.title", (Object[])new Object[]{location.toPresentableString()});
        }
        final Content content = factory.createContent((JComponent)panel2, title, false);
        final ChangesViewContentI contentManager = ChangesViewContentManager.getInstance(this.myProject);
        contentManager.addContent(content);
        contentManager.setSelectedContent(content);
        extraActions.add((AnAction)new CloseTabToolbarAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                contentManager.removeContent(content);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/impl/AbstractVcsHelperImpl$1", "actionPerformed"));
            }
        });
        ToolWindow window = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(ChangesViewContentManager.TOOLWINDOW_ID);
        if (!window.isVisible()) {
            window.activate(null);
        }
    }

    public void loadAndShowCommittedChangesDetails(@NotNull Project project, @NotNull VcsRevisionNumber revision, @NotNull VirtualFile virtualFile, @NotNull VcsKey vcsKey, @Nullable RepositoryLocation location, boolean isNonLocal) {
        AbstractVcs vcs;
        if (project == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(28);
        }
        if (revision == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(29);
        }
        if (virtualFile == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(30);
        }
        if (vcsKey == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(31);
        }
        if ((vcs = ProjectLevelVcsManager.getInstance((Project)project).findVcsByName(vcsKey.getName())) == null) {
            return;
        }
        CommittedChangesProvider provider = vcs.getCommittedChangesProvider();
        if (provider == null) {
            return;
        }
        if (isNonLocal && provider.getForNonLocal(virtualFile) == null) {
            return;
        }
        FilePath filePath = VcsUtil.getFilePath((VirtualFile)virtualFile);
        AbstractVcsHelperImpl.loadAndShowCommittedChangesDetails(project, revision, filePath, () -> AbstractVcsHelperImpl.getAffectedChanges(provider, virtualFile, revision, location, isNonLocal));
    }

    public static void loadAndShowCommittedChangesDetails(@NotNull Project project, @NotNull VcsRevisionNumber revision, @NotNull FilePath filePath, @NotNull CommittedChangeListProvider changelistProvider) {
        if (project == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(32);
        }
        if (revision == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(33);
        }
        if (filePath == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(34);
        }
        if (changelistProvider == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(35);
        }
        String title = VcsBundle.message((String)"paths.affected.in.revision", (Object[])new Object[]{VcsUtil.getShortRevisionString((VcsRevisionNumber)revision)});
        BackgroundableActionLock lock = BackgroundableActionLock.getLock(project, new Object[]{VcsBackgroundableActions.COMMITTED_CHANGES_DETAILS, revision, filePath.getPath()});
        if (lock.isLocked()) {
            for (Window window : Window.getWindows()) {
                Object windowLock = UIUtil.getWindowClientProperty((Window)window, (Object)CHANGES_DETAILS_WINDOW_KEY);
                if (windowLock == null || !lock.equals(windowLock)) continue;
                UIUtil.toFront((Window)window);
                break;
            }
            return;
        }
        lock.lock();
        ChangeListViewerDialog dlg = new ChangeListViewerDialog(project);
        dlg.setTitle(title);
        UIUtil.putWindowClientProperty((Window)dlg.getWindow(), (Object)CHANGES_DETAILS_WINDOW_KEY, (Object)lock);
        Disposer.register((Disposable)dlg.getDisposable(), () -> lock.unlock());
        dlg.loadChangesInBackground((ThrowableComputable<? extends ChangeListViewerDialog.ChangelistData, ? extends VcsException>)((ThrowableComputable)() -> {
            try {
                Pair<? extends CommittedChangeList, FilePath> pair = changelistProvider.loadChangelist();
                if (pair == null || pair.getFirst() == null) {
                    throw new VcsException(AbstractVcsHelperImpl.failedText(filePath, revision));
                }
                CommittedChangeList changeList = (CommittedChangeList)pair.getFirst();
                FilePath targetPath = (FilePath)pair.getSecond();
                FilePath navigateToPath = (FilePath)ObjectUtils.notNull((Object)targetPath, (Object)filePath);
                return new ChangeListViewerDialog.ChangelistData(changeList, navigateToPath);
            }
            catch (VcsException e) {
                throw new VcsException(AbstractVcsHelperImpl.failedText(filePath, revision), (Throwable)e);
            }
        }));
        dlg.show();
    }

    @Nullable
    private static Pair<CommittedChangeList, FilePath> getAffectedChanges(@NotNull CommittedChangesProvider provider, @NotNull VirtualFile virtualFile, @NotNull VcsRevisionNumber revision, @Nullable RepositoryLocation location, boolean isNonLocal) throws VcsException {
        if (provider == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(36);
        }
        if (virtualFile == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(37);
        }
        if (revision == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(38);
        }
        if (!isNonLocal) {
            Pair pair = provider.getOneList(virtualFile, revision);
            if (pair != null) {
                return pair;
            }
        } else if (location != null) {
            ChangeBrowserSettings settings = provider.createDefaultSettings();
            settings.USE_CHANGE_BEFORE_FILTER = true;
            settings.CHANGE_BEFORE = revision.asString();
            List changes2 = provider.getCommittedChanges(settings, location, 1);
            if (changes2 != null && changes2.size() == 1) {
                return Pair.create(changes2.get(0), null);
            }
        } else {
            CommittedChangeList list2 = AbstractVcsHelperImpl.getRemoteList(provider, revision, virtualFile);
            if (list2 != null) {
                return Pair.create((Object)list2, null);
            }
        }
        LOG.warn(String.format("Can't get affected files: path: %s; revision: %s; location: %s; nonLocal: %s", virtualFile.getPath(), revision.asString(), location, isNonLocal), new Throwable());
        return null;
    }

    @Nullable
    public static CommittedChangeList getRemoteList(@NotNull CommittedChangesProvider provider, @NotNull VcsRevisionNumber revision, @NotNull VirtualFile nonLocal) throws VcsException {
        RepositoryLocation local;
        if (provider == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(39);
        }
        if (revision == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(40);
        }
        if (nonLocal == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(41);
        }
        if ((local = provider.getForNonLocal(nonLocal)) != null) {
            String number = revision.asString();
            ChangeBrowserSettings settings = provider.createDefaultSettings();
            List changes2 = provider.getCommittedChanges(settings, local, provider.getUnlimitedCountValue());
            if (changes2 != null) {
                for (CommittedChangeList change : changes2) {
                    if (!number.equals(String.valueOf(change.getNumber()))) continue;
                    return change;
                }
            }
        }
        return null;
    }

    @NotNull
    private static String failedText(@NotNull FilePath filePath, @NotNull VcsRevisionNumber revision) {
        if (filePath == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(42);
        }
        if (revision == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(43);
        }
        String string = "Show all affected files for " + filePath.getPath() + " at " + revision.asString() + " failed";
        if (string == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(44);
        }
        return string;
    }

    public static void setCustomExceptionHandler(Project project, Consumer<VcsException> customHandler) {
        ((AbstractVcsHelperImpl)AbstractVcsHelperImpl.getInstance((Project)project)).myCustomHandler = customHandler;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 26: 
            case 27: 
            case 44: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 26: 
            case 27: 
            case 44: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 16: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tabDisplayName";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "historyProvider";
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 4: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "confirmationOption";
                break;
            }
            case 12: 
            case 14: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialChangeList";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitMessage";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exception";
                break;
            }
            case 24: 
            case 36: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mergeDialogCustomizer";
                break;
            }
            case 26: 
            case 27: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/impl/AbstractVcsHelperImpl";
                break;
            }
            case 29: 
            case 33: 
            case 38: 
            case 40: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revision";
                break;
            }
            case 30: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsKey";
                break;
            }
            case 34: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changelistProvider";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nonLocal";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/impl/AbstractVcsHelperImpl";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "showMergeDialog";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "failedText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "openMessagesView";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "showFileHistory";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "selectFilesToProcess";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "selectFilePathsToProcess";
                break;
            }
            case 16: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "showErrors";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "commitChanges";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getExceptionMessages";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "showErrorsImpl";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "showMergeDialog";
                break;
            }
            case 26: 
            case 27: 
            case 44: {
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "loadAndShowCommittedChangesDetails";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getAffectedChanges";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getRemoteList";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "failedText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 26: 
            case 27: 
            case 44: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface CommittedChangeListProvider {
        @Nullable
        public Pair<? extends CommittedChangeList, FilePath> loadChangelist() throws VcsException;
    }

    private static class AsynchronousListsLoader
    extends Task.Backgroundable {
        private final CommittedChangesProvider myProvider;
        private final RepositoryLocation myLocation;
        private final ChangeBrowserSettings mySettings;
        private final ChangesBrowserDialog myDlg;
        private final List<VcsException> myExceptions;
        private volatile boolean myCanceled;
        private boolean myRevisionsReturned;

        private AsynchronousListsLoader(@Nullable Project project, CommittedChangesProvider provider, RepositoryLocation location, ChangeBrowserSettings settings, ChangesBrowserDialog dlg) {
            super(project, VcsBundle.message((String)"browse.changes.progress.title", (Object[])new Object[0]), true);
            this.myProvider = provider;
            this.myLocation = location;
            this.mySettings = settings;
            this.myDlg = dlg;
            this.myExceptions = new LinkedList<VcsException>();
        }

        public void cancel() {
            this.myCanceled = true;
        }

        public void run(final @NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                AsynchronousListsLoader.$$$reportNull$$$0(0);
            }
            final AsynchConsumer<List<CommittedChangeList>> appender = this.myDlg.getAppender();
            final BufferedListConsumer<CommittedChangeList> bufferedListConsumer = new BufferedListConsumer<CommittedChangeList>(10, (Consumer<List<CommittedChangeList>>)appender, -1);
            final Application application = ApplicationManager.getApplication();
            try {
                this.myProvider.loadCommittedChanges(this.mySettings, this.myLocation, 0, (AsynchConsumer)new AsynchConsumer<CommittedChangeList>(){

                    public void consume(CommittedChangeList committedChangeList) {
                        myRevisionsReturned = true;
                        bufferedListConsumer.consumeOne(committedChangeList);
                        if (myCanceled) {
                            indicator.cancel();
                        }
                    }

                    public void finished() {
                        bufferedListConsumer.flush();
                        appender.finished();
                        if (!myRevisionsReturned) {
                            application.invokeLater(() -> myDlg.close(-1), ModalityState.stateForComponent((Component)myDlg.getWindow()));
                        }
                    }
                });
            }
            catch (VcsException e) {
                this.myExceptions.add(e);
                application.invokeLater(() -> this.myDlg.close(-1), ModalityState.stateForComponent((Component)this.myDlg.getWindow()));
            }
        }

        public List<VcsException> getExceptions() {
            return this.myExceptions;
        }

        public boolean isRevisionsReturned() {
            return this.myRevisionsReturned;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/impl/AbstractVcsHelperImpl$AsynchronousListsLoader", "run"));
        }
    }
}

