/*
 * Decompiled with CFR 0.152.
 */
package processing.app.contrib;

import processing.app.contrib.Contribution;
import processing.app.contrib.ContributionTab;
import processing.app.contrib.DetailPanel;
import processing.app.contrib.ListPanel;
import processing.app.contrib.UpdateStatusPanel;

public class UpdateListPanel
extends ListPanel {
    Contribution.Filter contribFilter;

    public UpdateListPanel(ContributionTab contributionTab, Contribution.Filter contribFilter) {
        super(contributionTab, contribFilter, true, ListPanel.ContributionColumn.STATUS_NO_HEADER, ListPanel.ContributionColumn.NAME, ListPanel.ContributionColumn.AUTHOR, ListPanel.ContributionColumn.INSTALLED_VERSION, ListPanel.ContributionColumn.AVAILABLE_VERSION);
        this.contribFilter = contribFilter;
        this.table.getTableHeader().setEnabled(false);
    }

    @Override
    public void contributionAdded(Contribution contribution) {
        if (this.contribFilter.matches(contribution)) {
            super.contributionAdded(contribution);
            ((UpdateStatusPanel)this.contributionTab.statusPanel).update();
        }
    }

    @Override
    public void contributionRemoved(Contribution contribution) {
        super.contributionRemoved(contribution);
        ((UpdateStatusPanel)this.contributionTab.statusPanel).update();
    }

    @Override
    public void contributionChanged(Contribution oldContrib, Contribution newContrib) {
        DetailPanel panel = (DetailPanel)this.panelByContribution.get(oldContrib);
        if (panel == null) {
            this.contributionAdded(newContrib);
        } else if (newContrib.isInstalled()) {
            this.panelByContribution.remove(oldContrib);
        }
        this.model.fireTableDataChanged();
    }
}

