# EnvVars
<span class="source-link">[[Source]](src/options/env_vars.md#L3)</span>
```pony
primitive val EnvVars
```

## Constructors

### create
<span class="source-link">[[Source]](src/options/env_vars.md#L3)</span>


```pony
new val create()
: EnvVars val^
```

#### Returns

* [EnvVars](options-EnvVars.md) val^

---

## Public Functions

### apply
<span class="source-link">[[Source]](src/options/env_vars.md#L4)</span>


Turns an array of strings that look like environment variables, ie
key=value, into a map from string to string.


```pony
fun box apply(
  from: Array[String val] val)
: HashMap[String val, String val, HashEq[String val] val] val
```
#### Parameters

*   from: [Array](builtin-Array.md)\[[String](builtin-String.md) val\] val

#### Returns

* [HashMap](collections-HashMap.md)\[[String](builtin-String.md) val, [String](builtin-String.md) val, [HashEq](collections-HashEq.md)\[[String](builtin-String.md) val\] val\] val

---

### eq
<span class="source-link">[[Source]](src/options/env_vars.md#L4)</span>


```pony
fun box eq(
  that: EnvVars val)
: Bool val
```
#### Parameters

*   that: [EnvVars](options-EnvVars.md) val

#### Returns

* [Bool](builtin-Bool.md) val

---

### ne
<span class="source-link">[[Source]](src/options/env_vars.md#L4)</span>


```pony
fun box ne(
  that: EnvVars val)
: Bool val
```
#### Parameters

*   that: [EnvVars](options-EnvVars.md) val

#### Returns

* [Bool](builtin-Bool.md) val

---

