/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.notification;

import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIcon;
import de.jensd.fx.glyphs.fontawesome.utils.FontAwesomeIconFactory;
import de.jensd.fx.glyphs.materialdesignicons.MaterialDesignIcon;
import de.jensd.fx.glyphs.materialdesignicons.utils.MaterialDesignIconFactory;
import javafx.scene.Node;

public enum NotificationType {
    INFO{

        @Override
        public Node getGraphic() {
            return MaterialDesignIconFactory.get().createIcon((GlyphIcons)MaterialDesignIcon.INFORMATION, NotificationType.DEFAULT_ICON_SIZE);
        }

        @Override
        public String getStyleClass() {
            return "notification-info";
        }
    }
    ,
    WARN{

        @Override
        public Node getGraphic() {
            return MaterialDesignIconFactory.get().createIcon((GlyphIcons)MaterialDesignIcon.ALERT, NotificationType.DEFAULT_ICON_SIZE);
        }

        @Override
        public String getStyleClass() {
            return "notification-warn";
        }
    }
    ,
    ERROR{

        @Override
        public Node getGraphic() {
            return MaterialDesignIconFactory.get().createIcon((GlyphIcons)MaterialDesignIcon.CLOSE_CIRCLE, NotificationType.DEFAULT_ICON_SIZE);
        }

        @Override
        public String getStyleClass() {
            return "notification-error";
        }
    }
    ,
    GO_PRO{

        @Override
        public Node getGraphic() {
            return FontAwesomeIconFactory.get().createIcon((GlyphIcons)FontAwesomeIcon.HEART_ALT, NotificationType.DEFAULT_ICON_SIZE);
        }

        @Override
        public String getStyleClass() {
            return "notification-pro";
        }
    }
    ,
    SHARE{

        @Override
        public Node getGraphic() {
            return FontAwesomeIconFactory.get().createIcon((GlyphIcons)FontAwesomeIcon.SHARE_ALT, NotificationType.DEFAULT_ICON_SIZE);
        }

        @Override
        public String getStyleClass() {
            return "";
        }
    };

    private static final String DEFAULT_ICON_SIZE = "32.0";

    public abstract Node getGraphic();

    public abstract String getStyleClass();
}

