/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.io;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.function.Consumer;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.input.DragEvent;
import javafx.scene.input.TransferMode;
import org.apache.commons.lang3.StringUtils;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.ui.io.BrowsableField;
import org.pdfsam.ui.io.FileChoosers;
import org.pdfsam.ui.io.RememberingLatestDirectoryChooserWrapper;

public class BrowsableDirectoryField
extends BrowsableField {
    private BrowseEventHandler handler = new BrowseEventHandler();

    public BrowsableDirectoryField() {
        this.setBrowseWindowTitle(DefaultI18nContext.getInstance().i18n("Select a directory"));
        this.getTextField().setErrorMessage(DefaultI18nContext.getInstance().i18n("Select an existing directory"));
        this.getTextField().setPromptText(DefaultI18nContext.getInstance().i18n("Select a directory"));
        this.getBrowseButton().setOnAction((EventHandler)this.handler);
        this.getTextField().setOnAction(this.handler);
        this.setOnDragOver(e -> this.dragConsume((DragEvent)e, this.onDragOverConsumer()));
        this.setOnDragDropped(e -> this.dragConsume((DragEvent)e, this.onDragDropped()));
    }

    @Override
    void setTextFromFile(File inputFile) {
        if (inputFile != null) {
            if (inputFile.isDirectory()) {
                this.getTextField().setText(inputFile.getAbsolutePath());
            } else {
                this.getTextField().setText(inputFile.getParent());
            }
            this.getTextField().validate();
        }
    }

    private void dragConsume(DragEvent e, Consumer<DragEvent> c) {
        List files = e.getDragboard().getFiles();
        if (files != null && !files.isEmpty()) {
            c.accept(e);
        }
        e.consume();
    }

    private Consumer<DragEvent> onDragOverConsumer() {
        return e -> e.acceptTransferModes(TransferMode.COPY_OR_MOVE);
    }

    private Consumer<DragEvent> onDragDropped() {
        return e -> {
            e.getDragboard().getFiles().stream().filter(f -> f.isDirectory()).findFirst().ifPresent(file -> this.setTextFromFile((File)file));
            e.setDropCompleted(true);
        };
    }

    private class BrowseEventHandler
    implements EventHandler<ActionEvent> {
        private BrowseEventHandler() {
        }

        public void handle(ActionEvent event) {
            Path path;
            RememberingLatestDirectoryChooserWrapper fileChooser = FileChoosers.getDirectoryChooser(BrowsableDirectoryField.this.getBrowseWindowTitle());
            String currentSelection = BrowsableDirectoryField.this.getTextField().getText();
            if (StringUtils.isNotBlank((CharSequence)currentSelection) && Files.exists(path = Paths.get(currentSelection, new String[0]), new LinkOption[0])) {
                fileChooser.setInitialDirectory(path.toFile());
            }
            BrowsableDirectoryField.this.setTextFromFile(fileChooser.showDialog(BrowsableDirectoryField.this.getTextField().getScene().getWindow()));
        }
    }
}

