/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.core.support.io;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.SystemUtils;
import org.sejda.model.exception.TaskIOException;
import org.sejda.model.exception.TaskOutputVisitException;
import org.sejda.model.output.DirectoryTaskOutput;
import org.sejda.model.output.FileOrDirectoryTaskOutput;
import org.sejda.model.output.FileTaskOutput;
import org.sejda.model.output.TaskOutput;
import org.sejda.model.output.TaskOutputDispatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IOUtils {
    private static final Logger LOG = LoggerFactory.getLogger(IOUtils.class);
    private static final String BUFFER_NAME = "sejdaTmp";
    private static final int TEMP_DIR_ATTEMPTS = 1000;

    private IOUtils() {
    }

    public static File createTemporaryBuffer(TaskOutput taskOut) throws TaskIOException {
        TmpBufferLocationFinder bufferLocationFinder = new TmpBufferLocationFinder();
        try {
            taskOut.accept((TaskOutputDispatcher)bufferLocationFinder);
            File buffer = IOUtils.tmpFile(bufferLocationFinder.bufferLocation).toFile();
            buffer.deleteOnExit();
            return buffer;
        }
        catch (IOException | TaskOutputVisitException e) {
            throw new TaskIOException("Unable to create temporary buffer", e);
        }
    }

    private static Path tmpFile(Path location) throws IOException {
        return Files.createTempFile(location, ".sejdaTmp", null, new FileAttribute[0]);
    }

    public static File createTemporaryBuffer() throws TaskIOException {
        return IOUtils.createTemporaryBuffer(".tmp");
    }

    public static File createTemporaryBuffer(String extension) throws TaskIOException {
        try {
            File buffer = File.createTempFile(BUFFER_NAME, extension);
            buffer.deleteOnExit();
            return buffer;
        }
        catch (IOException e) {
            throw new TaskIOException("Unable to create temporary buffer", (Throwable)e);
        }
    }

    public static File createTemporaryBufferWithName(String filename) throws TaskIOException {
        try {
            File tmpDir = IOUtils.createTemporaryFolder();
            File buffer = new File(tmpDir, filename);
            boolean created = buffer.createNewFile();
            if (!created) {
                throw new IOException("Could not create new file: " + buffer.getAbsolutePath());
            }
            buffer.deleteOnExit();
            return buffer;
        }
        catch (IOException | IllegalStateException e) {
            throw new TaskIOException("Unable to create temporary buffer", (Throwable)e);
        }
    }

    public static File createTemporaryFolder() {
        File baseDir = SystemUtils.getJavaIoTmpDir();
        String baseName = BUFFER_NAME + System.currentTimeMillis() + "-";
        for (int counter = 0; counter < 1000; ++counter) {
            File tempDir = new File(baseDir, baseName + counter);
            if (!tempDir.mkdir()) continue;
            return tempDir;
        }
        throw new IllegalStateException("Failed to create directory within 1000 attempts (tried " + baseName + "0 to " + baseName + 999 + ')');
    }

    public static File findNewNameThatDoesNotExist(File output) throws IOException {
        File newNamedOutput;
        int count = 1;
        int maxTries = 100;
        String basename = FilenameUtils.getBaseName((String)output.getName());
        String extension = FilenameUtils.getExtension((String)output.getName());
        do {
            String newName = String.format("%s(%d).%s", basename, count, extension);
            newNamedOutput = new File(output.getParent(), newName);
        } while (++count < maxTries && newNamedOutput.exists());
        if (newNamedOutput.exists()) {
            LOG.warn("Unable to generate a new filename that does not exist, path was {}", (Object)output);
            throw new IOException(String.format("Unable to generate a new filename that does not exist, path was %s", output));
        }
        return newNamedOutput;
    }

    private static class TmpBufferLocationFinder
    implements TaskOutputDispatcher {
        private Path bufferLocation = Paths.get(SystemUtils.JAVA_IO_TMPDIR, new String[0]);

        private TmpBufferLocationFinder() {
        }

        public void dispatch(FileTaskOutput output) {
            Path dest = output.getDestination().toPath().getParent();
            if (Files.exists(dest, new LinkOption[0])) {
                this.bufferLocation = dest;
            }
        }

        public void dispatch(DirectoryTaskOutput output) {
            Path dest = output.getDestination().toPath();
            if (Files.exists(dest, new LinkOption[0])) {
                this.bufferLocation = dest;
            }
        }

        public void dispatch(FileOrDirectoryTaskOutput output) {
            Path dest = output.getDestination().toPath();
            if (Files.exists(dest, new LinkOption[0])) {
                this.bufferLocation = Files.isDirectory(dest, new LinkOption[0]) ? dest : dest.getParent();
            }
        }
    }
}

