/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox.component;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.sejda.impl.sambox.component.OutlineItem;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.pdmodel.PDDocument;
import org.sejda.sambox.pdmodel.PDDocumentCatalog;
import org.sejda.sambox.pdmodel.PDPage;
import org.sejda.sambox.pdmodel.interactive.action.PDAction;
import org.sejda.sambox.pdmodel.interactive.action.PDActionGoTo;
import org.sejda.sambox.pdmodel.interactive.documentnavigation.destination.PDDestination;
import org.sejda.sambox.pdmodel.interactive.documentnavigation.destination.PDNamedDestination;
import org.sejda.sambox.pdmodel.interactive.documentnavigation.destination.PDPageDestination;
import org.sejda.sambox.pdmodel.interactive.documentnavigation.destination.PDPageXYZDestination;
import org.sejda.sambox.pdmodel.interactive.documentnavigation.outline.PDOutlineItem;
import org.sejda.sambox.pdmodel.interactive.documentnavigation.outline.PDOutlineNode;
import org.sejda.util.RequireUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OutlineUtils {
    private static final Logger LOG = LoggerFactory.getLogger(OutlineUtils.class);

    private OutlineUtils() {
    }

    public static Set<Integer> getOutlineLevelsWithPageDestination(PDDocument document) {
        return OutlineUtils.getFlatOutline(document).stream().map(i -> i.level).collect(Collectors.toSet());
    }

    public static Optional<PDPageDestination> toPageDestination(PDOutlineItem current, PDDocumentCatalog catalog) {
        try {
            PDAction outlineAction;
            PDDestination dest = current.getDestination();
            if (dest == null && (outlineAction = current.getAction()) instanceof PDActionGoTo) {
                dest = ((PDActionGoTo)outlineAction).getDestination();
            }
            if (dest instanceof PDNamedDestination && catalog != null) {
                dest = catalog.findNamedDestinationPage((PDNamedDestination)dest);
            }
            if (dest instanceof PDPageDestination) {
                return Optional.of((PDPageDestination)dest);
            }
        }
        catch (IOException e) {
            LOG.warn("Unable to get outline item destination ", (Throwable)e);
        }
        return Optional.empty();
    }

    public static PDPageDestination clonePageDestination(PDPageDestination dest, PDPage destPage) {
        RequireUtils.requireNotNullArg((Object)dest, (String)"Cannot clone a null destination");
        try {
            PDDestination clonedDestination = PDDestination.create((COSBase)dest.getCOSObject().duplicate());
            if (clonedDestination instanceof PDPageDestination) {
                ((PDPageDestination)clonedDestination).setPage(destPage);
                return (PDPageDestination)clonedDestination;
            }
        }
        catch (IOException e) {
            LOG.warn("Unable to clone page destination", (Throwable)e);
        }
        PDPageXYZDestination ret = new PDPageXYZDestination();
        ret.setPage(destPage);
        return ret;
    }

    public static void copyOutlineDictionary(PDOutlineItem from, PDOutlineItem to) {
        to.setTitle(StringUtils.defaultString((String)from.getTitle()));
        to.setTextColor(from.getTextColor());
        to.setBold(from.isBold());
        to.setItalic(from.isItalic());
        if (from.isNodeOpen()) {
            to.openNode();
        } else {
            to.closeNode();
        }
    }

    public static List<OutlineItem> getFlatOutline(PDDocument document) {
        return Optional.ofNullable(document.getDocumentCatalog().getDocumentOutline()).map(PDOutlineNode::children).map(c -> OutlineUtils.recurseFlatOutline(document, c, 1)).orElseGet(ArrayList::new).stream().sorted(Comparator.comparingInt(i -> i.page)).filter(i -> i.page > 0).collect(Collectors.toList());
    }

    private static List<OutlineItem> recurseFlatOutline(PDDocument document, Iterable<PDOutlineItem> items, int level) {
        ArrayList<OutlineItem> result = new ArrayList<OutlineItem>();
        for (PDOutlineItem item : items) {
            OutlineUtils.toPageDestination(item, document.getDocumentCatalog()).ifPresent(d -> {
                PDPageXYZDestination xyzPageDest;
                int pageNumber = Optional.ofNullable(d.getPage()).map(p -> document.getPages().indexOf(p) + 1).orElseGet(() -> d.getPageNumber() + 1);
                boolean specificLocationInPage = false;
                if (d instanceof PDPageXYZDestination && (xyzPageDest = (PDPageXYZDestination)d).getPage() != null) {
                    specificLocationInPage = xyzPageDest.getTop() != (int)xyzPageDest.getPage().getCropBox().getHeight();
                }
                result.add(new OutlineItem(item.getTitle(), pageNumber, level, specificLocationInPage));
            });
            result.addAll(OutlineUtils.recurseFlatOutline(document, item.children(), level + 1));
        }
        return result;
    }
}

