/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox;

import java.io.Closeable;
import java.io.File;
import org.sejda.common.ComponentsUtility;
import org.sejda.core.notification.dsl.ApplicationEventsNotifier;
import org.sejda.core.support.io.IOUtils;
import org.sejda.core.support.io.MultipleOutputWriter;
import org.sejda.core.support.io.OutputWriters;
import org.sejda.core.support.io.model.FileOutput;
import org.sejda.core.support.prefix.NameGenerator;
import org.sejda.core.support.prefix.model.NameGenerationRequest;
import org.sejda.impl.sambox.component.DefaultPdfSourceOpener;
import org.sejda.impl.sambox.component.PDDocumentHandler;
import org.sejda.impl.sambox.util.ViewerPreferencesUtils;
import org.sejda.model.exception.TaskException;
import org.sejda.model.input.PdfSource;
import org.sejda.model.input.PdfSourceOpener;
import org.sejda.model.output.ExistingOutputPolicy;
import org.sejda.model.output.TaskOutput;
import org.sejda.model.output.TaskOutputDispatcher;
import org.sejda.model.parameter.ViewerPreferencesParameters;
import org.sejda.model.parameter.base.TaskParameters;
import org.sejda.model.task.BaseTask;
import org.sejda.model.task.NotifiableTaskMetadata;
import org.sejda.model.task.TaskExecutionContext;
import org.sejda.sambox.pdmodel.interactive.viewerpreferences.PDViewerPreferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewerPreferencesTask
extends BaseTask<ViewerPreferencesParameters> {
    private static final Logger LOG = LoggerFactory.getLogger(ViewerPreferencesTask.class);
    private PDDocumentHandler documentHandler = null;
    private int totalSteps;
    private MultipleOutputWriter outputWriter;
    private PdfSourceOpener<PDDocumentHandler> documentLoader;

    public void before(ViewerPreferencesParameters parameters, TaskExecutionContext executionContext) throws TaskException {
        super.before((TaskParameters)parameters, executionContext);
        this.totalSteps = parameters.getSourceList().size();
        this.documentLoader = new DefaultPdfSourceOpener();
        this.outputWriter = OutputWriters.newMultipleOutputWriter((ExistingOutputPolicy)parameters.getExistingOutputPolicy(), (TaskExecutionContext)executionContext);
    }

    public void execute(ViewerPreferencesParameters parameters) throws TaskException {
        int currentStep = 0;
        for (PdfSource source : parameters.getSourceList()) {
            this.executionContext().assertTaskNotCancelled();
            ++currentStep;
            LOG.debug("Opening {}", (Object)source);
            this.documentHandler = (PDDocumentHandler)source.open(this.documentLoader);
            this.documentHandler.setCreatorOnPDDocument();
            File tmpFile = IOUtils.createTemporaryBuffer((TaskOutput)parameters.getOutput());
            LOG.debug("Created output on temporary buffer {}", (Object)tmpFile);
            this.documentHandler.setVersionOnPDDocument(parameters.getVersion());
            this.documentHandler.setCompress(parameters.isCompress());
            this.documentHandler.setPageModeOnDocument(parameters.getPageMode());
            this.documentHandler.setPageLayoutOnDocument(parameters.getPageLayout());
            this.setViewerPreferences(parameters);
            this.documentHandler.savePDDocument(tmpFile);
            String outName = NameGenerator.nameGenerator((String)parameters.getOutputPrefix()).generate(NameGenerationRequest.nameRequest().originalName(source.getName()).fileNumber(currentStep));
            this.outputWriter.addOutput(FileOutput.file((File)tmpFile).name(outName));
            ComponentsUtility.nullSafeCloseQuietly((Closeable)this.documentHandler);
            ApplicationEventsNotifier.notifyEvent((NotifiableTaskMetadata)this.executionContext().notifiableTaskMetadata()).stepsCompleted(currentStep).outOf(this.totalSteps);
        }
        parameters.getOutput().accept((TaskOutputDispatcher)this.outputWriter);
        LOG.debug("Viewer preferences set on input documents and written to {}", (Object)parameters.getOutput());
    }

    private void setViewerPreferences(ViewerPreferencesParameters parameters) throws TaskException {
        PDViewerPreferences preferences = this.documentHandler.getViewerPreferences();
        ViewerPreferencesUtils.setBooleanPreferences(preferences, parameters.getEnabledPreferences());
        if (parameters.getDirection() != null) {
            PDViewerPreferences.READING_DIRECTION direction = ViewerPreferencesUtils.getDirection(parameters.getDirection());
            preferences.setReadingDirection(direction);
            LOG.trace("Direction set to '{}'", (Object)direction);
        }
        if (parameters.getDuplex() != null) {
            PDViewerPreferences.DUPLEX duplex = ViewerPreferencesUtils.getDuplex(parameters.getDuplex());
            preferences.setDuplex(duplex);
            LOG.trace("Duplex set to '{}'", (Object)duplex);
        }
        if (parameters.getPrintScaling() != null) {
            PDViewerPreferences.PRINT_SCALING printScaling = ViewerPreferencesUtils.getPrintScaling(parameters.getPrintScaling());
            preferences.setPrintScaling(printScaling);
            LOG.trace("PrintScaling set to '{}'", (Object)printScaling);
        }
        PDViewerPreferences.NON_FULL_SCREEN_PAGE_MODE nfsMode = ViewerPreferencesUtils.getNFSMode(parameters.getNfsMode());
        preferences.setNonFullScreenPageMode(nfsMode);
        LOG.trace("Non full screen mode set to '{}'", (Object)nfsMode);
        this.documentHandler.setViewerPreferences(preferences);
    }

    public void after() {
        ComponentsUtility.nullSafeCloseQuietly((Closeable)this.documentHandler);
    }
}

