/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.languages;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.event.EventListenerList;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;

public class Highlighting {
    private static Map<Document, WeakReference<Highlighting>> highlightings = new WeakHashMap<Document, WeakReference<Highlighting>>();
    private Document document;
    private EventListenerList listeners;
    private Set<Highlight> items = new HashSet<Highlight>();

    public static Highlighting getHighlighting(Document document) {
        Highlighting highlighting;
        WeakReference<Highlighting> wr = highlightings.get(document);
        Highlighting highlighting2 = highlighting = wr == null ? null : (Highlighting)wr.get();
        if (highlighting == null) {
            highlighting = new Highlighting(document);
            highlightings.put(document, new WeakReference<Highlighting>(highlighting));
        }
        return highlighting;
    }

    private Highlighting(Document document) {
        this.document = document;
    }

    public AttributeSet get(int start, int end) {
        Highlight highlight = this.getHighlight(start, end);
        if (highlight == null) {
            return null;
        }
        return highlight.attributeSet;
    }

    private Highlight getHighlight(int start, int end) {
        for (Highlight item : this.items) {
            if (item.start.getOffset() != start || item.end.getOffset() != end) continue;
            return item;
        }
        return null;
    }

    public Highlight highlight(int startOffset, int endOffset, AttributeSet as) {
        try {
            Highlight result = new Highlight(this.document.createPosition(startOffset), this.document.createPosition(endOffset), as);
            this.items.add(result);
            this.fire(startOffset, endOffset);
            return result;
        }
        catch (BadLocationException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        if (this.listeners == null) {
            this.listeners = new EventListenerList();
        }
        this.listeners.add(PropertyChangeListener.class, l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(PropertyChangeListener.class, l);
    }

    protected void fire(int startOffset, int endOffset) {
        if (this.listeners == null) {
            return;
        }
        Object[] l = this.listeners.getListenerList();
        PropertyChangeEvent event = null;
        for (int i = l.length - 2; i >= 0; i -= 2) {
            if (event == null) {
                event = new PropertyChangeEvent(this, null, startOffset, endOffset);
            }
            ((PropertyChangeListener)l[i + 1]).propertyChange(event);
        }
    }

    public class Highlight {
        private Position start;
        private Position end;
        private AttributeSet attributeSet;

        private Highlight(Position start, Position end, AttributeSet attributeSet) {
            this.start = start;
            this.end = end;
            this.attributeSet = attributeSet;
        }

        public void remove() {
            Highlighting.this.items.remove(this);
            Highlighting.this.fire(this.start.getOffset(), this.end.getOffset());
        }
    }
}

