/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.server;

import org.netbeans.lib.profiler.server.ProfilerRuntime;
import org.netbeans.lib.profiler.server.ThreadInfo;
import org.netbeans.lib.profiler.server.system.Timers;

public class ProfilerRuntimeCPUCodeRegion
extends ProfilerRuntime {
    protected static long[] codeRegionResults = new long[0];
    protected static int newBufSize;
    protected static int bufSize;
    protected static int curIdx;
    protected static long invCount;
    protected static boolean codeRegionInstrumentationDisabled;

    public static void setCPUResBufSize(int size) {
        newBufSize = size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long[] getProfilingResults() {
        long[] lArray = codeRegionResults;
        synchronized (codeRegionResults) {
            int size = invCount < (long)bufSize ? (int)invCount : bufSize;
            long[] res = new long[++size];
            res[0] = (int)invCount;
            if (invCount < (long)bufSize) {
                System.arraycopy(codeRegionResults, 0, res, 1, (int)invCount);
            } else {
                System.arraycopy(codeRegionResults, curIdx, res, 1, bufSize - curIdx);
                System.arraycopy(codeRegionResults, 0, res, bufSize - curIdx + 1, curIdx);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return res;
        }
    }

    public static void codeRegionEntry() {
        if (codeRegionInstrumentationDisabled) {
            return;
        }
        ThreadInfo ti = ThreadInfo.getThreadInfo();
        if (!ti.isInitialized()) {
            ti.initialize();
        }
        ti.inCallGraph = true;
        ti.absEntryTime = Timers.getCurrentTimeInCounts();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void codeRegionExit() {
        if (codeRegionInstrumentationDisabled) {
            return;
        }
        long time = Timers.getCurrentTimeInCounts();
        ThreadInfo ti = ThreadInfo.getThreadInfo();
        if (!ti.isInitialized() || !ti.inCallGraph) {
            return;
        }
        time -= ti.absEntryTime;
        long[] lArray = codeRegionResults;
        synchronized (codeRegionResults) {
            ProfilerRuntimeCPUCodeRegion.codeRegionResults[ProfilerRuntimeCPUCodeRegion.curIdx++] = time;
            ++invCount;
            if (curIdx == bufSize) {
                curIdx = 0;
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            ti.inCallGraph = false;
            return;
        }
    }

    public static void enableProfiling(boolean v) {
        if (v) {
            ProfilerRuntimeCPUCodeRegion.createNewDataStructures();
            codeRegionInstrumentationDisabled = false;
        } else {
            codeRegionInstrumentationDisabled = true;
            ProfilerRuntimeCPUCodeRegion.clearDataStructures();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetProfilerCollectors() {
        long[] lArray = codeRegionResults;
        synchronized (codeRegionResults) {
            bufSize = newBufSize;
            codeRegionResults = new long[bufSize];
            invCount = 0L;
            curIdx = 0;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void clearDataStructures() {
        ProfilerRuntime.clearDataStructures();
        long[] lArray = codeRegionResults;
        synchronized (codeRegionResults) {
            codeRegionResults = new long[0];
            invCount = 0L;
            curIdx = 0;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    protected static long monitorEntryRegion(Thread t, Object monitor, ThreadInfo ownerTi) {
        if (codeRegionInstrumentationDisabled) {
            return -1L;
        }
        ThreadInfo ti = ThreadInfo.getThreadInfo();
        if (!ti.isInitialized() || !ti.inCallGraph) {
            return -1L;
        }
        ti.lastWaitStartTime = Timers.getCurrentTimeInCounts();
        return ti.lastWaitStartTime;
    }

    protected static long monitorExitRegion(Thread t, Object monitor) {
        if (codeRegionInstrumentationDisabled) {
            return -1L;
        }
        ThreadInfo ti = ThreadInfo.getThreadInfo();
        if (ti == null || !ti.inCallGraph) {
            return -1L;
        }
        long timeStamp = Timers.getCurrentTimeInCounts();
        ti.absEntryTime += timeStamp - ti.lastWaitStartTime;
        return timeStamp;
    }

    protected static void sleepEntryRegion() {
        if (codeRegionInstrumentationDisabled) {
            return;
        }
        ThreadInfo ti = ThreadInfo.getThreadInfo();
        if (!ti.isInitialized() || !ti.inCallGraph) {
            return;
        }
        ti.lastWaitStartTime = Timers.getCurrentTimeInCounts();
    }

    protected static void sleepExitRegion() {
        if (codeRegionInstrumentationDisabled) {
            return;
        }
        ThreadInfo ti = ThreadInfo.getThreadInfo();
        if (!ti.isInitialized() || !ti.inCallGraph) {
            return;
        }
        ti.absEntryTime += Timers.getCurrentTimeInCounts() - ti.lastWaitStartTime;
    }

    protected static void waitEntryRegion() {
        if (codeRegionInstrumentationDisabled) {
            return;
        }
        ThreadInfo ti = ThreadInfo.getThreadInfo();
        if (!ti.isInitialized() || !ti.inCallGraph) {
            return;
        }
        ti.lastWaitStartTime = Timers.getCurrentTimeInCounts();
    }

    protected static void waitExitRegion() {
        if (codeRegionInstrumentationDisabled) {
            return;
        }
        ThreadInfo ti = ThreadInfo.getThreadInfo();
        if (!ti.isInitialized() || !ti.inCallGraph) {
            return;
        }
        ti.absEntryTime += Timers.getCurrentTimeInCounts() - ti.lastWaitStartTime;
    }

    protected static void parkEntryRegion() {
        if (codeRegionInstrumentationDisabled) {
            return;
        }
        ThreadInfo ti = ThreadInfo.getThreadInfo();
        if (!ti.isInitialized() || !ti.inCallGraph) {
            return;
        }
        ti.lastWaitStartTime = Timers.getCurrentTimeInCounts();
    }

    protected static void parkExitRegion() {
        if (codeRegionInstrumentationDisabled) {
            return;
        }
        ThreadInfo ti = ThreadInfo.getThreadInfo();
        if (!ti.isInitialized() || !ti.inCallGraph) {
            return;
        }
        ti.absEntryTime += Timers.getCurrentTimeInCounts() - ti.lastWaitStartTime;
    }
}

