/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.platform.api;

import java.io.File;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.modules.javafx2.platform.api.JavaFxRuntimeInclusion;
import org.openide.filesystems.FileObject;

public final class JavaFXPlatformUtils {
    public static final String PLATFORM_ANT_NAME = "platform.ant.name";
    public static final String DEFAULT_PLATFORM = "default_platform";
    public static final String DEFAULT_JAVAFX_PLATFORM = "Default_JavaFX_Platform";
    public static final String JAVAFX_CLASSPATH_EXTENSION = "javafx.classpath.extension";
    private static final String JAVADOC_ONLINE_URL = "http://docs.oracle.com/javafx/2/api/";
    private static final String JFXRT_JAR_NAME = "jfxrt.jar";
    private static final String[] JFXRT_RELATIVE_LOCATIONS = new String[]{"lib", "lib" + File.separatorChar + "ext"};
    private static final String[] JRE_RELATIVE_LOCATIONS = new String[]{"jre"};

    private JavaFXPlatformUtils() {
    }

    public static boolean isJavaFXEnabled(@NullAllowed JavaPlatform platform) {
        if (platform == null) {
            return false;
        }
        return JavaFxRuntimeInclusion.forPlatform(platform).isSupported();
    }

    public static boolean isThereAnyJavaFXPlatform() {
        JavaPlatform[] platforms;
        for (JavaPlatform javaPlatform : platforms = JavaPlatformManager.getDefault().getInstalledPlatforms()) {
            if (!JavaFXPlatformUtils.isJavaFXEnabled(javaPlatform)) continue;
            return true;
        }
        return false;
    }

    public static JavaPlatform findJavaFXPlatform() {
        JavaPlatform[] platforms;
        JavaPlatform defaultPlatform = JavaPlatformManager.getDefault().getDefaultPlatform();
        if (JavaFXPlatformUtils.isJavaFXEnabled(defaultPlatform)) {
            return defaultPlatform;
        }
        for (JavaPlatform javaPlatform : platforms = JavaPlatformManager.getDefault().getInstalledPlatforms()) {
            if (javaPlatform.equals(defaultPlatform) || !JavaFXPlatformUtils.isJavaFXEnabled(javaPlatform)) continue;
            return javaPlatform;
        }
        return null;
    }

    public static String getPlatformAntName(@NonNull JavaPlatform platform) {
        return (String)platform.getProperties().get(PLATFORM_ANT_NAME);
    }

    public static JavaPlatform findJavaPlatform(@NonNull String platformName) {
        JavaPlatform[] platforms;
        for (JavaPlatform javaPlatform : platforms = JavaPlatformManager.getDefault().getInstalledPlatforms()) {
            String antName = (String)javaPlatform.getProperties().get(PLATFORM_ANT_NAME);
            if (antName == null || !antName.equals(platformName)) continue;
            return javaPlatform;
        }
        return null;
    }

    public static String getClassPathExtensionProperty() {
        return "${javafx.classpath.extension}";
    }

    private static String getJavaFXRuntimeJar(@NonNull String root) {
        for (String rel : JFXRT_RELATIVE_LOCATIONS) {
            String path = root + File.separatorChar + rel + File.separatorChar + JFXRT_JAR_NAME;
            File jfxrt = new File(path);
            if (!jfxrt.exists()) continue;
            return path;
        }
        return null;
    }

    public static String getJavaFXRuntimeJar(@NonNull JavaPlatform platform) {
        for (FileObject root : platform.getInstallFolders()) {
            String result;
            if (!root.isFolder()) continue;
            for (String string : JRE_RELATIVE_LOCATIONS) {
                result = JavaFXPlatformUtils.getJavaFXRuntimeJar(root.getPath() + File.separatorChar + string);
                if (result == null) continue;
                return result;
            }
            for (String string : root.getChildren()) {
                if (!string.isFolder() || (result = JavaFXPlatformUtils.getJavaFXRuntimeJar(string.getPath())) == null) continue;
                return result;
            }
        }
        return null;
    }
}

