/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl.timeline;

import java.awt.Color;

final class TimelineColorFactory {
    private static final Color[] PREDEFINED_COLORS = new Color[]{new Color(241, 154, 42), new Color(32, 171, 217), new Color(144, 97, 207), new Color(158, 156, 0)};
    private static final Color[][] PREDEFINED_GRADIENTS = new Color[][]{{new Color(245, 204, 152), new Color(255, 243, 226)}, {new Color(151, 223, 246), new Color(227, 248, 255)}, {new Color(200, 163, 248), new Color(242, 232, 255)}, {new Color(212, 211, 131), new Color(244, 243, 217)}};

    TimelineColorFactory() {
    }

    private static Color getPredefinedColor(int index) {
        return PREDEFINED_COLORS[index];
    }

    static Color getColor(int index) {
        Color color;
        if (index >= PREDEFINED_COLORS.length) {
            color = TimelineColorFactory.getPredefinedColor(index % PREDEFINED_COLORS.length);
            int darkerFactor = index / PREDEFINED_COLORS.length;
            while (darkerFactor-- > 0) {
                color = color.darker();
            }
        } else {
            color = TimelineColorFactory.getPredefinedColor(index);
        }
        return color;
    }

    private static Color[] getPredefinedGradient(int index) {
        return PREDEFINED_GRADIENTS[index];
    }

    static Color[] getGradient(int index) {
        Color[] colors = null;
        if (index >= PREDEFINED_GRADIENTS.length) {
            colors = TimelineColorFactory.getPredefinedGradient(index % PREDEFINED_GRADIENTS.length);
            int darkerFactor = index / PREDEFINED_GRADIENTS.length;
            while (darkerFactor-- > 0) {
                colors[0] = colors[0].darker();
                colors[1] = colors[1].darker();
            }
        } else {
            colors = TimelineColorFactory.getPredefinedGradient(index);
        }
        return colors;
    }
}

