/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projectimport.eclipse.core.wizard;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.JComponent;
import org.netbeans.modules.projectimport.eclipse.core.EclipseUtils;
import org.netbeans.modules.projectimport.eclipse.core.wizard.ImporterWizardPanel;
import org.netbeans.modules.projectimport.eclipse.core.wizard.ProjectImporterWizard;
import org.netbeans.modules.projectimport.eclipse.core.wizard.SelectionPanel;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;

final class SelectionWizardPanel
extends ImporterWizardPanel
implements PropertyChangeListener,
WizardDescriptor.ValidatingPanel<WizardDescriptor> {
    private SelectionPanel panel = new SelectionPanel();

    SelectionWizardPanel() {
        this.panel.addPropertyChangeListener(this);
        this.initPanel(this.panel, 0);
    }

    public Component getComponent() {
        return this.panel;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propName = evt.getPropertyName();
        if ("errorMessage".equals(propName)) {
            this.setErrorMessage((String)evt.getNewValue());
        } else if ("workspaceChoosen".equals(propName)) {
            String[] steps = (Boolean)evt.getNewValue() != false ? new String[]{WORKSPACE_LOCATION_STEP, PROJECTS_SELECTION_STEP} : new String[]{PROJECT_SELECTION_STEP};
            this.panel.putClientProperty("WizardPanel_contentData", steps);
            this.setValid(this.isValid(), true);
        }
    }

    boolean isWorkspaceChosen() {
        return this.panel.isWorkspaceChosen();
    }

    String getProjectDir() {
        return this.panel.getProjectDir();
    }

    public String getProjectDestinationDir() {
        return this.panel.getProjectDestinationDir();
    }

    public File getWorkspaceDir() {
        return this.panel.getWorkspaceDir();
    }

    public void validate() throws WizardValidationException {
        if (!this.panel.isWorkspaceChosen()) {
            String dest = this.getProjectDestinationDir();
            String message = null;
            if (!(dest == null || new File(dest).isAbsolute() && EclipseUtils.isWritable(dest))) {
                message = ProjectImporterWizard.getMessage("MSG_CannotCreateProjectInFolder", dest);
            } else if (!EclipseUtils.isRegularProject(this.getProjectDir())) {
                message = ProjectImporterWizard.getMessage("MSG_CannotImportNonJavaProject");
            }
            if (message != null) {
                this.setErrorMessage(message);
                throw new WizardValidationException((JComponent)this.panel, message, null);
            }
        }
    }
}

