/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.loader;

import java.io.File;
import java.io.FilenameFilter;

public class SimpleFileFilter
implements FilenameFilter {
    private String[] extensions;

    public SimpleFileFilter(String ext) {
        this(new String[]{ext});
    }

    public SimpleFileFilter(String[] exts) {
        this.extensions = new String[exts.length];
        int i = 0;
        while (i < exts.length) {
            this.extensions[i] = exts[i].toLowerCase();
            ++i;
        }
    }

    public boolean accept(File dir, String _name) {
        String name = _name.toLowerCase();
        int i = 0;
        while (i < this.extensions.length) {
            if (name.endsWith(this.extensions[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String[] fileOrFiles(File f) {
        if (f == null) {
            return null;
        }
        File parent = new File(f.getParent());
        String fname = f.getName();
        if (fname.charAt(0) == '*') {
            String filter = fname.substring(1, fname.length());
            String[] files = parent.list(new SimpleFileFilter(filter));
            return files;
        }
        String[] files = new String[]{f.getPath()};
        return files;
    }
}

