/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.testng.ant;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.project.classpath.ProjectClassPathModifier;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.java.testrunner.JavaUtils;
import org.netbeans.modules.testng.api.TestNGSupport;
import org.netbeans.modules.testng.spi.TestConfig;
import org.netbeans.modules.testng.spi.TestNGSupportImplementation;
import org.netbeans.spi.project.ant.AntArtifactProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class AntTestNGSupport
extends TestNGSupportImplementation {
    private static final Logger LOGGER = Logger.getLogger(AntTestNGSupport.class.getName());
    private static final Set<TestNGSupport.Action> SUPPORTED_ACTIONS;

    public boolean isSupportEnabled(FileObject[] activatedFOs) {
        return JavaUtils.isSupportEnabled(AntArtifactProvider.class, (FileObject[])activatedFOs);
    }

    public boolean isActionSupported(TestNGSupport.Action action, Project p) {
        return p != null && p.getLookup().lookup(AntArtifactProvider.class) != null && SUPPORTED_ACTIONS.contains(action);
    }

    public void configureProject(FileObject createdFile) {
        assert (createdFile != null);
        Project p = FileOwnerQuery.getOwner((FileObject)createdFile);
        ClassPath cp = ClassPath.getClassPath((FileObject)createdFile, (String)"classpath/compile");
        FileObject ng = cp.findResource("org.testng.annotations.Test");
        if (ng == null) {
            Library nglib = LibraryManager.getDefault().getLibrary("testng");
            try {
                if (!ProjectClassPathModifier.addLibraries((Library[])new Library[]{nglib}, (FileObject)createdFile, (String)"classpath/compile")) {
                    LOGGER.log(Level.FINE, "TestNG library not added to project {0}", p);
                }
            }
            catch (IOException ex) {
                Logger.getLogger(AntTestNGSupport.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (UnsupportedOperationException ex) {
                Logger.getLogger(AntTestNGSupport.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public TestNGSupportImplementation.TestExecutor createExecutor(Project p) {
        return new AntExecutor(p);
    }

    static {
        HashSet<TestNGSupport.Action> s = new HashSet<TestNGSupport.Action>();
        s.add(TestNGSupport.Action.RUN_TESTSUITE);
        s.add(TestNGSupport.Action.DEBUG_TESTSUITE);
        SUPPORTED_ACTIONS = Collections.unmodifiableSet(s);
    }

    private static class AntExecutor
    implements TestNGSupportImplementation.TestExecutor {
        private static final String failedConfPath = "build/test/results/testng-failed.xml";
        private Project p;

        public AntExecutor(Project p) {
            this.p = p;
        }

        public boolean hasFailedTests() {
            FileObject projectHome = this.p.getProjectDirectory();
            FileUtil.refreshFor((File[])new File[]{FileUtil.toFile((FileObject)projectHome)});
            FileObject failedTestsConfig = projectHome.getFileObject(failedConfPath);
            return failedTestsConfig != null && failedTestsConfig.isValid();
        }

        public void execute(TestNGSupport.Action action, TestConfig config) throws IOException {
            String xml;
            FileObject projectHome = this.p.getProjectDirectory();
            Properties props = new Properties();
            String cmd = null;
            FileObject test = config.getTest();
            ClassPath classPath = ClassPath.getClassPath((FileObject)test, (String)"classpath/source");
            if (classPath == null) {
                LOGGER.log(Level.WARNING, "Could not find any classpath for file {0}", FileUtil.toFile((FileObject)test));
                return;
            }
            FileObject[] testRoots = classPath.getRoots();
            FileObject testRoot = null;
            for (FileObject root : testRoots) {
                if (!FileUtil.isParentOf((FileObject)root, (FileObject)test)) continue;
                testRoot = root;
                break;
            }
            if (TestNGSupport.Action.RUN_TESTSUITE.equals((Object)action)) {
                cmd = "test-single";
                xml = FileUtil.getRelativePath(testRoot, (FileObject)test);
                assert (xml != null);
                props.put("test.includes", xml);
                if (this.isNbModuleProject()) {
                    props.setProperty("continue.after.failing.tests", "true");
                }
            } else if (TestNGSupport.Action.DEBUG_TESTSUITE.equals((Object)action)) {
                if (this.isNbModuleProject()) {
                    cmd = "debug-test-single-nb";
                    xml = FileUtil.getRelativePath((FileObject)testRoot, (FileObject)test);
                    assert (xml != null);
                    props.put("test.class", xml);
                    props.setProperty("continue.after.failing.tests", "true");
                } else {
                    cmd = "debug-test";
                    props.put("test.class", "'".concat(FileUtil.toFile((FileObject)test).getAbsolutePath()).concat("'"));
                }
            } else if (TestNGSupport.Action.RUN_TESTMETHOD.equals((Object)action)) {
                if (this.isNbModuleProject()) {
                    cmd = "test-method";
                    props.put("test.class", config.getPackageName() + "." + config.getClassName());
                    props.put("test.methods", config.getMethodName());
                    props.setProperty("continue.after.failing.tests", "true");
                } else {
                    cmd = "test-single-method";
                    props.put("test.class", config.getPackageName() + "." + config.getClassName());
                    props.put("test.method", config.getMethodName());
                }
            } else if (TestNGSupport.Action.DEBUG_TESTMETHOD.equals((Object)action)) {
                if (this.isNbModuleProject()) {
                    cmd = "debug-test-single-nb";
                    props.put("test.class", config.getPackageName() + "." + config.getClassName());
                    props.put("test.methods", config.getMethodName());
                    props.setProperty("continue.after.failing.tests", "true");
                } else {
                    cmd = "debug-test-method";
                    props.put("test.class", config.getPackageName() + "." + config.getClassName());
                    props.put("test.method", config.getMethodName());
                }
            }
            assert (cmd != null) : "Unsupported action: " + action;
            props.put("javac.includes", ActionUtils.antIncludesList((FileObject[])new FileObject[]{testRoot}, (FileObject)testRoot, (boolean)true));
            props.setProperty("ignore.failing.tests", "true");
            FileObject buildFO = projectHome.getFileObject("build.xml");
            if (buildFO == null) {
                LOGGER.log(Level.WARNING, "Could not locate build.xml for project in {0}", projectHome);
                return;
            }
            ActionUtils.runTarget((FileObject)buildFO, (String[])new String[]{cmd}, (Properties)props);
        }

        private boolean isNbModuleProject() {
            return this.p.getLookup().lookup(AntTestNGSupportProjectServiceProvider.class) != null;
        }

        public static class AntTestNGSupportProjectServiceProvider {
            public AntTestNGSupportProjectServiceProvider(Project p) {
            }
        }
    }
}

