/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nbform;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.SourcePositions;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.RepaintManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.fold.Fold;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.api.editor.fold.FoldHierarchyEvent;
import org.netbeans.api.editor.fold.FoldUtilities;
import org.netbeans.api.editor.guards.GuardedSectionManager;
import org.netbeans.api.editor.guards.SimpleSection;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CodeStyle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.core.api.multiview.MultiViewHandler;
import org.netbeans.core.api.multiview.MultiViews;
import org.netbeans.core.spi.multiview.CloseOperationState;
import org.netbeans.core.spi.multiview.MultiViewElementCallback;
import org.netbeans.core.spi.multiview.MultiViewFactory;
import org.netbeans.core.spi.multiview.text.MultiViewEditorElement;
import org.netbeans.modules.form.CodeGenerator;
import org.netbeans.modules.form.EditorSupport;
import org.netbeans.modules.form.FormDataObject;
import org.netbeans.modules.form.FormDesigner;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.PersistenceException;
import org.netbeans.modules.form.project.ClassPathUtils;
import org.netbeans.modules.form.project.ClassSource;
import org.netbeans.modules.nbform.Bundle;
import org.netbeans.modules.nbform.FormDesignerTC;
import org.netbeans.modules.nbform.project.ClassSourceResolver;
import org.netbeans.spi.editor.guards.GuardedEditorSupport;
import org.netbeans.spi.editor.guards.GuardedSectionsFactory;
import org.netbeans.spi.editor.guards.GuardedSectionsProvider;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.awt.StatusDisplayer;
import org.openide.awt.UndoRedo;
import org.openide.cookies.CloseCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.PrintCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileStatusListener;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataObject;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAdapter;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeOp;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.DataEditorSupport;
import org.openide.text.PositionRef;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.Task;
import org.openide.util.UserQuestionException;
import org.openide.windows.CloneableOpenSupport;
import org.openide.windows.CloneableTopComponent;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.TopComponentGroup;
import org.openide.windows.WindowManager;
import org.openide.xml.XMLUtil;

public final class FormEditorSupport
extends DataEditorSupport
implements EditorSupport,
EditorCookie.Observable,
CloseCookie,
PrintCookie {
    static final String MV_FORM_ID = "form";
    private static final String MV_JAVA_ID = "java";
    private static final int JAVA_ELEMENT_INDEX = 0;
    private static final int FORM_ELEMENT_INDEX = 2;
    private int elementToOpen;
    static final String iconURL = "org/netbeans/modules/form/resources/form.gif";
    private FormDataObject formDataObject;
    private CloneableTopComponent multiviewTC;
    private NodeListener nodeListener;
    private static PropertyChangeListener topcompsListener;
    private FoldHierarchyListener foldHierarchyListener;
    private UndoRedo.Manager editorUndoManager;
    private FormEditor formEditor;
    private static final Set<FormEditorSupport> opened;
    private static Map<FileSystem, FileStatusListener> fsToStatusListener;
    private boolean saving;
    private static Boolean groupVisible;
    private FormGEditor guardedEditor;
    private GuardedSectionsProvider guardedProvider;
    private final SaveCookie saveCookie = new SaveCookie(){

        public void save() throws IOException {
            if (FormEditorSupport.this.formEditor == null) {
                this.doSave(false);
            } else if (EventQueue.isDispatchThread()) {
                this.doSave(true);
            } else {
                try {
                    EventQueue.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            this.doSave(true);
                        }
                    });
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(FormEditorSupport.class.getName()).log(Level.INFO, "", ex);
                }
                catch (InvocationTargetException ex) {
                    if (ex.getCause() instanceof RuntimeException) {
                        throw (RuntimeException)ex.getCause();
                    }
                    Logger.getLogger(FormEditorSupport.class.getName()).log(Level.INFO, "", ex);
                }
            }
        }

        private void doSave(boolean bothJavaAndForm) {
            try {
                if (bothJavaAndForm) {
                    FormEditorSupport.this.saveDocument();
                } else {
                    FormEditorSupport.this.saveSourceOnly();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(FormEditorSupport.class.getName()).log(Level.INFO, "", ex);
            }
        }
    };
    private final CookieSet cookies;

    public FormEditorSupport(FormDataObject formDataObject) {
        super((DataObject)formDataObject, formDataObject.getLookup(), (CloneableEditorSupport.Env)new Environment((DataObject)formDataObject));
        this.setMIMEType("text/x-java");
        this.formDataObject = formDataObject;
        this.cookies = formDataObject.getCookies();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openFormEditor(boolean forceFormElement) {
        boolean switchToForm;
        boolean alreadyOpened = opened.contains((Object)this);
        boolean bl = switchToForm = forceFormElement || !alreadyOpened;
        if (switchToForm) {
            this.elementToOpen = 2;
        }
        long ms = System.currentTimeMillis();
        try {
            this.showOpeningStatus("FMT_PreparingForm");
            this.multiviewTC = this.openCloneableTopComponent();
            this.multiviewTC.requestActive();
            this.registerNodeListener();
            if (switchToForm) {
                MultiViewHandler handler = MultiViews.findMultiViewHandler((TopComponent)this.multiviewTC);
                handler.requestActive(handler.getPerspectives()[2]);
            }
        }
        finally {
            this.hideOpeningStatus();
        }
        Logger.getLogger(FormEditor.class.getName()).log(Level.FINER, "Opening form time 1: {0}ms", System.currentTimeMillis() - ms);
    }

    private void registerNodeListener() {
        if (this.formDataObject.isValid()) {
            Node node = this.formDataObject.getNodeDelegate();
            this.multiviewTC.setIcon(node.getIcon(1));
            if (this.nodeListener == null) {
                NodeAdapter listener = new NodeAdapter(){

                    public void propertyChange(final PropertyChangeEvent ev) {
                        Mutex.EVENT.writeAccess(new Runnable(){

                            @Override
                            public void run() {
                                if ("icon".equals(ev.getPropertyName()) && FormEditorSupport.this.formDataObject.isValid() && FormEditorSupport.this.multiviewTC != null) {
                                    FormEditorSupport.this.multiviewTC.setIcon(FormEditorSupport.this.formDataObject.getNodeDelegate().getIcon(1));
                                }
                            }
                        });
                    }
                };
                node.addNodeListener(NodeOp.weakNodeListener((NodeListener)listener, (Object)node));
                this.nodeListener = listener;
            }
        }
    }

    void showOpeningStatus(String fmtMessage) {
        JFrame mainWin = (JFrame)WindowManager.getDefault().getMainWindow();
        mainWin.getGlassPane().setCursor(Cursor.getPredefinedCursor(3));
        mainWin.getGlassPane().setVisible(true);
        StatusDisplayer.getDefault().setStatusText(FormUtils.getFormattedBundleString((String)fmtMessage, (Object[])new Object[]{this.formDataObject.getFormFile().getName()}));
        RepaintManager.currentManager(mainWin).paintDirtyRegions();
    }

    void hideOpeningStatus() {
        JFrame mainWin = (JFrame)WindowManager.getDefault().getMainWindow();
        mainWin.getGlassPane().setVisible(false);
        mainWin.getGlassPane().setCursor(null);
        StatusDisplayer.getDefault().setStatusText("");
    }

    private void addStatusListener(FileSystem fs) {
        FileStatusListener fsl = fsToStatusListener.get(fs);
        if (fsl == null) {
            fsl = new FileStatusListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void annotationChanged(FileStatusEvent ev) {
                    Set set = opened;
                    synchronized (set) {
                        for (FormEditorSupport fes : opened) {
                            if (!ev.hasChanged(fes.getFormDataObject().getPrimaryFile()) && !ev.hasChanged(fes.getFormDataObject().getFormFile())) continue;
                            fes.updateMVTCDisplayName();
                        }
                    }
                }
            };
            fs.addFileStatusListener(fsl);
            fsToStatusListener.put(fs, fsl);
        }
    }

    private static void detachStatusListeners() {
        for (Map.Entry<FileSystem, FileStatusListener> entry : fsToStatusListener.entrySet()) {
            FileSystem fs = entry.getKey();
            FileStatusListener fsl = entry.getValue();
            fs.removeFileStatusListener(fsl);
        }
        fsToStatusListener.clear();
    }

    void selectJavaEditor() {
        MultiViewHandler handler = MultiViews.findMultiViewHandler((TopComponent)this.multiviewTC);
        if (handler != null) {
            handler.requestActive(handler.getPerspectives()[0]);
        }
    }

    protected boolean asynchronousOpen() {
        return false;
    }

    public void openSource() {
        this.open();
    }

    public void openDesign() {
        if (EventQueue.isDispatchThread()) {
            this.openFormEditor(true);
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FormEditorSupport.this.openFormEditor(true);
                }
            });
        }
    }

    public void open() {
        if (EventQueue.isDispatchThread()) {
            this.openInAWT();
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FormEditorSupport.this.openInAWT();
                }
            });
        }
    }

    private void openInAWT() {
        if (!this.formDataObject.isValid()) {
            return;
        }
        if (Boolean.TRUE.equals(this.formDataObject.getPrimaryFile().getAttribute("nonEditableTemplate"))) {
            String pattern = FormUtils.getBundleString((String)"MSG_NonEditableTemplate");
            String message = MessageFormat.format(pattern, this.formDataObject.getNodeDelegate().getName());
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message));
            return;
        }
        this.elementToOpen = 0;
        super.open();
        MultiViewHandler handler = MultiViews.findMultiViewHandler((TopComponent)this.multiviewTC);
        if (handler != null) {
            handler.requestActive(handler.getPerspectives()[0]);
        }
    }

    public void openAt(PositionRef pos) {
        this.elementToOpen = 0;
        this.openCloneableTopComponent();
        MultiViewHandler handler = MultiViews.findMultiViewHandler((TopComponent)this.multiviewTC);
        handler.requestActive(handler.getPerspectives()[0]);
        this.openAt(pos, -1).getComponent().requestActive();
    }

    public void openAt(Position pos) {
        this.openAt(this.createPositionRef(pos.getOffset(), Position.Bias.Forward));
    }

    boolean startFormLoading() {
        if (!this.formEditor.prepareLoading()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (FormEditorSupport.this.formEditor != null) {
                        FormEditorSupport.this.reportErrors();
                        FormEditorSupport.this.selectJavaEditor();
                    }
                }
            });
            return false;
        }
        return true;
    }

    boolean loadOpeningForm() {
        this.showOpeningStatus("FMT_OpeningForm");
        this.postCreationUpdate1();
        boolean success = this.formEditor.loadFormData();
        this.postCreationUpdate2();
        this.hideOpeningStatus();
        this.reportErrors();
        if (!success) {
            this.selectJavaEditor();
        }
        return success;
    }

    public boolean loadForm() {
        return this.getFormEditor(true).loadForm();
    }

    public boolean isOpened() {
        return this.formEditor != null && this.formEditor.isFormLoaded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveDocument() throws IOException {
        IOException ioEx = null;
        try {
            if (this.formEditor != null) {
                this.formEditor.saveFormData();
            }
            this.saving = true;
            super.saveDocument();
        }
        catch (PersistenceException ex) {
            Throwable t = ex.getOriginalException();
            if (t instanceof IOException) {
                ioEx = (IOException)t;
            } else {
                ioEx = new IOException("Cannot save the form");
                ErrorManager.getDefault().annotate((Throwable)ioEx, t != null ? t : ex);
            }
        }
        finally {
            this.saving = false;
        }
        if (this.formEditor != null) {
            this.formEditor.reportSavingErrors();
        }
        if (ioEx != null) {
            throw ioEx;
        }
    }

    public void saveSourceOnly() throws IOException {
        try {
            this.saving = true;
            super.saveDocument();
        }
        finally {
            this.saving = false;
        }
    }

    private void reportErrors() {
        if (!this.formEditor.isFormLoaded()) {
            this.formEditor.reportLoadingErrors(null);
        } else {
            JButton viewButton = new JButton();
            Mnemonics.setLocalizedText((AbstractButton)viewButton, (String)FormUtils.getBundleString((String)"CTL_ViewOnly"));
            JButton editButton = new JButton();
            Mnemonics.setLocalizedText((AbstractButton)editButton, (String)FormUtils.getBundleString((String)"CTL_AllowEditing"));
            final Object[] options = new Object[]{viewButton, editButton, NotifyDescriptor.CANCEL_OPTION};
            final DialogDescriptor dd = this.formEditor.reportLoadingErrors(options);
            if (dd != null) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (FormEditorSupport.this.formEditor != null && !FormEditorSupport.this.formEditor.isFormLoaded()) {
                            return;
                        }
                        Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
                        if (dialog instanceof JDialog) {
                            ((JDialog)dialog).getContentPane().requestFocus();
                        }
                        dialog.setVisible(true);
                        dialog.dispose();
                        Object ret = dd.getValue();
                        if (ret == options[0]) {
                            FormEditorSupport.this.formEditor.setFormReadOnly();
                            FormEditorSupport.this.updateMVTCDisplayName();
                        } else if (ret == options[1]) {
                            FormEditorSupport.this.formEditor.destroyInvalidComponents();
                        } else {
                            FormEditorSupport.this.closeFormEditor();
                        }
                    }
                });
            }
        }
    }

    public final FormDataObject getFormDataObject() {
        return this.formDataObject;
    }

    public FormModel getFormModel() {
        FormEditor fe = this.getFormEditor();
        return fe == null ? null : fe.getFormModel();
    }

    public FormEditor getFormEditor() {
        return this.getFormEditor(false);
    }

    FormEditor getFormEditor(boolean initialize) {
        if (this.formEditor == null && initialize) {
            this.formEditor = new FormEditor(this.formDataObject, (EditorSupport)this);
        }
        return this.formEditor;
    }

    private FormDesignerTC getFormDesignerTC() {
        if (this.multiviewTC == null) {
            return null;
        }
        return (FormDesignerTC)((Object)this.multiviewTC.getClientProperty((Object)"formDesigner"));
    }

    public void markModified() {
        if (this.formEditor != null && this.formEditor.isFormLoaded() && !this.formDataObject.isModified()) {
            this.notifyModified();
        }
    }

    protected UndoRedo.Manager createUndoRedoManager() {
        this.editorUndoManager = super.createUndoRedoManager();
        return this.editorUndoManager;
    }

    public void discardEditorUndoableEdits() {
        if (this.editorUndoManager != null) {
            this.editorUndoManager.discardAllEdits();
        }
    }

    public void reloadForm() {
        if (this.canClose()) {
            this.reloadDocument();
        }
    }

    protected Task reloadDocument() {
        if (this.multiviewTC == null) {
            return super.reloadDocument();
        }
        Task docLoadTask = super.reloadDocument();
        if (this.saving) {
            return docLoadTask;
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FormDesignerTC designerTC = FormEditorSupport.this.getFormDesignerTC();
                if (designerTC != null) {
                    FormEditorSupport.this.formEditor.closeForm();
                    designerTC.resetDesigner(true);
                }
            }
        });
        return docLoadTask;
    }

    public FormEditor reloadFormEditor() {
        if (!this.isOpened()) {
            return null;
        }
        FormDesignerTC designerTC = this.getFormDesignerTC();
        this.formEditor.closeForm();
        boolean success = this.formEditor.loadForm();
        if (designerTC != null) {
            if (success) {
                designerTC.resetDesigner(true);
            } else {
                this.closeFormEditor();
            }
        }
        this.reportErrors();
        return this.formEditor;
    }

    public void closeFormEditor() {
        if (this.isOpened()) {
            final FormDesignerTC designerTC = this.getFormDesignerTC();
            this.formEditor.closeForm();
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    if (designerTC != null) {
                        designerTC.resetDesigner(false);
                    }
                    FormEditorSupport.this.selectJavaEditor();
                }
            };
            if (EventQueue.isDispatchThread()) {
                run.run();
            } else {
                try {
                    EventQueue.invokeAndWait(run);
                }
                catch (Exception ex) {
                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                }
            }
        }
    }

    protected void notifyClosed() {
        opened.remove((Object)this);
        if (opened.isEmpty()) {
            FormEditorSupport.detachTopComponentsListener();
            FormEditorSupport.detachStatusListeners();
        }
        super.notifyClosed();
        if (this.formEditor != null) {
            this.formEditor.closeForm();
            this.formEditor = null;
        }
        this.nodeListener = null;
        this.multiviewTC = null;
        this.guardedProvider = null;
        this.guardedEditor = null;
        this.elementToOpen = 0;
    }

    private void multiViewClosed(CloneableTopComponent mvtc) {
        boolean isLast;
        Enumeration en = mvtc.getReference().getComponents();
        boolean bl = isLast = !en.hasMoreElements();
        if (this.multiviewTC == mvtc) {
            this.multiviewTC = null;
            FormDesignerTC designerTC = null;
            while (en.hasMoreElements()) {
                this.multiviewTC = (CloneableTopComponent)en.nextElement();
                designerTC = this.getFormDesignerTC();
                if (designerTC == null) continue;
            }
            if (!isLast && designerTC == null && this.formEditor != null) {
                this.formEditor.closeForm();
                this.formEditor = null;
            }
        }
        if (isLast) {
            this.notifyClosed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean notifyModified() {
        boolean alreadyModified = this.isModified();
        boolean retVal = super.notifyModified();
        if (retVal) {
            this.addSaveCookie();
        }
        if (!alreadyModified) {
            FileObject formFile = this.formDataObject.getFormFile();
            if (!formFile.canWrite()) {
                FileLock lock = null;
                try {
                    lock = formFile.lock();
                }
                catch (UserQuestionException uqex) {
                    NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)uqex.getLocalizedMessage(), FormUtils.getBundleString((String)"TITLE_UserQuestion"), 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                    if (NotifyDescriptor.YES_OPTION.equals(nd.getValue())) {
                        try {
                            uqex.confirmed();
                            EventQueue.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    FormEditorSupport.this.reloadForm();
                                }
                            });
                        }
                        catch (IOException ioex) {
                            ErrorManager.getDefault().notify(1, (Throwable)ioex);
                        }
                    }
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                }
                finally {
                    if (lock != null) {
                        lock.releaseLock();
                    }
                }
            }
            this.updateMVTCDisplayName();
        }
        return retVal;
    }

    protected void notifyUnmodified() {
        super.notifyUnmodified();
        this.removeSaveCookie();
        this.updateMVTCDisplayName();
    }

    private static void attachTopComponentsListener() {
        if (topcompsListener != null) {
            return;
        }
        topcompsListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent ev) {
                if ("opened".equals(ev.getPropertyName())) {
                    FormEditorSupport fes;
                    TopComponent active;
                    Set oldSet = (Set)ev.getOldValue();
                    Set newSet = (Set)ev.getNewValue();
                    if (newSet.size() < oldSet.size()) {
                        for (Object o : oldSet) {
                            FormEditorSupport fes2;
                            CloneableTopComponent closedTC;
                            if (newSet.contains(o) || !(o instanceof CloneableTopComponent) || FormEditorSupport.getSelectedElementType((TopComponent)(closedTC = (CloneableTopComponent)o)) == -1 || (fes2 = FormEditorSupport.getFormEditor((TopComponent)closedTC)) == null) continue;
                            fes2.multiViewClosed(closedTC);
                        }
                    }
                    if ((active = TopComponent.getRegistry().getActivated()) != null && FormEditorSupport.getSelectedElementType(active) != -1 && (fes = FormEditorSupport.getFormEditor(active)) != null) {
                        fes.updateMVTCDisplayName();
                    }
                }
            }
        };
        TopComponent.getRegistry().addPropertyChangeListener(topcompsListener);
    }

    private static void detachTopComponentsListener() {
        if (topcompsListener != null) {
            TopComponent.getRegistry().removePropertyChangeListener(topcompsListener);
            topcompsListener = null;
            TopComponentGroup group = WindowManager.getDefault().findTopComponentGroup(MV_FORM_ID);
            if (group != null) {
                group.close();
            }
        }
    }

    private void postCreationUpdate1() {
        Object className;
        FileObject fob = this.formDataObject.getPrimaryFile();
        Object libName = fob.getAttribute("requiredLibrary");
        if (!(libName == null || (className = fob.getAttribute("requiredClass")) != null && ClassPathUtils.isOnClassPath((FileObject)fob, (String)className.toString()))) {
            try {
                Library lib = LibraryManager.getDefault().getLibrary((String)libName);
                ClassPathUtils.updateProject((FileObject)fob, (ClassSource)new ClassSource(className == null ? null : className.toString(), new ClassSource.Entry[]{new ClassSourceResolver.LibraryEntry(lib)}));
            }
            catch (IOException ioex) {
                Logger.getLogger(FormEditorSupport.class.getName()).log(Level.INFO, ioex.getLocalizedMessage(), ioex);
            }
        }
    }

    private void postCreationUpdate2() {
        if (this.formEditor.postCreationUpdate()) {
            try {
                this.checkSuppressWarningsAnnotation();
                if (this.isModified()) {
                    this.saveDocument();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(FormEditorSupport.class.getName()).log(Level.INFO, ex.getLocalizedMessage(), ex);
            }
        }
    }

    private void checkSuppressWarningsAnnotation() throws IOException {
        FileObject fo = this.getFormDataObject().getPrimaryFile();
        String sourceLevel = SourceLevelQuery.getSourceLevel((FileObject)fo);
        boolean invalidSL = sourceLevel != null && "1.5".compareTo(sourceLevel) > 0;
        ClassPath cp = ClassPath.getClassPath((FileObject)fo, (String)"classpath/boot");
        if (invalidSL || cp.findResource("java/lang/SuppressWarnings.class") == null) {
            final String foName = fo.getName();
            JavaSource js = JavaSource.forFileObject((FileObject)fo);
            final int[] positions = new int[]{-1, -1};
            js.runModificationTask((org.netbeans.api.java.source.Task)new CancellableTask<WorkingCopy>(){

                public void cancel() {
                }

                public void run(WorkingCopy wcopy) throws Exception {
                    wcopy.toPhase(JavaSource.Phase.RESOLVED);
                    ClassTree clazz = null;
                    CompilationUnitTree cu = wcopy.getCompilationUnit();
                    for (Tree tree : cu.getTypeDecls()) {
                        ClassTree cand;
                        if (!TreeUtilities.CLASS_TREE_KINDS.contains((Object)tree.getKind()) || !foName.equals((cand = (ClassTree)tree).getSimpleName().toString())) continue;
                        clazz = cand;
                    }
                    if (clazz == null) {
                        return;
                    }
                    for (Tree tree : clazz.getMembers()) {
                        MethodTree method;
                        if (tree.getKind() != Tree.Kind.METHOD || !"initComponents".equals((method = (MethodTree)tree).getName().toString()) || !method.getParameters().isEmpty()) continue;
                        ModifiersTree modifiers = method.getModifiers();
                        for (AnnotationTree annotationTree : modifiers.getAnnotations()) {
                            if (!annotationTree.getAnnotationType().toString().contains("SuppressWarnings")) continue;
                            SourcePositions sp = wcopy.getTrees().getSourcePositions();
                            positions[0] = (int)sp.getStartPosition(cu, annotationTree);
                            positions[1] = (int)sp.getEndPosition(cu, annotationTree);
                        }
                    }
                }
            }).commit();
            if (positions[0] != -1) {
                try {
                    this.getFormDataObject().getFormEditorSupport().getDocument().remove(positions[0], positions[1] - positions[0]);
                }
                catch (BadLocationException blex) {
                    Logger.getLogger(FormEditor.class.getName()).log(Level.INFO, blex.getLocalizedMessage(), blex);
                }
            }
        }
    }

    protected CloneableEditorSupport.Pane createPane() {
        if (!this.formDataObject.isValid()) {
            return super.createPane();
        }
        CloneableTopComponent mvtc = MultiViews.createCloneableMultiView((String)"text/x-form", (Serializable)this.getDataObject());
        Mode editorMode = WindowManager.getDefault().findMode("editor");
        if (editorMode != null) {
            editorMode.dockInto((TopComponent)mvtc);
        }
        return (CloneableEditorSupport.Pane)mvtc;
    }

    private static boolean readOnly(FormDataObject formDataObject) {
        FormModel fm;
        FormEditorSupport fes;
        if (!formDataObject.getPrimaryFile().canWrite()) {
            return true;
        }
        TopComponent active = TopComponent.getRegistry().getActivated();
        if (active != null && FormEditorSupport.getSelectedElementType(active) == 2 && (fes = (FormEditorSupport)formDataObject.getFormEditorSupport()) != null && (fm = fes.getFormModel()) != null) {
            return fm.isReadOnly();
        }
        return false;
    }

    private static String getMVTCToolTipText(FormDataObject formDataObject) {
        return DataEditorSupport.toolTip((FileObject)formDataObject.getPrimaryFile(), (boolean)formDataObject.isModified(), (boolean)FormEditorSupport.readOnly(formDataObject));
    }

    private static String[] getMVTCDisplayName(FormDataObject formDataObject) {
        FormDesigner fd;
        FormModel fm;
        FormDesignerTC designerTC;
        FormEditorSupport fes;
        Node node = formDataObject.getNodeDelegate();
        String title = node.getDisplayName();
        String htmlTitle = node.getHtmlDisplayName();
        if (htmlTitle == null) {
            try {
                htmlTitle = XMLUtil.toElementContent((String)title);
            }
            catch (CharConversionException x) {
                htmlTitle = "???";
            }
        }
        if ((fes = (FormEditorSupport)formDataObject.getFormEditorSupport()) != null && (designerTC = fes.getFormDesignerTC()) != null && designerTC.isShowing() && (fm = fes.getFormModel()) != null && (fd = FormEditor.getFormDesigner((FormModel)fes.getFormModel())) != null && fd.getFormModel() != null && !fd.isTopRADComponent() && fd.getTopDesignComponent() != null) {
            title = FormUtils.getFormattedBundleString((String)"FMT_FormTitleWithContainerName", (Object[])new Object[]{title, fd.getTopDesignComponent().getName()});
            htmlTitle = FormUtils.getFormattedBundleString((String)"FMT_FormTitleWithContainerName", (Object[])new Object[]{htmlTitle, fd.getTopDesignComponent().getName()});
        }
        boolean modified = formDataObject.isModified();
        boolean readOnly = FormEditorSupport.readOnly(formDataObject);
        return new String[]{DataEditorSupport.annotateName((String)title, (boolean)false, (boolean)modified, (boolean)readOnly), DataEditorSupport.annotateName((String)htmlTitle, (boolean)true, (boolean)modified, (boolean)readOnly)};
    }

    protected String messageName() {
        String[] titles = FormEditorSupport.getMVTCDisplayName(this.formDataObject);
        return titles[0];
    }

    protected String messageHtmlName() {
        String[] titles = FormEditorSupport.getMVTCDisplayName(this.formDataObject);
        return titles[1];
    }

    void updateMVTCDisplayName() {
        if (EventQueue.isDispatchThread()) {
            this.updateMVTCDisplayNameInAWT();
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FormEditorSupport.this.updateMVTCDisplayNameInAWT();
                }
            });
        }
    }

    private void updateMVTCDisplayNameInAWT() {
        if (this.multiviewTC == null || !this.formDataObject.isValid()) {
            return;
        }
        String[] titles = FormEditorSupport.getMVTCDisplayName(this.formDataObject);
        Enumeration en = this.multiviewTC.getReference().getComponents();
        while (en.hasMoreElements()) {
            TopComponent tc = (TopComponent)en.nextElement();
            tc.setDisplayName(titles[0]);
            tc.setHtmlDisplayName(titles[1]);
        }
    }

    void updateMVTCToolTipText() {
        if (EventQueue.isDispatchThread()) {
            if (this.multiviewTC == null) {
                return;
            }
            String tooltip = FormEditorSupport.getMVTCToolTipText(this.formDataObject);
            Enumeration en = this.multiviewTC.getReference().getComponents();
            while (en.hasMoreElements()) {
                TopComponent tc = (TopComponent)en.nextElement();
                tc.setToolTipText(tooltip);
            }
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (FormEditorSupport.this.multiviewTC == null) {
                        return;
                    }
                    String tooltip = FormEditorSupport.getMVTCToolTipText(FormEditorSupport.this.formDataObject);
                    Enumeration en = FormEditorSupport.this.multiviewTC.getReference().getComponents();
                    while (en.hasMoreElements()) {
                        TopComponent tc = (TopComponent)en.nextElement();
                        tc.setToolTipText(tooltip);
                    }
                }
            });
        }
    }

    final CloseOperationState canCloseElement(TopComponent tc) {
        if (!FormEditorSupport.isLastView(tc)) {
            return CloseOperationState.STATE_OK;
        }
        if (!this.isModified()) {
            return CloseOperationState.STATE_OK;
        }
        AbstractAction save = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    FormEditorSupport.this.saveDocument();
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        };
        save.putValue("LongDescription", Bundle.MSG_MODIFIED(this.getDataObject().getPrimaryFile().getNameExt()));
        return MultiViewFactory.createUnsafeCloseState((String)"ID_FORM_CLOSING", (Action)save, (Action)MultiViewFactory.NOOP_CLOSE_ACTION);
    }

    static boolean isLastView(TopComponent tc) {
        if (!(tc instanceof CloneableTopComponent)) {
            return false;
        }
        boolean oneOrLess = true;
        Enumeration en = ((CloneableTopComponent)tc).getReference().getComponents();
        if (en.hasMoreElements()) {
            en.nextElement();
            if (en.hasMoreElements()) {
                oneOrLess = false;
            }
        }
        return oneOrLess;
    }

    void setTopComponent(TopComponent topComp) {
        this.multiviewTC = (CloneableTopComponent)topComp;
        String[] titles = FormEditorSupport.getMVTCDisplayName(this.formDataObject);
        this.multiviewTC.setDisplayName(titles[0]);
        this.multiviewTC.setHtmlDisplayName(titles[1]);
        this.multiviewTC.setToolTipText(FormEditorSupport.getMVTCToolTipText(this.formDataObject));
        opened.add(this);
        this.registerNodeListener();
        FormEditorSupport.attachTopComponentsListener();
        try {
            this.addStatusListener(this.formDataObject.getPrimaryFile().getFileSystem());
        }
        catch (FileStateInvalidException fsiex) {
            fsiex.printStackTrace();
        }
    }

    public static FormEditorSupport getFormEditor(TopComponent tc) {
        Object dobj = tc.getLookup().lookup(DataObject.class);
        FormEditorSupport fes = null;
        if (dobj instanceof FormDataObject) {
            FormDataObject formDataObject = (FormDataObject)dobj;
            fes = (FormEditorSupport)formDataObject.getFormEditorSupport();
        }
        return fes;
    }

    public boolean isJavaEditorDisplayed() {
        JEditorPane[] jeditPane;
        boolean showing = false;
        if (EventQueue.isDispatchThread() && (jeditPane = this.getOpenedPanes()) != null) {
            for (int i = 0; i < jeditPane.length && !(showing = jeditPane[i].isShowing()); ++i) {
            }
        }
        return showing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean getFoldState(int offset) {
        FoldHierarchy hierarchy;
        JEditorPane[] panes;
        if (EventQueue.isDispatchThread() && (panes = this.getOpenedPanes()) != null && panes.length > 0 && (hierarchy = FoldHierarchy.get((JTextComponent)panes[0])) != null) {
            try {
                hierarchy.lock();
                Fold fold = FoldUtilities.findNearestFold((FoldHierarchy)hierarchy, (int)offset);
                if (fold != null) {
                    Boolean bl = fold.isCollapsed();
                    return bl;
                }
            }
            finally {
                hierarchy.unlock();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreFoldState(boolean collapse, int startOffset, int endOffset) {
        FoldHierarchy hierarchy;
        if (collapse) {
            return;
        }
        JEditorPane[] panes = this.getOpenedPanes();
        if (panes != null && panes.length > 0 && (hierarchy = FoldHierarchy.get((JTextComponent)panes[0])) != null) {
            try {
                hierarchy.lock();
                Fold fold = FoldUtilities.findCollapsedFold((FoldHierarchy)hierarchy, (int)startOffset, (int)endOffset);
                if (fold != null) {
                    hierarchy.expand(fold);
                } else {
                    if (this.foldHierarchyListener == null) {
                        this.foldHierarchyListener = new FoldHierarchyListener();
                    } else {
                        hierarchy.removeFoldHierarchyListener((org.netbeans.api.editor.fold.FoldHierarchyListener)this.foldHierarchyListener);
                    }
                    hierarchy.addFoldHierarchyListener((org.netbeans.api.editor.fold.FoldHierarchyListener)this.foldHierarchyListener);
                    this.foldHierarchyListener.setOffsets(startOffset, endOffset);
                }
            }
            finally {
                hierarchy.unlock();
            }
        }
    }

    static void checkFormGroupVisibility() {
        WindowManager wm = WindowManager.getDefault();
        TopComponentGroup group = wm.findTopComponentGroup(MV_FORM_ID);
        if (group == null) {
            return;
        }
        boolean designerSelected = false;
        for (Mode mode : wm.getModes()) {
            TopComponent selected = mode.getSelectedTopComponent();
            if (FormEditorSupport.getSelectedElementType(selected) != 2) continue;
            designerSelected = true;
            break;
        }
        if (designerSelected && !Boolean.TRUE.equals(groupVisible)) {
            groupVisible = Boolean.FALSE;
            group.open();
            groupVisible = Boolean.TRUE;
            TopComponentGroup paletteGroup = wm.findTopComponentGroup("commonpalette");
            if (null != paletteGroup) {
                paletteGroup.open();
            }
        } else if (!designerSelected && !Boolean.FALSE.equals(groupVisible)) {
            group.close();
            groupVisible = Boolean.FALSE;
        }
    }

    static int getSelectedElementType(TopComponent tc) {
        MultiViewHandler handler;
        if (tc != null && (handler = MultiViews.findMultiViewHandler((TopComponent)tc)) != null) {
            String prefId = handler.getSelectedPerspective().preferredID();
            if (MV_JAVA_ID.equals(prefId)) {
                return 0;
            }
            if (MV_FORM_ID.equals(prefId)) {
                return 2;
            }
        }
        return -1;
    }

    public Object getJavaContext() {
        return null;
    }

    public int getCodeIndentSize() {
        CodeStyle cs = CodeStyle.getDefault((FileObject)this.getFormDataObject().getPrimaryFile());
        return cs != null ? cs.getIndentSize() : 4;
    }

    public boolean getCodeBraceOnNewLine() {
        CodeStyle cs = CodeStyle.getDefault((FileObject)this.getFormDataObject().getPrimaryFile());
        return cs != null ? cs.getMethodDeclBracePlacement() != CodeStyle.BracePlacement.SAME_LINE : false;
    }

    public SimpleSection getVariablesSection() {
        return this.getGuardedSectionManager().findSimpleSection("variables");
    }

    public SimpleSection getInitComponentSection() {
        return this.getGuardedSectionManager().findSimpleSection("initComponents");
    }

    public GuardedSectionManager getGuardedSectionManager() {
        try {
            StyledDocument doc;
            block5: {
                doc = null;
                try {
                    doc = this.openDocument();
                }
                catch (UserQuestionException uqex) {
                    Object retVal = DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)uqex.getLocalizedMessage(), 0));
                    if (NotifyDescriptor.YES_OPTION != retVal) break block5;
                    uqex.confirmed();
                    doc = this.openDocument();
                }
            }
            if (doc == null) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FormEditorSupport.this.close();
                    }
                });
                return null;
            }
            return GuardedSectionManager.getInstance((StyledDocument)doc);
        }
        catch (IOException ex) {
            throw new IllegalStateException("cannot open document", ex);
        }
    }

    public boolean canGenerateNBMnemonicsCode() {
        FileObject srcFile = this.getFormDataObject().getPrimaryFile();
        return FormEditorSupport.isNBMProject(srcFile) || ClassPathUtils.checkUserClass((String)"org.openide.awt.Mnemonics", (FileObject)srcFile);
    }

    private static boolean isNBMProject(FileObject srcFile) {
        Project p = FileOwnerQuery.getOwner((FileObject)srcFile);
        return p != null && p.getClass().getName().startsWith("org.netbeans.modules.apisupport.") && p.getClass().getName().endsWith("Project");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadFromStreamToKit(StyledDocument doc, InputStream stream, EditorKit kit) throws IOException, BadLocationException {
        if (this.guardedEditor == null) {
            this.guardedEditor = new FormGEditor();
            GuardedSectionsFactory gFactory = GuardedSectionsFactory.find((String)((DataEditorSupport.Env)this.env).getMimeType());
            if (gFactory != null) {
                this.guardedProvider = gFactory.create((GuardedEditorSupport)this.guardedEditor);
            }
        }
        if (this.guardedProvider != null) {
            this.guardedEditor.doc = doc;
            Charset c = FileEncodingQuery.getEncoding((FileObject)this.getDataObject().getPrimaryFile());
            Reader reader = this.guardedProvider.createGuardedReader(stream, c);
            try {
                kit.read(reader, (Document)doc, 0);
            }
            finally {
                reader.close();
            }
        } else {
            super.loadFromStreamToKit(doc, stream, kit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveFromKitToStream(StyledDocument doc, EditorKit kit, OutputStream stream) throws IOException, BadLocationException {
        if (this.guardedProvider != null) {
            Charset c = FileEncodingQuery.getEncoding((FileObject)this.getDataObject().getPrimaryFile());
            Writer writer = this.guardedProvider.createGuardedWriter(stream, c);
            try {
                kit.write(writer, (Document)doc, 0, doc.getLength());
            }
            finally {
                writer.close();
            }
        } else {
            super.saveFromKitToStream(doc, kit, stream);
        }
    }

    public void addSaveCookie() {
        DataObject javaData = this.getDataObject();
        if (javaData.getCookie(SaveCookie.class) == null) {
            this.cookies.add((Node.Cookie)this.saveCookie);
            javaData.setModified(true);
        }
    }

    public void removeSaveCookie() {
        DataObject javaData = this.getDataObject();
        if (javaData.getCookie(SaveCookie.class) != null) {
            this.cookies.remove((Node.Cookie)this.saveCookie);
            javaData.setModified(false);
        }
    }

    static {
        opened = Collections.synchronizedSet(new HashSet());
        fsToStatusListener = new HashMap<FileSystem, FileStatusListener>();
        groupVisible = null;
    }

    private static final class Environment
    extends DataEditorSupport.Env {
        private static final long serialVersionUID = -1L;

        public Environment(DataObject obj) {
            super(obj);
        }

        protected FileObject getFile() {
            return this.getDataObject().getPrimaryFile();
        }

        protected FileLock takeLock() throws IOException {
            return ((FormDataObject)this.getDataObject()).getPrimaryEntry().takeLock();
        }

        public CloneableOpenSupport findCloneableOpenSupport() {
            return (CloneableOpenSupport)this.getDataObject().getCookie(FormEditorSupport.class);
        }
    }

    public static class JavaMultiViewEditorElement
    extends MultiViewEditorElement {
        private static final long serialVersionUID = -3126744316624172415L;
        private DataObject dataObject;
        private transient FormEditorSupport javaEditor;
        private transient MultiViewElementCallback multiViewObserver;

        public JavaMultiViewEditorElement(Lookup context) {
            super(context);
            this.dataObject = (DataObject)context.lookup(DataObject.class);
            this.javaEditor = (FormEditorSupport)((Object)context.lookup(FormEditorSupport.class));
            if (this.javaEditor != null) {
                this.javaEditor.prepareDocument();
            }
        }

        public void setMultiViewCallback(MultiViewElementCallback callback) {
            this.multiViewObserver = callback;
            if (this.dataObject instanceof FormDataObject) {
                FormDataObject formDataObject = (FormDataObject)this.dataObject;
                FormEditorSupport fes = (FormEditorSupport)formDataObject.getFormEditorSupport();
                if (this.javaEditor == null) {
                    this.javaEditor = fes;
                }
                fes.setTopComponent(callback.getTopComponent());
            }
            super.setMultiViewCallback(callback);
        }

        public void componentShowing() {
            CodeGenerator codeGen;
            FormModel model;
            FormDataObject formDO;
            FormEditorSupport fe;
            super.componentShowing();
            if (this.dataObject instanceof FormDataObject && (fe = (FormEditorSupport)(formDO = (FormDataObject)this.dataObject).getFormEditorSupport()) != null && (model = fe.getFormModel()) != null && (codeGen = FormEditor.getCodeGenerator((FormModel)model)) != null) {
                codeGen.regenerateCode();
            }
        }

        public CloseOperationState canCloseElement() {
            if (this.javaEditor == null) {
                return CloseOperationState.STATE_OK;
            }
            return this.javaEditor.canCloseElement(this.multiViewObserver.getTopComponent());
        }
    }

    private static final class FormGEditor
    implements GuardedEditorSupport {
        StyledDocument doc = null;

        private FormGEditor() {
        }

        public StyledDocument getDocument() {
            return this.doc;
        }
    }

    private static class FoldHierarchyListener
    implements org.netbeans.api.editor.fold.FoldHierarchyListener {
        private int startOffset = -1;
        private int endOffset;

        private FoldHierarchyListener() {
        }

        private void setOffsets(int startOffset, int endOffset) {
            this.startOffset = startOffset;
            this.endOffset = endOffset;
        }

        public void foldHierarchyChanged(FoldHierarchyEvent evt) {
            FoldHierarchy hierarchy;
            Fold fold;
            if (this.startOffset >= 0 && evt.getAddedFoldCount() > 0 && evt.getAffectedStartOffset() < this.endOffset && evt.getAffectedEndOffset() > this.startOffset && evt.getSource() instanceof FoldHierarchy && (fold = FoldUtilities.findCollapsedFold((FoldHierarchy)(hierarchy = (FoldHierarchy)evt.getSource()), (int)this.startOffset, (int)this.endOffset)) != null) {
                this.startOffset = -1;
                hierarchy.expand(fold);
            }
        }
    }
}

