/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.reference;

import java.util.LinkedHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.reference.AccessTranslator;
import org.jetbrains.kotlin.js.translate.reference.ArrayAccessTranslator;
import org.jetbrains.kotlin.js.translate.reference.DefaultAccessTranslator;
import org.jetbrains.kotlin.js.translate.reference.QualifiedExpressionTranslator;
import org.jetbrains.kotlin.js.translate.reference.ReferenceTranslator;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;

public final class AccessTranslationUtils {
    private AccessTranslationUtils() {
    }

    @NotNull
    public static AccessTranslator getAccessTranslator(@NotNull KtExpression referenceExpression, @NotNull TranslationContext context) {
        if (referenceExpression == null) {
            AccessTranslationUtils.$$$reportNull$$$1(0);
        }
        if (context == null) {
            AccessTranslationUtils.$$$reportNull$$$1(1);
        }
        if (referenceExpression == null) {
            AccessTranslationUtils.$$$reportNull$$$0(0);
        }
        if (context == null) {
            AccessTranslationUtils.$$$reportNull$$$0(1);
        }
        AccessTranslator accessTranslator = AccessTranslationUtils.getAccessTranslator(referenceExpression, context, false);
        if (accessTranslator == null) {
            AccessTranslationUtils.$$$reportNull$$$0(2);
        }
        if (accessTranslator == null) {
            AccessTranslationUtils.$$$reportNull$$$1(2);
        }
        return accessTranslator;
    }

    @NotNull
    public static AccessTranslator getAccessTranslator(@NotNull KtExpression referenceExpression, @NotNull TranslationContext context, boolean forceOrderOfEvaluation) {
        if (referenceExpression == null) {
            AccessTranslationUtils.$$$reportNull$$$1(3);
        }
        if (context == null) {
            AccessTranslationUtils.$$$reportNull$$$1(4);
        }
        if (referenceExpression == null) {
            AccessTranslationUtils.$$$reportNull$$$0(3);
        }
        if (context == null) {
            AccessTranslationUtils.$$$reportNull$$$0(4);
        }
        referenceExpression = KtPsiUtil.deparenthesize(referenceExpression);
        assert (referenceExpression != null);
        if (referenceExpression instanceof KtQualifiedExpression) {
            AccessTranslator accessTranslator = QualifiedExpressionTranslator.getAccessTranslator((KtQualifiedExpression)referenceExpression, context, forceOrderOfEvaluation);
            if (accessTranslator == null) {
                AccessTranslationUtils.$$$reportNull$$$0(5);
            }
            if (accessTranslator == null) {
                AccessTranslationUtils.$$$reportNull$$$1(5);
            }
            return accessTranslator;
        }
        if (referenceExpression instanceof KtSimpleNameExpression) {
            AccessTranslator accessTranslator = ReferenceTranslator.getAccessTranslator((KtSimpleNameExpression)referenceExpression, context);
            if (accessTranslator == null) {
                AccessTranslationUtils.$$$reportNull$$$0(6);
            }
            if (accessTranslator == null) {
                AccessTranslationUtils.$$$reportNull$$$1(6);
            }
            return accessTranslator;
        }
        if (referenceExpression instanceof KtArrayAccessExpression) {
            AccessTranslator accessTranslator = AccessTranslationUtils.getArrayAccessTranslator((KtArrayAccessExpression)referenceExpression, context, forceOrderOfEvaluation);
            if (accessTranslator == null) {
                AccessTranslationUtils.$$$reportNull$$$0(7);
            }
            if (accessTranslator == null) {
                AccessTranslationUtils.$$$reportNull$$$1(7);
            }
            return accessTranslator;
        }
        DefaultAccessTranslator defaultAccessTranslator = new DefaultAccessTranslator(referenceExpression, context);
        if (defaultAccessTranslator == null) {
            AccessTranslationUtils.$$$reportNull$$$0(8);
        }
        if (defaultAccessTranslator == null) {
            AccessTranslationUtils.$$$reportNull$$$1(8);
        }
        return defaultAccessTranslator;
    }

    @NotNull
    private static AccessTranslator getArrayAccessTranslator(@NotNull KtArrayAccessExpression expression2, @NotNull TranslationContext context, boolean forceOrderOfEvaluation) {
        TranslationContext accessArrayContext;
        if (expression2 == null) {
            AccessTranslationUtils.$$$reportNull$$$1(9);
        }
        if (context == null) {
            AccessTranslationUtils.$$$reportNull$$$1(10);
        }
        if (expression2 == null) {
            AccessTranslationUtils.$$$reportNull$$$0(9);
        }
        if (context == null) {
            AccessTranslationUtils.$$$reportNull$$$0(10);
        }
        if (forceOrderOfEvaluation) {
            LinkedHashMap<KtExpression, JsExpression> indexesMap = new LinkedHashMap<KtExpression, JsExpression>();
            for (KtExpression indexExpression : expression2.getIndexExpressions()) {
                JsExpression jsIndexExpression = context.cacheExpressionIfNeeded(Translation.translateAsExpression(indexExpression, context));
                indexesMap.put(indexExpression, jsIndexExpression);
            }
            accessArrayContext = context.innerContextWithAliasesForExpressions(indexesMap);
        } else {
            accessArrayContext = context;
        }
        ArrayAccessTranslator arrayAccessTranslator = ArrayAccessTranslator.newInstance(expression2, accessArrayContext);
        if (arrayAccessTranslator == null) {
            AccessTranslationUtils.$$$reportNull$$$0(11);
        }
        if (arrayAccessTranslator == null) {
            AccessTranslationUtils.$$$reportNull$$$1(11);
        }
        return arrayAccessTranslator;
    }

    @NotNull
    public static JsExpression translateAsGet(@NotNull KtExpression expression2, @NotNull TranslationContext context) {
        if (expression2 == null) {
            AccessTranslationUtils.$$$reportNull$$$1(12);
        }
        if (context == null) {
            AccessTranslationUtils.$$$reportNull$$$1(13);
        }
        if (expression2 == null) {
            AccessTranslationUtils.$$$reportNull$$$0(12);
        }
        if (context == null) {
            AccessTranslationUtils.$$$reportNull$$$0(13);
        }
        JsExpression jsExpression = AccessTranslationUtils.getAccessTranslator(expression2, context).translateAsGet();
        if (jsExpression == null) {
            AccessTranslationUtils.$$$reportNull$$$0(14);
        }
        if (jsExpression == null) {
            AccessTranslationUtils.$$$reportNull$$$1(14);
        }
        return jsExpression;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
            case 1: 
            case 4: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/js/translate/reference/AccessTranslationUtils";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/js/translate/reference/AccessTranslationUtils";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessTranslator";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getArrayAccessTranslator";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "translateAsGet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAccessTranslator";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 14: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getArrayAccessTranslator";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "translateAsGet";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static /* synthetic */ void $$$reportNull$$$1(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
            case 1: 
            case 4: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/js/translate/reference/AccessTranslationUtils";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/js/translate/reference/AccessTranslationUtils";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessTranslator";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getArrayAccessTranslator";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "translateAsGet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAccessTranslator";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 14: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getArrayAccessTranslator";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "translateAsGet";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

